/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.util;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.charts.ChartTheme;
import net.sf.jasperreports.charts.ChartThemeBundle;
import net.sf.jasperreports.charts.util.ChartHyperlinkProvider;
import net.sf.jasperreports.charts.util.ChartRendererFactory;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImageArea;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.DefaultChartTheme;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSingletonCache;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;

public final class ChartUtil {
    private static final JRSingletonCache CHART_RENDERER_FACTORY_CACHE = new JRSingletonCache(ChartRendererFactory.class);

    public static List getImageAreaHyperlinks(JFreeChart chart, ChartHyperlinkProvider chartHyperlinkProvider, Graphics2D grx, Rectangle2D renderingArea) {
        ArrayList<JRPrintImageAreaHyperlink> areaHyperlinks = null;
        if (chartHyperlinkProvider != null && chartHyperlinkProvider.hasHyperlinks()) {
            ChartRenderingInfo renderingInfo = new ChartRenderingInfo();
            if (grx == null) {
                chart.createBufferedImage((int)renderingArea.getWidth(), (int)renderingArea.getHeight(), renderingInfo);
            } else {
                chart.draw(grx, renderingArea, renderingInfo);
            }
            EntityCollection entityCollection = renderingInfo.getEntityCollection();
            if (entityCollection != null && entityCollection.getEntityCount() > 0) {
                areaHyperlinks = new ArrayList<JRPrintImageAreaHyperlink>(entityCollection.getEntityCount());
                for (ChartEntity entity : entityCollection) {
                    JRPrintHyperlink printHyperlink = chartHyperlinkProvider.getEntityHyperlink(entity);
                    if (printHyperlink == null) continue;
                    JRPrintImageArea area = ChartUtil.getImageArea(entity);
                    JRPrintImageAreaHyperlink areaHyperlink = new JRPrintImageAreaHyperlink();
                    areaHyperlink.setArea(area);
                    areaHyperlink.setHyperlink(printHyperlink);
                    areaHyperlinks.add(areaHyperlink);
                }
            }
        }
        return areaHyperlinks;
    }

    private static JRPrintImageArea getImageArea(ChartEntity entity) {
        JRPrintImageArea area = new JRPrintImageArea();
        area.setShape(JRPrintImageArea.getShape(entity.getShapeType()));
        int[] coordinates = ChartUtil.getCoordinates(entity);
        if (coordinates != null) {
            area.setCoordinates(coordinates);
        }
        return area;
    }

    private static int[] getCoordinates(ChartEntity entity) {
        int[] coordinates = null;
        String shapeCoords = entity.getShapeCoords();
        if (shapeCoords != null && shapeCoords.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(shapeCoords, ",");
            coordinates = new int[tokens.countTokens()];
            int idx = 0;
            while (tokens.hasMoreTokens()) {
                String coord = tokens.nextToken();
                coordinates[idx] = Integer.parseInt(coord);
                ++idx;
            }
        }
        return coordinates;
    }

    public static ChartTheme getChartTheme(String themeName) {
        if (themeName == null) {
            return new DefaultChartTheme();
        }
        List themeBundles = ExtensionsEnvironment.getExtensionsRegistry().getExtensions(ChartThemeBundle.class);
        for (ChartThemeBundle bundle : themeBundles) {
            ChartTheme chartTheme = bundle.getChartTheme(themeName);
            if (chartTheme == null) continue;
            return chartTheme;
        }
        throw new JRRuntimeException("Chart theme '" + themeName + "' not found.");
    }

    public static ChartRendererFactory getChartRendererFactory(String renderType) {
        ChartRendererFactory chartRendererFactory = null;
        String factoryClass = JRProperties.getProperty("net.sf.jasperreports.chart.renderer.factory." + renderType);
        if (factoryClass == null) {
            throw new JRRuntimeException("No chart renderer factory specifyed for '" + renderType + "' render type.");
        }
        try {
            chartRendererFactory = (ChartRendererFactory)CHART_RENDERER_FACTORY_CACHE.getCachedInstance(factoryClass);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        return chartRendererFactory;
    }

    private ChartUtil() {
    }
}

