/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.ant;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRApiWriter;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.ReportCreator;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.RegexpPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class JRAntApiWriteTask
extends MatchingTask {
    private Path src = null;
    private File destdir = null;
    private Path classpath = null;
    private boolean runApi = false;
    private Map reportFilesMap = null;

    public void setSrcdir(Path srcdir) {
        if (this.src == null) {
            this.src = srcdir;
        } else {
            this.src.append(srcdir);
        }
    }

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setRunApi(boolean runApi) {
        this.runApi = runApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.checkParameters();
        this.reportFilesMap = new HashMap();
        JRProperties.backupProperties();
        try {
            AntClassLoader classLoader = null;
            if (this.classpath != null) {
                JRProperties.setProperty("net.sf.jasperreports.compiler.classpath", String.valueOf(this.classpath));
                ClassLoader parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
                classLoader = new AntClassLoader(parentClassLoader, this.getProject(), this.classpath, true);
                classLoader.setThreadContextLoader();
            }
            try {
                this.scanSrc();
                if (this.runApi) {
                    this.runApi();
                } else {
                    this.writeApi();
                }
            }
            finally {
                if (classLoader != null) {
                    classLoader.resetThreadContextLoader();
                }
            }
        }
        finally {
            JRProperties.restoreProperties();
        }
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null || this.src.size() == 0) {
            throw new BuildException("The srcdir attribute must be set.", this.getLocation());
        }
        if (this.destdir != null && !this.destdir.isDirectory()) {
            throw new BuildException("The destination directory \"" + this.destdir + "\" does not exist " + "or is not a directory.", this.getLocation());
        }
    }

    protected void scanSrc() throws BuildException {
        for (Resource resource : this.src) {
            FileResource fileResource = resource instanceof FileResource ? (FileResource)resource : null;
            if (fileResource == null) continue;
            File file = fileResource.getFile();
            if (file.isDirectory()) {
                DirectoryScanner ds = this.getDirectoryScanner(file);
                String[] files = ds.getIncludedFiles();
                this.scanDir(file, this.destdir != null ? this.destdir : file, files);
                continue;
            }
            String[] files = new String[]{fileResource.getName()};
            this.scanDir(fileResource.getBaseDir(), this.destdir != null ? this.destdir : fileResource.getBaseDir(), files);
        }
    }

    protected void scanDir(File srcdir, File destdir, String[] files) {
        RegexpPatternMapper mapper = new RegexpPatternMapper();
        if (this.runApi) {
            mapper.setFrom("^(.*)\\.(.*)$");
            mapper.setTo("\\1.api.jrxml");
        } else {
            mapper.setFrom("^(.*)\\.(.*)$");
            mapper.setTo("\\1.java");
        }
        SourceFileScanner scanner = new SourceFileScanner((Task)this);
        String[] newFiles = scanner.restrict(files, srcdir, destdir, (FileNameMapper)mapper);
        if (newFiles != null && newFiles.length > 0) {
            for (int i = 0; i < newFiles.length; ++i) {
                this.reportFilesMap.put(new File(srcdir, newFiles[i]).getAbsolutePath(), new File(destdir, mapper.mapFileName(newFiles[i])[0]).getAbsolutePath());
            }
        }
    }

    protected void writeApi() throws BuildException {
        Set files = this.reportFilesMap.keySet();
        if (files != null && files.size() > 0) {
            boolean isError = false;
            System.out.println("Processing " + files.size() + " report design files.");
            for (String srcFileName : files) {
                String destFileName = (String)this.reportFilesMap.get(srcFileName);
                File destFileParent = new File(destFileName).getParentFile();
                if (!destFileParent.exists()) {
                    destFileParent.mkdirs();
                }
                String srcFileExtension = null;
                int srcFileExtensionStart = srcFileName.lastIndexOf(46);
                if (srcFileExtensionStart >= 0) {
                    srcFileExtension = srcFileName.substring(srcFileExtensionStart);
                }
                try {
                    System.out.print("File : " + srcFileName + " ... ");
                    JRReport report = null;
                    if ("jrxml".equalsIgnoreCase(srcFileExtension)) {
                        report = JRXmlLoader.load(srcFileName);
                    } else if ("jasper".equalsIgnoreCase(srcFileExtension)) {
                        report = (JRReport)JRLoader.loadObject(srcFileName);
                    } else {
                        try {
                            report = (JRReport)JRLoader.loadObject(srcFileName);
                        }
                        catch (JRException e) {
                            report = JRXmlLoader.load(srcFileName);
                        }
                    }
                    JRApiWriter.writeReport(report, destFileName);
                    System.out.println("OK.");
                }
                catch (JRException e) {
                    System.out.println("FAILED.");
                    System.out.println("Error generating API report design : " + srcFileName);
                    e.printStackTrace(System.out);
                    isError = true;
                }
            }
            if (isError) {
                throw new BuildException("Errors were encountered when generating API report designs.");
            }
        }
    }

    protected void runApi() throws BuildException {
        Set files = this.reportFilesMap.keySet();
        if (files != null && files.size() > 0) {
            boolean isError = false;
            System.out.println("Running " + files.size() + " API report design files.");
            for (String srcFileName : files) {
                String destFileName = (String)this.reportFilesMap.get(srcFileName);
                File destFileParent = new File(destFileName).getParentFile();
                if (!destFileParent.exists()) {
                    destFileParent.mkdirs();
                }
                try {
                    System.out.print("File : " + srcFileName + " ... ");
                    Class reportCreatorClass = JRClassLoader.loadClassFromFile(null, new File(srcFileName));
                    ReportCreator reportCreator = (ReportCreator)reportCreatorClass.newInstance();
                    JasperDesign jasperDesign = reportCreator.create();
                    JRXmlWriter.writeReport((JRReport)jasperDesign, destFileName, "UTF-8");
                    System.out.println("OK.");
                }
                catch (Exception e) {
                    System.out.println("FAILED.");
                    System.out.println("Error running API report design class : " + srcFileName);
                    e.printStackTrace(System.out);
                    isError = true;
                }
            }
            if (isError) {
                throw new BuildException("Errors were encountered when running API report designs classes.");
            }
        }
    }
}

