/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.ReportElement;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import javax.swing.ImageIcon;

public class BreakReportElement
extends ReportElement {
    public static ImageIcon img = null;
    private String type = "Page";

    public BreakReportElement(int x, int y, int width, int height) {
        super(x, y, Math.abs(width), Math.abs(height));
    }

    public BreakReportElement(int x, int y, int width, int height, String type) {
        super(x, y, Math.abs(width), Math.abs(height));
        this.type = type;
        this.setKey("break");
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        this.zoom_factor = zoom_factor;
        int height_draw = 0;
        height_draw = this.height <= 1 ? 0 : this.height - 1;
        int width_draw = 0;
        width_draw = this.width <= 1 ? 0 : this.width - 1;
        int leftX = 0;
        int rightX = 0;
        if (this.getBand() != null && this.getBand().getParent() != null) {
            Report report = this.getBand().getParent();
            rightX = (int)((double)report.getLeftMargin() * zoom_factor);
            leftX = (int)((double)(report.getWidth() - report.getRightMargin()) * zoom_factor);
        }
        Point a = new Point(rightX + 10 - x_shift_origin, this.getZoomedDim(this.position.y - 10) + 10 - y_shift_origin);
        Point b = new Point(leftX + 10 - x_shift_origin, (int)a.getY());
        Stroke stroke = this.getPenStroke("Dotted", 1.0);
        if (stroke != null) {
            Stroke oldStroke = g.getStroke();
            g.setStroke(stroke);
            g.setColor(this.getFgcolor());
            g.drawLine(a.x, a.y, b.x, b.y);
            g.setStroke(oldStroke);
        }
        if (img != null) {
            g.drawImage(img.getImage(), a.x - 18, a.y - 7, img.getImageObserver());
        }
    }

    public ReportElement cloneMe() {
        BreakReportElement newReportElement = new BreakReportElement(this.position.x, this.position.y, this.width, this.height);
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }

    public void copyBaseReportElement(ReportElement destination, ReportElement source) {
        super.copyBaseReportElement(destination, source);
        if (destination instanceof BreakReportElement && source instanceof BreakReportElement) {
            ((BreakReportElement)destination).setType(new String(((BreakReportElement)source).getType()));
        }
    }

    public boolean insideBand() {
        int r_height;
        int n = r_height = this.height == 0 ? 1 : this.height;
        if (this.band == null) {
            return false;
        }
        int yband = this.band.getBandYLocation();
        if (this.position.y - yband + r_height > this.band.getHeight()) {
            return false;
        }
        return super.insideBand();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    static {
        img = new ImageIcon(BreakReportElement.class.getResource("/it/businesslogic/ireport/icons/tree/elements/break.png"));
    }
}

