/*
 * Decompiled with CFR 0.152.
 */
package test.functional.mrp;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import org.adempiere.exceptions.AdempiereException;
import org.eevolution.model.I_PP_MRP;
import test.AdempiereTestCase;
import test.functional.mrp.CSVFactory;
import test.functional.mrp.TestableMRP;

public class MRPTest
extends AdempiereTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void test01() throws Exception {
        InputStream in = null;
        if (System.getProperty("MRPTestFile") != null) {
            in = new FileInputStream(System.getProperty("MRPTestFile"));
        }
        if (in == null) {
            in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("test/functional/mrp/MRPTests.csv");
        }
        if (System.getProperty("UseArhipacURL") != null || in == null) {
            String url = "http://spreadsheets.google.com/pub?key=p_F3GDtQxWTArVGQnNvicVw&output=csv&gid=0";
            in = new URL(url).openStream();
        }
        if (in == null) {
            throw new AdempiereException("No input test file found");
        }
        CSVFactory factory = new CSVFactory();
        Collection<TestableMRP> tests = factory.read(in);
        for (TestableMRP test : tests) {
            this.runTest(test);
            this.rollback();
        }
    }

    private void runTest(TestableMRP test) throws Exception {
        boolean ok = false;
        test.trxName = this.getTrxName();
        try {
            test.doIt();
            test.dumpStatus();
            MRPTest.assertEquals((String)(String.valueOf(test.name) + ": MRP Records# not match"), (int)test.expectedMRP.size(), (int)test.actualMRP.size());
            int i = 0;
            while (i < test.expectedMRP.size()) {
                this.assertEquals(String.valueOf(test.name) + ": MRP Record not match", test.expectedMRP.get(i), test.actualMRP.get(i));
                ++i;
            }
            MRPTest.assertEquals((String)(String.valueOf(test.name) + ": MRP Notices# not match"), (int)test.expectedNotices.size(), (int)test.actualNotices.size());
            i = 0;
            while (i < test.expectedNotices.size()) {
                MRPTest.assertEquals((String)(String.valueOf(test.name) + ": MRP Record not match"), (Object)test.expectedNotices.get(i), (Object)test.actualNotices.get(i));
                ++i;
            }
            ok = true;
        }
        finally {
            if (!ok) {
                System.err.println("ERRROR_______________________________________");
                test.dumpStatus();
            }
        }
    }

    public void assertEquals(String message, I_PP_MRP expected, I_PP_MRP actual) throws Exception {
        boolean equals = expected.getAD_Client_ID() == actual.getAD_Client_ID() && expected.getAD_Org_ID() == actual.getAD_Org_ID() && expected.getM_Warehouse_ID() == actual.getM_Warehouse_ID() && expected.getM_Product_ID() == actual.getM_Product_ID() && expected.getQty().equals(actual.getQty()) && expected.getTypeMRP().equals(actual.getTypeMRP()) && expected.getDocStatus().equals(actual.getDocStatus()) && expected.getDatePromised().equals(actual.getDatePromised()) && expected.getDateStartSchedule().equals(actual.getDateStartSchedule()) && expected.getDateFinishSchedule().equals(actual.getDateFinishSchedule()) && expected.getDateOrdered().equals(actual.getDateOrdered());
        StringBuffer sb = new StringBuffer(message).append(": expected=" + expected).append(", actual=" + actual);
        MRPTest.assertTrue((String)sb.toString(), (boolean)equals);
    }
}

