/*
 * Decompiled with CFR 0.152.
 */
package test.functional;

import java.math.BigDecimal;
import org.compiere.model.MLocator;
import org.compiere.model.MStorage;
import org.compiere.model.MWarehouse;
import org.compiere.util.Env;
import test.AdempiereTestCase;

public class MStorageTest
extends AdempiereTestCase {
    int product_id = 122;
    int location_id = 114;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        MStorageTest.assertEquals((String)"Client is not GardenWorld", (int)11, (int)Env.getAD_Client_ID(this.getCtx()));
    }

    private MLocator createLocator(MWarehouse wh, String locatorValue, double qtyOnHand) {
        MLocator loc = new MLocator(wh, wh.getValue() + "-" + locatorValue);
        loc.setXYZ("X" + locatorValue, "Y" + locatorValue, "Z" + locatorValue);
        loc.saveEx();
        BigDecimal targetQty = BigDecimal.valueOf(qtyOnHand).setScale(12, 4);
        MStorage s1 = MStorage.getCreate(this.getCtx(), loc.get_ID(), this.product_id, 0, this.getTrxName());
        s1.setQtyOnHand(targetQty);
        s1.saveEx();
        BigDecimal qty = MStorage.getQtyAvailable(wh.get_ID(), loc.get_ID(), this.product_id, 0, this.getTrxName()).setScale(12, 4);
        MStorageTest.assertEquals((String)("Error on locator " + locatorValue), (Object)targetQty, (Object)qty);
        return loc;
    }

    private void assertWarehouseQty(MWarehouse wh, BigDecimal targetQty) {
        BigDecimal qty = MStorage.getQtyAvailable(wh.get_ID(), 0, this.product_id, 0, this.getTrxName());
        qty = qty.setScale(12, 4);
        targetQty = targetQty.setScale(12, 4);
        MStorageTest.assertEquals((Object)targetQty, (Object)qty);
    }

    public void testGetQtyAvailable() throws Exception {
        BigDecimal whQty = Env.ZERO;
        MWarehouse wh = new MWarehouse(this.getCtx(), 0, this.getTrxName());
        wh.setValue("test-wh");
        wh.setName("test-wh");
        wh.setC_Location_ID(this.location_id);
        wh.saveEx();
        this.assertWarehouseQty(wh, whQty);
        for (int i2 = 1; i2 <= 10; ++i2) {
            this.createLocator(wh, "" + i2, i2);
            whQty = whQty.add(BigDecimal.valueOf(i2));
            this.assertWarehouseQty(wh, whQty);
        }
    }
}

