/*
 * Decompiled with CFR 0.152.
 */
package org.windsor.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class UpdateReservedSales
extends SvrProcess {
    private int p_COrder_ID;
    private int p_MRequisiton_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Order_ID")) {
                    this.p_COrder_ID = para[i].getParameterAsInt();
                } else if (name.equals("M_Requisition_ID")) {
                    this.p_MRequisiton_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        String sqlOrder = "SELECT * FROM C_OrderLine col INNER JOIN C_Order co ON (col.C_Order_ID = co.C_Order_ID) WHERE IssoTrx = 'Y' AND col.qtyReserved <> 0 ";
        if (this.p_COrder_ID > 0) {
            sqlOrder = String.valueOf(sqlOrder) + " AND co.C_Order_ID = " + this.p_COrder_ID;
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sqlOrder, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal qty = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(movementQty) FROM M_InOutLine iol INNER JOIN M_InOut io ON (iol.M_InOut_ID = io.M_InOut_ID) WHERE DocStatus IN ('CO','CL') AND C_OrderLine_ID = ?", rs.getInt("C_OrderLine_ID"));
                BigDecimal qtyDif = rs.getBigDecimal("QtyOrdered").subtract(qty);
                DB.executeUpdate("UPDATE C_OrderLine SET QtyReserved = " + qtyDif + " WHERE C_OrderLine_ID = " + rs.getInt("C_OrderLine_ID"), this.get_TrxName());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        String sqlReq = "SELECT * FROM M_RequisitionLine col INNER JOIN M_Requisition co ON (col.M_Requisition_ID = co.M_Requisition_ID) WHERE IssoTrx = 'Y' AND col.qtyReserved <> 0 AND liberada <> 'Y' ";
        if (this.p_MRequisiton_ID > 0) {
            sqlReq = String.valueOf(sqlReq) + " AND co.M_Requisition_ID = " + this.p_MRequisiton_ID;
        }
        CPreparedStatement pstmtR = null;
        try {
            pstmtR = DB.prepareStatement(sqlReq, this.get_TrxName());
            ResultSet rsR = pstmtR.executeQuery();
            while (rsR.next()) {
                BigDecimal qty = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(QtyOrdered) FROM C_OrderLine co INNER JOIN C_Order col ON (col.C_Order_ID = co.C_Order_ID) WHERE DocStatus IN ('CO','CL','IP') AND M_RequisitionLine_ID = ?", rsR.getInt("M_RequisitionLine_ID"));
                BigDecimal qtyDif = rsR.getBigDecimal("Qty").subtract(qty);
                DB.executeUpdate("UPDATE M_RequisitionLine SET QtyReserved = " + qtyDif + " WHERE M_RequisitionLine_ID = " + rsR.getInt("M_RequisitionLine_ID"), this.get_TrxName());
            }
            rsR.close();
            pstmtR.close();
            pstmtR = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return "Procesado";
    }
}

