/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.X_TP_Refund;
import org.compiere.model.X_TP_RefundLine;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ProcessRefund
extends SvrProcess {
    private int p_TP_Viatico_ID = 0;

    @Override
    protected void prepare() {
        this.p_TP_Viatico_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_TP_Viatico_ID > 0) {
            X_TP_Refund viatico = new X_TP_Refund(this.getCtx(), this.p_TP_Viatico_ID, this.get_TrxName());
            if (viatico.getDocStatus().compareTo("WC") == 0) {
                Boolean sig1 = viatico.get_ValueAsBoolean("Signature1");
                Boolean sig2 = viatico.get_ValueAsBoolean("Signature2");
                Boolean sig3 = viatico.get_ValueAsBoolean("Signature3");
                if (viatico.getType().compareTo("01") == 0 ? sig2 == false || sig3 == false : viatico.getType().compareTo("02") == 0 && (sig1 == false || sig2 == false || sig3 == false)) {
                    throw new AdempiereException("Error: No se puede completar sin las firmas necesarias");
                }
            }
            if (viatico.get_ValueAsBoolean("overwrite")) {
                viatico.setDocStatus("CO");
                viatico.setProcessed(true);
            } else {
                int cantRep;
                if (viatico.getType().compareTo("01") == 0 && (cantRep = DB.getSQLValue(this.get_TrxName(), "SELECT COALESCE(COUNT(1),0)FROM TP_RefundLine  WHERE M_Movement_ID > 0 AND TP_Refund_ID=" + viatico.get_ID() + " GROUP BY DateTrx HAVING COUNT(1) > 1")) > 0) {
                    throw new AdempiereException("ERROR: Existe mas de una Hoja de Ruta para la misma Fecha");
                }
                String sqlLine = "SELECT TP_RefundLine_ID FROM TP_RefundLine WHERE IsActive = 'Y' AND TP_Refund_ID = ?";
                CPreparedStatement pstmt = null;
                pstmt = DB.prepareStatement(sqlLine, this.get_TrxName());
                pstmt.setInt(1, viatico.get_ID());
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    X_TP_RefundLine rLine = new X_TP_RefundLine(this.getCtx(), rs.getInt("TP_RefundLine_ID"), this.get_TrxName());
                    if (rLine.getM_Movement_ID() > 0) {
                        Timestamp MaxDate = DB.getSQLValueTS(this.get_TrxName(), "SELECT MAX(TP_InicialHR) FROM M_MovementLine WHERE M_Movement_ID = " + rLine.getM_Movement_ID(), new Object[0]);
                        Timestamp MinDate = DB.getSQLValueTS(this.get_TrxName(), "SELECT MIN(TP_FinalHR) FROM M_MovementLine WHERE M_Movement_ID = " + rLine.getM_Movement_ID(), new Object[0]);
                        MinDate.setHours(0);
                        MinDate.setMinutes(0);
                        MinDate.setSeconds(0);
                        if (rLine.getDateTrx().compareTo(MaxDate) > 0 || rLine.getDateTrx().compareTo(MinDate) < 0) {
                            throw new AdempiereException("ERROR: Fecha de HR no coincide con fecha de viatico");
                        }
                    }
                    if (viatico.getType().compareTo("02") != 0) continue;
                    int cant = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM TP_RefundLine WHERE IsActive = 'Y' AND TP_RefundLine_ID <> " + rLine.get_ID() + " AND M_Movement_ID = " + rLine.getM_Movement_ID() + " AND TP_RefundAmt_ID = " + rLine.get_ValueAsInt("TP_RefundAmt_ID") + " AND DateTrx = ?", rLine.getDateTrx());
                    if (cant > 0) {
                        throw new AdempiereException("ERROR: Existe una HR y concepto repetido");
                    }
                    if (rLine.getM_Movement_ID() > 0 || rLine.get_ValueAsInt("TP_RefundAmt_ID") <= 0 || rLine.getTP_Refund().getAD_Org_ID() == 1000004 || rLine.getTP_Refund().getAD_Org_ID() == 1000017) continue;
                    throw new AdempiereException("ERROR: Concepto sin HR ingresada");
                }
                rs.close();
                pstmt.close();
                pstmt = null;
                if (viatico.getDocStatus().compareTo("DR") == 0) {
                    viatico.setDocStatus("WC");
                } else if (viatico.getDocStatus().compareTo("WC") == 0) {
                    viatico.setDocStatus("WC");
                    viatico.setProcessed(true);
                }
            }
            viatico.save();
        }
        return "Procesado ";
    }
}

