/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.X_C_CriticalDate;
import org.compiere.model.X_C_CriticalDateConcept;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.utils.DateUtils;

public class ProcessCriticalDatePack
extends SvrProcess {
    int p_BParter_ID;
    int p_CDateConcept_ID;
    Timestamp p_date;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_BPartner_ID")) {
                    this.p_BParter_ID = para[i].getParameterAsInt();
                } else if (name.equals("DateTrx")) {
                    this.p_date = (Timestamp)para[i].getParameter();
                } else if (name.equals("C_CriticalDateConcept_ID")) {
                    this.p_CDateConcept_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        X_C_CriticalDateConcept co = new X_C_CriticalDateConcept(this.getCtx(), this.p_CDateConcept_ID, this.get_TrxName());
        if (!co.get_ValueAsBoolean("IsSummary")) {
            int cant = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(C_CriticalDate_ID)  FROM C_CriticalDate WHERE IsActive='Y' AND Status='AL'  AND C_CriticalDateConcept_ID = " + co.get_ID() + " AND C_Bpartner_ID = " + this.p_BParter_ID);
            if (cant <= 0) {
                X_C_CriticalDate cDate = new X_C_CriticalDate(this.getCtx(), 0, this.get_TrxName());
                cDate.setDateTrx(this.p_date);
                cDate.setC_BPartner_ID(this.p_BParter_ID);
                cDate.setC_CriticalDateConcept_ID(this.p_CDateConcept_ID);
                if (co.getIsDue().compareTo(Env.ZERO) > 0) {
                    Timestamp dateEnd = DateUtils.SumarMeses(cDate.getDateTrx(), cDate.getC_CriticalDateConcept().getIsDue().multiply(new BigDecimal("12.0")).intValue());
                    cDate.setDueDate(dateEnd);
                }
                cDate.setStatus("AL");
                cDate.setDocStatus("DR");
                cDate.saveEx(this.get_TrxName());
            }
        } else {
            String sql = "SELECT * FROM RVOFB_FC_Concept_Parent WHERE C_CriticalDateConceptRef_ID=?";
            int cant = 0;
            CPreparedStatement ps = DB.prepareStatement(sql, this.get_TrxName());
            ps.setInt(1, co.get_ID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                cant = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(C_CriticalDate_ID)  FROM C_CriticalDate WHERE IsActive='Y' AND Status='AL'  AND C_CriticalDateConcept_ID = " + rs.getInt("C_CriticalDateConcept_ID") + " AND C_Bpartner_ID = " + this.p_BParter_ID);
                if (cant > 0) continue;
                X_C_CriticalDateConcept con2 = new X_C_CriticalDateConcept(this.getCtx(), rs.getInt("C_CriticalDateConcept_ID"), this.get_TrxName());
                X_C_CriticalDate cDate = new X_C_CriticalDate(this.getCtx(), 0, this.get_TrxName());
                cDate.setDateTrx(this.p_date);
                cDate.setC_BPartner_ID(this.p_BParter_ID);
                cDate.setC_CriticalDateConcept_ID(rs.getInt("C_CriticalDateConcept_ID"));
                if (con2.getIsDue().compareTo(Env.ZERO) > 0) {
                    Timestamp dateEnd = DateUtils.SumarMeses(this.p_date, cDate.getC_CriticalDateConcept().getIsDue().multiply(new BigDecimal("12.0")).intValue());
                    cDate.setDueDate(dateEnd);
                }
                cDate.setStatus("AL");
                cDate.setDocStatus("DR");
                cDate.saveEx(this.get_TrxName());
            }
            rs.close();
            ps.close();
        }
        return "Procesado";
    }
}

