/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.process;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.X_MP_OT;
import org.compiere.model.X_M_Requisition;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.utils.DateUtils;

public class GenerateRequisitionFromOT
extends SvrProcess {
    private int p_M_Warehouse_ID = 0;
    private int p_BPartner_ID = 0;
    private int p_OT_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Warehouse_ID")) {
                    this.p_M_Warehouse_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BPartner_ID")) {
                    this.p_BPartner_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_OT_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        X_MP_OT ot = new X_MP_OT(this.getCtx(), this.p_OT_ID, this.get_TrxName());
        String sqlDet = "select *  from rvofb_detailottorequisition where MP_OT_ID=" + this.p_OT_ID;
        CPreparedStatement pstmt = null;
        int ind = DB.getSQLValue(this.get_TrxName(), "select COUNT(1) from rvofb_detailottorequisition where MP_OT_ID=" + this.p_OT_ID);
        int cant = 0;
        X_M_Requisition req = null;
        if (ind > 0) {
            try {
                pstmt = DB.prepareStatement(sqlDet, this.get_TrxName());
                ResultSet rs = pstmt.executeQuery();
                req = new MRequisition(this.getCtx(), 0, this.get_TrxName());
                req.setAD_Org_ID(ot.getAD_Org_ID() == 0 ? Env.getAD_Org_ID(this.getCtx()) : ot.getAD_Org_ID());
                req.setC_DocType_ID(1000018);
                req.setAD_User_ID(Env.getAD_User_ID(this.getCtx()));
                req.setDescription("Generado desde OT " + ot.getDocumentNo());
                req.setPriorityRule("5");
                req.setDateRequired(DateUtils.now());
                req.setDateDoc(DateUtils.now());
                req.setM_Warehouse_ID(this.p_M_Warehouse_ID);
                req.setM_PriceList_ID(1000001);
                if (ot.get_ValueAsInt("A_Asset_ID") > 0) {
                    req.set_CustomColumn("A_Asset_ID", ot.get_ValueAsInt("A_Asset_ID"));
                }
                req.save();
                while (rs.next()) {
                    MRequisitionLine line = new MRequisitionLine((MRequisition)req);
                    line.setM_Product_ID(rs.getInt("M_Product_ID"));
                    if (this.p_BPartner_ID > 0) {
                        line.setC_BPartner_ID(this.p_BPartner_ID);
                    }
                    line.setQty(rs.getBigDecimal("resourceqty"));
                    if (rs.getString("description") != null) {
                        line.setDescription(rs.getString("description"));
                    }
                    line.setPrice();
                    line.save();
                    ++cant;
                }
                rs.close();
                pstmt.close();
                pstmt = null;
                if (req != null) {
                    DB.executeUpdate("UPDATE MP_OT SET M_Requisition_ID = " + req.get_ID() + " WHERE MP_OT_ID = " + ot.get_ID(), this.get_TrxName());
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (req != null) {
            return "Se han generado la solicitud " + req.getDocumentNo() + " con " + cant + " lineas";
        }
        return "No se ha podido generar la solicitud";
    }
}

