/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.model.MClient;
import org.compiere.model.MMovement;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_M_Movement;
import org.compiere.model.X_M_MovementLine;
import org.compiere.model.X_TP_Destination;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelOFBTransportes
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFBTransportes.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("M_Movement", this);
        engine.addModelChange("M_MovementLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        String sqlV1;
        X_M_MovementLine mml;
        BigDecimal tpIni;
        X_M_Movement mm;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == 323) {
            BigDecimal tpFin;
            mm = (X_M_Movement)po;
            tpIni = (BigDecimal)mm.get_Value("TP_InicialKm");
            if (tpIni.compareTo(tpFin = (BigDecimal)mm.get_Value("TP_FinalKm")) > 0) {
                return "Odometro Inicial no puede ser Mayor a Odometro Final";
            }
            if (tpIni.compareTo(new BigDecimal("0.0")) <= 0) {
                return "Odometro Inicial debe ser mayor a 0";
            }
            if (tpFin.compareTo(new BigDecimal("0.0")) <= 0) {
                return "Odometro Final debe ser mayor a 0";
            }
            Timestamp fhoy = new Timestamp(System.currentTimeMillis());
            Timestamp fmov = mm.getMovementDate();
            if (fmov.compareTo(fhoy) > 0) {
                return "Fecha Ingresa mayor a fecha actual";
            }
        }
        if ((type == 1 || type == 2) && po.get_Table_ID() == X_M_MovementLine.Table_ID) {
            mml = (X_M_MovementLine)po;
            MMovement mm2 = new MMovement(po.getCtx(), mml.getM_Movement_ID(), po.get_TrxName());
            BigDecimal kmSalida = (BigDecimal)mml.get_Value("TP_FinalKM");
            BigDecimal kmLlegada = (BigDecimal)mml.get_Value("TP_InicialKm");
            if (kmSalida == null) {
                kmSalida = Env.ZERO;
            }
            if (kmLlegada == null) {
                kmLlegada = Env.ZERO;
            }
            if (kmSalida.compareTo(kmLlegada) > 0) {
                return "KM Salida No puede ser Mayor a KM Llegada";
            }
            Timestamp inicio = (Timestamp)mml.get_Value("TP_FinalHR");
            Timestamp termino = (Timestamp)mml.get_Value("TP_InicialHR");
            if (inicio != null && termino != null && termino.compareTo(inicio) < 0) {
                return "Fecha de Termino no puede ser Menor que Fecha de Inicio";
            }
            BigDecimal volIn = (BigDecimal)mml.get_Value("TP_VolIn");
            BigDecimal m3dev = (BigDecimal)mml.get_Value("TP_M3Devol");
            BigDecimal volm3 = (BigDecimal)mml.get_Value("TP_volM3");
            if (volIn == null) {
                volIn = Env.ZERO;
            }
            if (m3dev == null) {
                m3dev = Env.ZERO;
            }
            if (volm3 == null) {
                volm3 = Env.ZERO;
            }
            if (volIn.compareTo(new BigDecimal("100.0")) >= 0 || m3dev.compareTo(new BigDecimal("100.0")) >= 0 || volm3.compareTo(new BigDecimal("100.0")) >= 0) {
                return "Valor Solo Puede tener 2 enteros y 2 decimales";
            }
            BigDecimal fraction1 = volIn.remainder(BigDecimal.ONE);
            String frac1 = fraction1.toString();
            if ((frac1 = ModelOFBTransportes.rtrim(frac1, '0')).equals("0E-12")) {
                frac1 = "0";
            }
            BigDecimal fraction2 = m3dev.remainder(BigDecimal.ONE);
            String frac2 = fraction2.toString();
            if ((frac2 = ModelOFBTransportes.rtrim(frac2, '0')).equals("0E-12")) {
                frac2 = "0";
            }
            BigDecimal fraction3 = volm3.remainder(BigDecimal.ONE);
            String frac3 = fraction3.toString();
            if ((frac3 = ModelOFBTransportes.rtrim(frac3, '0')).equals("0E-12")) {
                frac3 = "0";
            }
            if (frac1.length() > 4 || frac2.length() > 4 || frac3.length() > 4) {
                return "Valor Solo Puede tener 2 enteros y 2 decimales";
            }
            X_TP_Destination dest = new X_TP_Destination(po.getCtx(), mml.get_ValueAsInt("TP_Destination_ID"), po.get_TrxName());
            if (dest.get_ValueAsInt("C_ProjectOFB_ID") != mm2.get_ValueAsInt("C_ProjectOFB_ID")) {
                return "Flota de Destino no coindice con Flota de Cabecera";
            }
        }
        if (type == 1 && po.get_Table_ID() == X_M_MovementLine.Table_ID) {
            BigDecimal maxKmCalLine;
            mml = (X_M_MovementLine)po;
            BigDecimal kmSalida = (BigDecimal)mml.get_Value("TP_FinalKM");
            sqlV1 = "select coalesce((max(TP_inicialkm)),0) from m_movementLine where M_Movement_ID = ? and m_movementLine_ID <> ?";
            BigDecimal maxKmLine = DB.getSQLValueBD(po.get_TrxName(), sqlV1, mml.getM_Movement_ID(), mml.get_ID());
            if (maxKmLine == null) {
                maxKmLine = Env.ZERO;
            }
            if (kmSalida.compareTo(maxKmCalLine = maxKmLine.add(new BigDecimal("1000.0"))) > 0) {
                return "Odometro Inicial Fuera de Rango. Debe estar entre " + maxKmLine + " y " + maxKmCalLine;
            }
            if (kmSalida.compareTo(maxKmLine) <= 0) {
                return "Odometro Inicial Fuera de Rango. Debe estar entre " + maxKmLine + " y " + maxKmCalLine;
            }
        }
        if (type == 1 && po.get_Table_ID() == X_M_Movement.Table_ID) {
            mm = (X_M_Movement)po;
            tpIni = (BigDecimal)mm.get_Value("TP_InicialKm");
            sqlV1 = "select max(TP_Finalkm) from m_movement where TP_Asset_ID = ? and m_movement_id <> ? and docstatus <> 'VO'";
            BigDecimal maxKm = DB.getSQLValueBD(po.get_TrxName(), sqlV1, mm.get_ValueAsInt("TP_Asset_ID"), mm.get_ID());
            BigDecimal maxKmCal = maxKm.add(new BigDecimal("500.0"));
            if (maxKmCal == null) {
                maxKmCal = Env.ZERO;
            }
            if (tpIni.compareTo(maxKmCal) > 0) {
                return "Odometro Inicial Fuera de Rango. Debe estar entre " + maxKm + " y " + maxKmCal;
            }
            if (tpIni.compareTo(maxKm) < 0) {
                return "Odometro Inicial Fuera de Rango. Debe estar entre " + maxKm + " y " + maxKmCal;
            }
        }
        return null;
    }

    public static String rtrim(String s, char c) {
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == c) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

