/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_M_Movement;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Mod_TSM_ValidacionKmFechaVolumen
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(Mod_TSM_ValidacionKmFechaVolumen.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("M_Movement", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        BigDecimal tpIni;
        X_M_Movement mm;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == X_M_Movement.Table_ID) {
            BigDecimal tpFin;
            mm = (X_M_Movement)po;
            tpIni = (BigDecimal)mm.get_Value("TP_InicialKm");
            if (tpIni.compareTo(tpFin = (BigDecimal)mm.get_Value("TP_FinalKm")) > 0) {
                return "Odometro Inicial no puede ser Mayor a Odometro Final";
            }
            if (tpIni.compareTo(new BigDecimal("0.0")) <= 0) {
                return "Odometro Inicial debe ser mayor a 0";
            }
            if (tpFin.compareTo(new BigDecimal("0.0")) <= 0) {
                return "Odometro Final debe ser mayor a 0";
            }
            Timestamp fhoy = new Timestamp(System.currentTimeMillis());
            Timestamp fmov = mm.getMovementDate();
            if (fmov.compareTo(fhoy) > 0) {
                return "Error fecha ingreso mayor a la actual";
            }
        }
        if (type == 1 && po.get_Table_ID() == X_M_Movement.Table_ID) {
            mm = (X_M_Movement)po;
            tpIni = (BigDecimal)mm.get_Value("TP_InicialKm");
            String sqlV1 = "select max(TP_Finalkm) from m_movement where TP_Asset_ID = ? and m_movement_id <> ? and docstatus <> 'VO'";
            BigDecimal maxKm = DB.getSQLValueBD(po.get_TrxName(), sqlV1, mm.get_ValueAsInt("TP_Asset_ID"), mm.get_ID());
            BigDecimal maxKmCal = maxKm.add(new BigDecimal("500.0"));
            if (maxKmCal == null) {
                maxKmCal = Env.ZERO;
            }
            if (tpIni.compareTo(maxKmCal) > 0) {
                return "Odometro Inicial Fuera de Rango. Debe estar entre " + maxKm + " y " + maxKmCal;
            }
            if (tpIni.compareTo(maxKm) < 0) {
                return "Odometro Inicial Fuera de Rango. Debe estar entre " + maxKm + " y " + maxKmCal;
            }
        }
        return null;
    }

    public static String rtrim(String s, char c) {
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == c) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

