/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModTSMValidQtyAmtOC
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModTSMValidQtyAmtOC.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_OrderLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 2 || type == 1) && po.get_Table_ID() == MOrderLine.Table_ID) {
            MOrderLine oLine = (MOrderLine)po;
            MOrder order = new MOrder(po.getCtx(), oLine.getC_Order_ID(), po.get_TrxName());
            if (!order.isSOTrx() && oLine.get_ValueAsInt("M_RequisitionLine_ID") > 0 && order.getC_DocTypeTarget().getName().toLowerCase().contains("compra")) {
                MRequisitionLine rLine = new MRequisitionLine(po.getCtx(), oLine.get_ValueAsInt("M_RequisitionLine_ID"), po.get_TrxName());
                String sqlVal = "SELECT SUM(qtyEntered) FROM C_OrderLine col  INNER JOIN C_Order co on (col.C_Order_ID = co.C_Order_ID) WHERE co.DocStatus IN ('CO','CL','DR','IP') AND  col.M_requisitionLine_ID = " + oLine.get_ValueAsInt("M_RequisitionLine_ID") + " AND C_OrderLine_ID <> " + oLine.get_ID();
                BigDecimal qtyTotal = DB.getSQLValueBD(po.get_TrxName(), sqlVal, new Object[0]);
                if (qtyTotal == null) {
                    qtyTotal = Env.ZERO;
                }
                if ((qtyTotal = qtyTotal.add(oLine.getQtyEntered())).compareTo(rLine.getQty()) > 0) {
                    return "Cantidad Supera Cantidad de Solicitud";
                }
                String sqlValAmt = "SELECT SUM(LineNetAmt) FROM C_OrderLine col  INNER JOIN C_Order co on (col.C_Order_ID = co.C_Order_ID) WHERE co.DocStatus IN ('CO','CL','DR','IP') AND  col.M_requisitionLine_ID = " + oLine.get_ValueAsInt("M_RequisitionLine_ID") + " AND C_OrderLine_ID <> " + oLine.get_ID();
                BigDecimal amtTotal = DB.getSQLValueBD(po.get_TrxName(), sqlValAmt, new Object[0]);
                if (amtTotal == null) {
                    amtTotal = Env.ZERO;
                }
                if ((amtTotal = amtTotal.add(oLine.getLineNetAmt())).compareTo(rLine.getLineNetAmt().setScale(order.getC_Currency().getStdPrecision(), 6)) > 0) {
                    return "Monto Supera Monto de la Solicitud";
                }
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

