/*
 * Decompiled with CFR 0.152.
 */
package org.tc.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateInternalUse
extends SvrProcess {
    @Override
    protected void prepare() {
    }

    @Override
    protected String doIt() throws Exception {
        String sqlDet = "SELECT * FROM I_InventoryXML mi WHERE Processed <> 'Y' AND I_IsImported <> 'Y'  Order By DocumentNo ASC";
        CPreparedStatement pstmt = null;
        int cant = 0;
        String ID_movXML = "0";
        this.log.config("sqldet " + sqlDet);
        try {
            pstmt = DB.prepareStatement(sqlDet, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            String LastInv = "";
            MInventory inv = null;
            while (rs.next()) {
                if (LastInv != rs.getString("DocumentNo")) {
                    inv = new MInventory(this.getCtx(), 0, this.get_TrxName());
                    inv.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                    inv.setC_DocType_ID(1000023);
                    inv.setDescription("Generado automaticamente. - " + rs.getString("Description"));
                    inv.setDocStatus("DR");
                    inv.setM_Warehouse_ID(rs.getInt("M_Warehouse_ID"));
                    inv.set_CustomColumn("DocNo", rs.getString("DocumentNo"));
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    Date parsedDate = dateFormat.parse(rs.getString("DateTrx"));
                    Timestamp dateDoc = new Timestamp(parsedDate.getTime());
                    this.log.config("datedoc " + dateDoc);
                    if (dateDoc != null) {
                        inv.setMovementDate(dateDoc);
                    }
                    inv.save();
                    ++cant;
                }
                int ID_Locator = DB.getSQLValue(this.get_TrxName(), "SELECT M_Locator_ID FROM M_Locator  WHERE M_Warehouse_ID = " + inv.getM_Warehouse_ID() + " ORDER BY IsDefault ");
                int ID_Prod = DB.getSQLValue(this.get_TrxName(), "SELECT M_Product_ID FROM M_Product  WHERE value like '" + rs.getString("value") + "' ORDER BY M_Product_ID ");
                int ID_Charge = DB.getSQLValue(this.get_TrxName(), "SELECT C_Charge_ID FROM C_Charge cc INNER JOIN C_ChargeType ct ON (cc.C_ChargeType_ID = ct.C_ChargeType_ID)  WHERE ct.value = 'TCUI'");
                BigDecimal qty = rs.getBigDecimal("QtyInternalUse");
                if (qty == null) {
                    qty = Env.ZERO;
                }
                if (rs.getString("Transaction_Type").compareTo("S") == 0) {
                    qty = qty.negate();
                }
                qty = qty.abs();
                MInventoryLine line = new MInventoryLine(this.getCtx(), 0, this.get_TrxName());
                line.setM_Inventory_ID(inv.get_ID());
                line.setAD_Org_ID(inv.getAD_Org_ID());
                line.setM_Locator_ID(ID_Locator);
                line.setM_Product_ID(ID_Prod);
                line.setQtyInternalUse(qty);
                line.setC_Charge_ID(ID_Charge);
                line.set_CustomColumn("Odometro", rs.getBigDecimal("Odometro"));
                int ID_Partner = DB.getSQLValue(this.get_TrxName(), "SELECT C_Bpartner_ID from C_BPartner where value like '" + rs.getString("BPartnerValue") + "'");
                line.set_CustomColumn("C_BPartnerC_ID", ID_Partner);
                int ID_Act = DB.getSQLValue(this.get_TrxName(), "SELECT A_Asset_ID FROM A_Asset where value like '" + rs.getString("Equipo") + "'");
                line.set_CustomColumn("A_Asset2_ID", ID_Act);
                line.set_CustomColumn("origen", rs.getString("origen"));
                int att = DB.getSQLValue(this.get_TrxName(), "SELECT max(M_Attributesetinstance_id) from m_storage where m_product_id = " + ID_Prod);
                line.setM_AttributeSetInstance_ID(att);
                line.save();
                LastInv = rs.getString("DocumentNo");
                if (rs.getString("I_InventoryXML_ID") == null) continue;
                ID_movXML = String.valueOf(ID_movXML) + "," + rs.getString("I_InventoryXML_ID");
            }
            inv.processIt("CO");
            inv.save();
            this.log.config("Se han generado " + cant + " consumos ");
            DB.executeUpdate("UPDATE I_InventoryXML SET processed = 'Y' WHERE I_InventoryXML_ID IN (" + ID_movXML + ")", this.get_TrxName());
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return "OK";
    }
}

