/*
 * Decompiled with CFR 0.152.
 */
package org.safeenergy.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModSEUpdateFieldsOLine
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModSEUpdateFieldsOLine.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_OrderLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 4 || type == 5) && po.get_Table_ID() == MOrderLine.Table_ID && po.is_ValueChanged("IsFleet")) {
            MOrderLine ordl2 = (MOrderLine)po;
            MOrder ord = new MOrder(po.getCtx(), ordl2.getC_Order_ID(), po.get_TrxName());
            if (!ord.get_ValueAsBoolean("issotrx")) {
                return null;
            }
            BigDecimal preciomaterial = Env.ZERO;
            BigDecimal segurocarga = Env.ZERO;
            BigDecimal pesopallet = Env.ZERO;
            BigDecimal volumenpallet = Env.ZERO;
            BigDecimal volumenm3 = Env.ZERO;
            BigDecimal pesocarga = Env.ZERO;
            BigDecimal costototal = Env.ZERO;
            BigDecimal precioventa = Env.ZERO;
            BigDecimal pavolumen = Env.ZERO;
            BigDecimal papesos = Env.ZERO;
            BigDecimal cprecioventa = Env.ZERO;
            BigDecimal ccostototal = Env.ZERO;
            BigDecimal grandtotal = Env.ZERO;
            BigDecimal grandtotal2 = Env.ZERO;
            MOrderLine[] line = ord.getLines();
            int i = 0;
            while (i < line.length) {
                MOrderLine ordl = line[i];
                String fleet = ordl.get_Value("IsFleet").toString();
                if (ordl.getC_Tax_ID() == 1000000) {
                    grandtotal = DB.getSQLValueBD(po.get_TrxName(), "select sum(ordl.linenetamt)*0.19+sum(ordl.linenetamt) from adempiere.c_orderline ordl join adempiere.c_order ord on ord.c_order_id = ordl.c_order_id where ordl.c_tax_id = 1000000 and ordl.m_product_id = " + ordl.getM_Product_ID() + "and ord.c_order_id = " + ord.get_ID(), new Object[0]).add(grandtotal);
                } else if (ordl.getC_Tax_ID() == 1000001) {
                    grandtotal = DB.getSQLValueBD(po.get_TrxName(), "select sum(ordl.linenetamt) from adempiere.c_orderline ordl join adempiere.c_order ord on ord.c_order_id = ordl.c_order_id where ordl.c_tax_id = 1000000 and ordl.m_product_id = " + ordl.getM_Product_ID() + "and ord.c_order_id = " + ord.get_ID(), new Object[0]);
                    grandtotal2.add(grandtotal);
                }
                if (ordl.getM_Product_ID() > 0 && fleet.equals("true")) {
                    BigDecimal costoservicio;
                    BigDecimal Tarifa;
                    if (ordl.getPriceActual().compareTo(Env.ZERO) <= 0) {
                        return "Se debe registra un valor.";
                    }
                    preciomaterial = ordl.getPriceActual();
                    segurocarga = preciomaterial.multiply(BigDecimal.valueOf(0.13));
                    if (ordl.get_Value("CantidadPallet") != null) {
                        if (ordl.get_Value("M_ProductRef_ID") != null) {
                            papesos = DB.getSQLValueBD(po.get_TrxName(), "select Weight from M_Product Where M_Product_ID = " + ordl.get_Value("M_ProductRef_ID"), new Object[0]);
                            pavolumen = DB.getSQLValueBD(po.get_TrxName(), "select Volume from M_Product Where M_Product_ID = " + ordl.get_Value("M_ProductRef_ID"), new Object[0]);
                        }
                        pesopallet = (BigDecimal)ordl.get_Value("CantidadPallet");
                        pesopallet = pesopallet.multiply(papesos);
                        volumenpallet = (BigDecimal)ordl.get_Value("CantidadPallet");
                        volumenpallet = volumenpallet.multiply(pavolumen);
                    }
                    volumenm3 = ordl.getM_Product().getVolume();
                    pesocarga = ordl.getM_Product().getWeight();
                    if ((volumenm3 = volumenm3.add(volumenpallet).multiply(BigDecimal.valueOf(250L))).compareTo(pesocarga = pesocarga.add(pesopallet)) > 0) {
                        Tarifa = DB.getSQLValueBD(po.get_TrxName(), "select tariff from adempiere.citychargeline where citycharge_id = " + ord.get_ValueAsInt("CityCharge_ID") + "and kilos1 = (select  max(kilos1) from adempiere.citychargeline " + "where  kilos1 <= " + volumenm3 + ") " + "and kilos2 = (select min(kilos2) from adempiere.citychargeline " + "where  kilos2 >= " + volumenm3 + ")", new Object[0]);
                        if (Tarifa == null) {
                            Tarifa = Env.ZERO;
                        }
                        costoservicio = volumenm3.multiply(Tarifa);
                        costototal = costoservicio.add(segurocarga);
                    } else {
                        Tarifa = DB.getSQLValueBD(po.get_TrxName(), "select tariff from adempiere.citychargeline where citycharge_id = " + ord.get_ValueAsInt("CityCharge_ID") + "and kilos1 = (select  max(kilos1) from adempiere.citychargeline " + "where  kilos1 <= " + pesocarga + ") " + "and kilos2 = (select min(kilos2) from adempiere.citychargeline " + "where  kilos2 >= " + pesocarga + ")", new Object[0]);
                        if (Tarifa == null) {
                            Tarifa = Env.ZERO;
                        }
                        costoservicio = pesocarga.multiply(Tarifa);
                        costototal = costoservicio.add(segurocarga);
                    }
                    BigDecimal costototal2 = costototal.setScale(2, RoundingMode.HALF_UP);
                    precioventa = costototal2.divide(BigDecimal.valueOf(0.85), 2, RoundingMode.HALF_UP);
                    ordl.set_ValueOfColumn("SalePrice", (Object)precioventa);
                    ordl.set_ValueOfColumn("ServiceCost", (Object)costototal2);
                    ordl.saveEx(po.get_TrxName());
                    cprecioventa = cprecioventa.add(precioventa);
                    ccostototal = ccostototal.add(costototal2);
                }
                ++i;
            }
            BigDecimal total = grandtotal.add(ccostototal).add(cprecioventa);
            int a2 = 192598;
            BigDecimal.valueOf(a2);
            ord.setGrandTotal(total);
            ord.save();
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

