/*
 * Decompiled with CFR 0.152.
 */
package org.prototipos.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBankAccount;
import org.compiere.model.MInvoice;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPayment;
import org.compiere.model.MProject;
import org.compiere.model.X_C_PaymentRequest;
import org.compiere.model.X_C_PaymentRequestLine;
import org.compiere.model.X_C_ProjectSchedule;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProcessPaymentRequest
extends SvrProcess {
    private int Record_ID;
    private String P_DocAction;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocAction")) {
                    this.P_DocAction = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.Record_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        X_C_PaymentRequest pr = new X_C_PaymentRequest(Env.getCtx(), this.Record_ID, this.get_TrxName());
        String requestType = pr.getRequestType();
        requestType = Character.toString(requestType.charAt(0));
        if (pr.getLines().length == 0 && !requestType.equals("R")) {
            return "No Lines";
        }
        if (pr.getDocStatus().equals("WC") && pr.getC_BankAccount_ID() <= 0) {
            return "Debe indicar una cuenta bancaria para generar el pago";
        }
        if (pr.getDocStatus().equals("CO") && this.P_DocAction.equals("VO")) {
            MPayment pay = new MPayment(Env.getCtx(), pr.getC_Payment_ID(), this.get_TrxName());
            if (pay.getDocStatus().equals("CO") || pay.getDocStatus().equals("IP")) {
                return "el pago relacionado con esta solicitud se encuentra compleado o procesado, no puede se puede anular";
            }
            pay.deleteEx(true, this.get_TrxName());
            pr.setC_Payment_ID(0);
            pr.setDocStatus("VO");
            pr.save();
            if (requestType.equals("R")) {
                MProject pj = new MProject(this.getCtx(), pr.get_ValueAsInt("C_Project_ID"), this.get_TrxName());
                pj.setProjectBalanceAmt(pj.getProjectBalanceAmt().subtract(pr.getPayAmt()));
                pj.save();
                if (pr.get_ValueAsInt("C_ProjectSchedule_ID") > 0) {
                    DB.executeUpdate("update C_ProjectSchedule set isvalid='Y',C_PaymentRequest_ID=" + pr.getC_PaymentRequest_ID() + " where C_ProjectSchedule_ID=" + pr.get_ValueAsInt("C_ProjectSchedule_ID"), this.get_TrxName());
                }
            }
            return "Pago generado borrado y solicitud de pago anulada";
        }
        if (pr.getDocStatus().equals("DR")) {
            int n;
            if (requestType.equals("P")) {
                String sqlcandet = "SELECT COUNT(*) FROM C_PaymentRequestLine WHERE (gl_journalline_id is null OR isactive = 'N') AND C_Paymentrequest_id = " + pr.get_ID();
                int cantDet = DB.getSQLValue(this.get_TrxName(), sqlcandet);
                if (cantDet > 0) {
                    return "Linea de Detalle no V\u00e1lida";
                }
            }
            boolean override = pr.get_ValueAsBoolean("Override");
            if (requestType.equals("I") && !override) {
                X_C_PaymentRequestLine[] lines;
                X_C_PaymentRequestLine[] x_C_PaymentRequestLineArray = lines = pr.getLines();
                int n2 = lines.length;
                n = 0;
                while (n < n2) {
                    MInvoice invo;
                    String sqlVal;
                    int cant;
                    X_C_PaymentRequestLine line = x_C_PaymentRequestLineArray[n];
                    if (line.getC_Invoice_ID() > 0 && (cant = DB.getSQLValue(null, sqlVal = "SELECT COUNT(*) FROM C_Payment cp WHERE cp.C_BPartner_ID = ? AND (SELECT COUNT(*) FROM C_AllocationLine cal WHERE cal.C_Payment_ID = cp.C_Payment_ID) < 1 AND cp.PayAmt = ? AND cp.IsReceipt = 'N' AND cp.DocStatus NOT IN ('VO')", (invo = new MInvoice(this.getCtx(), line.getC_Invoice_ID(), this.get_TrxName())).getC_BPartner_ID(), invo.getGrandTotal())) > 0) {
                        return "Existe un pago sin asignaciones para el mismo socio de negocio con el mismo monto que la factura " + invo.getDocumentNo();
                    }
                    ++n;
                }
            }
            if (requestType.equals("R") && pr.get_ValueAsInt("C_ProjectSchedule_ID") > 0) {
                X_C_ProjectSchedule ps = new X_C_ProjectSchedule(this.getCtx(), pr.get_ValueAsInt("C_ProjectSchedule_ID"), this.get_TrxName());
                BigDecimal usedRate = (BigDecimal)ps.get_Value("usedRate");
                usedRate = usedRate.add((BigDecimal)pr.get_Value("rate"));
                ps.set_CustomColumn("UsedRate", usedRate);
                ps.save();
            }
            pr.setDocStatus("WC");
            pr.setProcessed(true);
            pr.save();
            X_C_PaymentRequestLine[] x_C_PaymentRequestLineArray = pr.getLines();
            n = x_C_PaymentRequestLineArray.length;
            int usedRate = 0;
            while (usedRate < n) {
                X_C_PaymentRequestLine line = x_C_PaymentRequestLineArray[usedRate];
                line.setProcessed(true);
                line.save();
                ++usedRate;
            }
            this.commitEx();
            return "Solicitud Enviada";
        }
        if (pr.getDocStatus().equals("WC") && pr.isSignature1() && pr.isSignature2()) {
            if (requestType.equals("R")) {
                int id_invoice = 0;
                id_invoice = pr.get_ValueAsInt("C_Invoice_ID");
                if (id_invoice <= 0) {
                    return "Debe Estar Generada la Factura";
                }
            }
            if (requestType.equals("I") || requestType.equals("R") || requestType.equals("P") || requestType.equals("M")) {
                String com;
                MBankAccount bank;
                if (pr.getC_Payment_ID() > 0) {
                    this.log.log(Level.SEVERE, "Payment Already Generated");
                    return "Pago ya generado";
                }
                if (pr.getTenderType().equals("K") && (pr.getCheckNo() == null || pr.getCheckNo().length() == 0) && (bank = MBankAccount.get(this.getCtx(), pr.getC_BankAccount_ID())).get_ValueAsInt("CheckSequence") > 0) {
                    pr.setCheckNo(bank.get_ValueAsString("CheckSequence"));
                    bank.set_CustomColumn("CheckSequence", bank.get_ValueAsInt("CheckSequence") + 1);
                    bank.save();
                }
                MPayment pay = new MPayment(Env.getCtx(), 0, this.get_TrxName());
                pay.setIsReceipt(false);
                pay.setAD_Org_ID(pr.getAD_Org_ID());
                pay.setC_BPartner_ID(pr.getC_BPartner_ID());
                pay.setC_BankAccount_ID(pr.getC_BankAccount_ID());
                pay.setDateTrx(pr.getDateTrx());
                pay.setDateAcct(pr.getDateAcct());
                pay.setC_Currency_ID(pr.getC_Currency_ID());
                pay.setTenderType(pr.getTenderType());
                if (pr.getTenderType().equals("K")) {
                    pay.setCheckNo(pr.getCheckNo());
                }
                if (!requestType.equals("I")) {
                    pay.setC_Currency_ID(pr.getC_Currency_ID());
                }
                if (pr.getC_Charge_ID() > 0) {
                    pay.setC_Charge_ID(pr.getC_Charge_ID());
                }
                pay.setPayAmt(pr.getPayAmt());
                pay.set_CustomColumn("C_PaymentRequest_ID", pr.getC_PaymentRequest_ID());
                if (!pay.save()) {
                    this.log.log(Level.SEVERE, "Payment not save");
                    return "Payment not save ";
                }
                this.log.config("Payment ID :" + pay.getC_Payment_ID());
                pr.setDocStatus("CO");
                pr.setC_Payment_ID(pay.getC_Payment_ID());
                pr.setProcessed(true);
                pr.save();
                this.log.config("pr saved");
                pr.setDocStatus("CO");
                if (requestType.equals("I") && pr.getLines().length > 0) {
                    X_C_PaymentRequestLine[] lines;
                    MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, pr.getDateTrx(), pr.getC_Currency_ID(), "Payment Request", this.get_TrxName());
                    alloc.setAD_Org_ID(pr.getAD_Org_ID());
                    if (!alloc.save()) {
                        this.log.log(Level.SEVERE, "Allocation not created");
                        return "Allocation not created";
                    }
                    X_C_PaymentRequestLine[] invo = lines = pr.getLines();
                    int n = lines.length;
                    int n3 = 0;
                    while (n3 < n) {
                        X_C_PaymentRequestLine line = invo[n3];
                        if (line.getC_Invoice_ID() > 0) {
                            MAllocationLine aLine = new MAllocationLine(alloc, line.getAmt().negate(), Env.ZERO, Env.ZERO, Env.ZERO);
                            aLine.setC_Invoice_ID(line.getC_Invoice_ID());
                            aLine.setC_Payment_ID(pay.getC_Payment_ID());
                            if (!aLine.save()) {
                                this.log.log(Level.SEVERE, "Allocation Line not written ");
                            }
                        }
                        ++n3;
                    }
                }
                if (requestType.equals("R")) {
                    MProject pj = new MProject(this.getCtx(), pr.get_ValueAsInt("C_Project_ID"), this.get_TrxName());
                    pj.setProjectBalanceAmt(pj.getProjectBalanceAmt().add(pr.getPayAmt()));
                    pj.save();
                    if (pr.get_ValueAsInt("C_ProjectSchedule_ID") > 0) {
                        DB.executeUpdate("update C_ProjectSchedule set isvalid='N',C_PaymentRequest_ID=" + pr.getC_PaymentRequest_ID() + " where C_ProjectSchedule_ID=" + pr.get_ValueAsInt("C_ProjectSchedule_ID"), this.get_TrxName());
                    }
                    X_C_ProjectSchedule ps = new X_C_ProjectSchedule(this.getCtx(), pr.get_ValueAsInt("C_ProjectSchedule_ID"), this.get_TrxName());
                    String sqlUpdatePS = "";
                    try {
                        sqlUpdatePS = "update C_ProjectSchedule set processed = 'Y' where C_ProjectSchedule_ID = " + ps.get_ID();
                        DB.executeUpdate(sqlUpdatePS, this.get_TrxName());
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sqlUpdatePS, e);
                    }
                }
                if ((com = pr.get_ValueAsString("PayComplete")).equals("Y") || com.equals(true) || com.equalsIgnoreCase("true")) {
                    pay.setDocStatus(pay.completeIt());
                    String IsCon = pr.get_ValueAsString("IsReconciled");
                    if (IsCon.equals("Y") || IsCon.equals(true) || IsCon.equalsIgnoreCase("true")) {
                        pay.setIsReconciled(true);
                    }
                    pay.save();
                }
                if (requestType.equals("P")) {
                    pay.setIsAllocated(true);
                    pay.save();
                }
                this.commitEx();
                return "Pago Generado :" + pay.getDocumentNo();
            }
            X_C_PaymentRequestLine[] lines = pr.getLines();
            int count = 0;
            X_C_PaymentRequestLine[] x_C_PaymentRequestLineArray = lines;
            int n = lines.length;
            int n4 = 0;
            while (n4 < n) {
                X_C_PaymentRequestLine line = x_C_PaymentRequestLineArray[n4];
                MJournalLine gline = new MJournalLine(this.getCtx(), line.getGL_JournalLine_ID(), this.get_TrxName());
                MPayment pay = new MPayment(Env.getCtx(), 0, this.get_TrxName());
                pay.setIsReceipt(false);
                pay.setAD_Org_ID(pr.getAD_Org_ID());
                pay.setC_BPartner_ID(gline.get_ValueAsInt("C_BPartner_ID"));
                pay.setC_BankAccount_ID(pr.getC_BankAccount_ID());
                pay.setDateTrx(pr.getDateTrx());
                pay.setDateAcct(pr.getDateAcct());
                pay.setC_Currency_ID(pr.getC_Currency_ID());
                pay.setTenderType(pr.getTenderType());
                pay.setDescription(gline.getDescription());
                if (pr.getTenderType().equals("K")) {
                    pay.setCheckNo(pr.getCheckNo());
                }
                if (!requestType.equals("I")) {
                    pay.setC_Currency_ID(pr.getC_Currency_ID());
                }
                if (pr.getC_Charge_ID() > 0) {
                    pay.setC_Charge_ID(pr.getC_Charge_ID());
                }
                pay.setPayAmt(line.getAmt());
                pay.set_CustomColumn("C_PaymentRequest_ID", pr.getC_PaymentRequest_ID());
                pay.save();
                ++count;
                line.set_ValueOfColumn("C_Payment_ID", (Object)pay.getC_Payment_ID());
                line.save();
                String com = pr.get_ValueAsString("PayComplete");
                if (com.equals("Y") || com.equals(true) || com.equalsIgnoreCase("true")) {
                    pay.setDocStatus(pay.completeIt());
                    String IsCon = pr.get_ValueAsString("IsReconciled");
                    if (IsCon.equals("Y") || IsCon.equals(true) || IsCon.equalsIgnoreCase("true")) {
                        pay.setIsReconciled(true);
                    }
                    pay.save();
                }
                ++n4;
            }
            pr.setDocStatus("CO");
            pr.setProcessed(true);
            pr.save();
            return "Pagos Generados :" + count;
        }
        if (!(!pr.getDocStatus().equals("WC") || pr.isSignature1() && pr.isSignature2())) {
            return "La solicitud necesita ser aprobada para generar el pago";
        }
        return "Ninguna Accion Realizada";
    }
}

