/*
 * Decompiled with CFR 0.152.
 */
package org.prototipos.model;

import org.compiere.model.MClient;
import org.compiere.model.MInventory;
import org.compiere.model.MRequisition;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_M_InventoryLine;
import org.compiere.model.X_M_RequisitionLine;
import org.compiere.model.X_M_StorageReservation;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ModelPTTSM
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelPTTSM.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("M_Requisition", this);
        engine.addDocValidate("M_Inventory", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MInventory inv;
        X_M_StorageReservation sr;
        PO line;
        int i;
        PO[] lines;
        MRequisition req;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MRequisition.Table_ID && (req = (MRequisition)po).getDocBase().equals("RRC") && !req.isSOTrx()) {
            lines = req.getLines();
            i = 0;
            while (i < lines.length) {
                line = lines[i];
                if (((X_M_RequisitionLine)line).getM_Product_ID() > 0) {
                    sr = new X_M_StorageReservation(po.getCtx(), 0, po.get_TrxName());
                    sr.setM_Product_ID(((X_M_RequisitionLine)line).getM_Product_ID());
                    sr.setQtyOrdered(Env.ZERO);
                    sr.setQtyReserved(((X_M_RequisitionLine)line).getQty());
                    sr.setM_Warehouse_ID(req.getM_Warehouse_ID());
                    sr.save();
                }
                ++i;
            }
        }
        if (timing == 9 && po.get_Table_ID() == MInventory.Table_ID && (inv = (MInventory)po).get_ValueAsInt("M_Requisition_ID") > 0) {
            lines = inv.getLines(false);
            i = 0;
            while (i < lines.length) {
                line = lines[i];
                if (((X_M_InventoryLine)line).getM_Product_ID() > 0) {
                    sr = new X_M_StorageReservation(po.getCtx(), 0, po.get_TrxName());
                    sr.setM_Product_ID(((X_M_InventoryLine)line).getM_Product_ID());
                    sr.setQtyOrdered(Env.ZERO);
                    sr.setQtyReserved(((X_M_InventoryLine)line).getQtyInternalUse().negate());
                    sr.setM_Warehouse_ID(inv.getM_Warehouse_ID());
                    sr.save();
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

