/*
 * Decompiled with CFR 0.152.
 */
package org.prototipos.model;

import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_M_StorageReservation;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ModPetroAmericaUpdateReserved
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPetroAmericaUpdateReserved.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 11 && po.get_Table_ID() == MOrder.Table_ID) {
            MOrder order = (MOrder)po;
            MOrderLine[] lines = order.getLines(false, null);
            int i = 0;
            while (i < lines.length) {
                MOrderLine oLine = lines[i];
                if (oLine.getM_Product_ID() > 0 && oLine.getQtyReserved().compareTo(Env.ZERO) > 0 && oLine.getM_Product().isStocked() && oLine.getM_Product().getProductType().compareTo("I") == 0) {
                    oLine.setQtyReserved(Env.ZERO);
                    oLine.save();
                    X_M_StorageReservation sr = new X_M_StorageReservation(po.getCtx(), 0, po.get_TrxName());
                    sr.setM_Warehouse_ID(order.getM_Warehouse_ID());
                    sr.setM_Product_ID(oLine.getM_Product_ID());
                    sr.setQtyReserved(oLine.getQtyReserved().negate());
                    sr.save();
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

