/*
 * Decompiled with CFR 0.152.
 */
package org.petroamerica.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class UpdateBPCreditUF
extends SvrProcess {
    @Override
    protected void prepare() {
    }

    @Override
    protected String doIt() throws Exception {
        String sqlPList = "SELECT C_BPartner_ID FROM C_BPartner WHERE IsActive = 'Y'  AND AD_Client_ID = " + Env.getAD_Client_ID(this.getCtx());
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sqlPList, this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    MBPartner bp = new MBPartner(this.getCtx(), rs.getInt("C_BPartner_ID"), this.get_TrxName());
                    int ID_CLF = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(C_Currency_ID) FROM C_Currency WHERE CurSymbol = 'CLF'");
                    String sqlAmt = "SELECT currencyconvert(montouf," + ID_CLF + ",228,now(),114,AD_Client_ID,AD_Org_ID), C_Bpartner_ID, montouf" + " FROM C_BPartner bp WHERE C_BPartner_ID = " + bp.get_ID();
                    BigDecimal amtConvert = DB.getSQLValueBD(this.get_TrxName(), sqlAmt, new Object[0]);
                    if (amtConvert != null && amtConvert.compareTo(Env.ZERO) > 0) {
                        Object[] param = new BigDecimal[]{amtConvert};
                        DB.executeUpdateEx("UPDATE C_BPartner SET ExternalCreditLimit = ? WHERE C_BPartner_ID = " + bp.get_ID(), param, this.get_TrxName());
                    }
                    Timestamp dateStartCredit = (Timestamp)bp.get_Value("StartDateCreditLimit");
                    Timestamp dateEndCredit = (Timestamp)bp.get_Value("EndDateCreditLimit");
                    Timestamp today = new Timestamp(Calendar.getInstance().getTimeInMillis());
                    if (dateStartCredit != null && dateStartCredit.compareTo(today) > 0) {
                        bp.setSOCreditStatus("S");
                    }
                    if (dateEndCredit == null || dateEndCredit.compareTo(today) >= 0) continue;
                    bp.setSOCreditStatus("S");
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
                pstmt.close();
                rs.close();
                pstmt = null;
                rs = null;
            }
        }
        finally {
            pstmt.close();
            rs.close();
            pstmt = null;
            rs = null;
        }
        return "OK";
    }
}

