/*
 * Decompiled with CFR 0.152.
 */
package org.petroamerica.model;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModPAValidQtyInvoice
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPAValidQtyInvoice.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MInvoice.Table_ID) {
            MInvoice inv = (MInvoice)po;
            MInvoiceLine[] iLines = inv.getLines(false);
            int i = 0;
            while (i < iLines.length) {
                MInvoiceLine iLine = iLines[i];
                if (iLine.getC_OrderLine_ID() > 0) {
                    MOrderLine oLine = new MOrderLine(po.getCtx(), iLine.getC_OrderLine_ID(), po.get_TrxName());
                    BigDecimal qtyInvoiced = DB.getSQLValueBD(po.get_TrxName(), "SELECT SUM(qtyEntered)  FROM C_invoiceLine cil  INNER JOIN C_invoice ci ON (cil.C_invoice_ID = ci.C_invoice_ID)  WHERE ci.DocStatus IN ('CO','CL') AND C_OrderLine_ID = " + iLine.getC_OrderLine_ID(), new Object[0]);
                    if (qtyInvoiced == null) {
                        qtyInvoiced = Env.ZERO;
                    }
                    if ((qtyInvoiced = qtyInvoiced.add(iLine.getQtyEntered())).compareTo(oLine.getQtyEntered()) > 0) {
                        throw new AdempiereException("Error: Cantidad facturada mayor a cantidad de orden");
                    }
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

