/*
 * Decompiled with CFR 0.152.
 */
package org.petroamerica.model;

import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModPAUpdateCreditBPAD
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPAUpdateCreditBPAD.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_BPartner", this);
        engine.addDocValidate("C_Order", this);
        engine.addDocValidate("C_Payment", this);
        engine.addDocValidate("C_Invoice", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 5 && po.get_Table_ID() == MBPartner.Table_ID) {
            MBPartner bp = (MBPartner)po;
            DB.executeUpdate("UPDATE C_BPartner SET SO_CreditLimit = 0, SO_CreditUsed = 0,  TotalOpenBalance = 0 WHERE C_BPartner_ID = " + bp.get_ID(), po.get_TrxName());
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MPayment pay;
        MBPartner bp;
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)po).isSOTrx()) {
            bp = new MBPartner(po.getCtx(), order.getC_BPartner_ID(), po.get_TrxName());
            bp.setSO_CreditLimit(Env.ZERO);
            bp.setSO_CreditUsed(Env.ZERO);
            bp.setTotalOpenBalance(Env.ZERO);
            bp.save();
        }
        if (timing == 9 && po.get_Table_ID() == MPayment.Table_ID && (pay = (MPayment)po).isReceipt()) {
            bp = new MBPartner(po.getCtx(), pay.getC_BPartner_ID(), po.get_TrxName());
            bp.setSO_CreditLimit(Env.ZERO);
            bp.setSO_CreditUsed(Env.ZERO);
            bp.setTotalOpenBalance(Env.ZERO);
            bp.save();
        }
        if (timing == 9 && po.get_Table_ID() == MInvoice.Table_ID) {
            MInvoice inv = (MInvoice)po;
            bp = new MBPartner(po.getCtx(), inv.getC_BPartner_ID(), po.get_TrxName());
            bp.setSO_CreditLimit(Env.ZERO);
            bp.setSO_CreditUsed(Env.ZERO);
            bp.setTotalOpenBalance(Env.ZERO);
            bp.save();
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

