/*
 * Decompiled with CFR 0.152.
 */
package org.petroamerica.model;

import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrg;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.EMail;

public class ModPASendMailInvalidOrder
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPASendMailInvalidOrder.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_Order", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MUser user;
        MOrg org;
        int ID_User;
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 5 && po.get_Table_ID() == MOrder.Table_ID && po.is_ValueChanged("DocStatus") && (order = (MOrder)po).getDocStatus().compareTo("IN") == 0 && (ID_User = (org = new MOrg(po.getCtx(), order.getAD_Org_ID(), po.get_TrxName())).get_ValueAsInt("SalesRep_ID")) > 0 && (user = new MUser(po.getCtx(), ID_User, po.get_TrxName())).getEMail() != null) {
            String ln = System.getProperty("line.separator");
            StringBuilder str = new StringBuilder();
            str.append("Estimado Usuario:");
            str.append(ln);
            str.append(ln);
            str.append("La nota de venta numero " + order.getDocumentNo() + ", ha quedado en estado invalido");
            str.append(ln);
            str.append("Se ruega revisar la situaci\u00f3n");
            str.append(ln);
            str.append(ln);
            str.append(ln);
            str.append("ATTE Adempiere");
            MClient client = new MClient(po.getCtx(), order.getAD_Client_ID(), po.get_TrxName());
            EMail mail = new EMail(client, client.getRequestEMail(), user.getEMail(), "Nota de venta " + order.getDocumentNo() + " con problemas", str.toString());
            mail.createAuthenticator(client.getRequestUser(), client.getRequestUserPW());
            mail.send();
            log.config("Correo Enviado a " + user.getEMail());
            log.config("Errores Correo: " + mail.getSentMsg());
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

