/*
 * Decompiled with CFR 0.152.
 */
package org.pdv.model;

import org.compiere.model.MClient;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModPDVValidatorPaymentVoid
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPDVValidatorPaymentVoid.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Payment", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 2 && po.get_Table_ID() == MPayment.Table_ID) {
            MPayment pay = (MPayment)po;
            String custodio = "";
            custodio = pay.get_ValueAsString("Custodio");
            if (pay.isReceipt()) {
                if (custodio == "B" || custodio == "C" || custodio == "D" || custodio == "E" || custodio == "F" || custodio == "O" || custodio == "P" || custodio == "X") {
                    return "Pago en Custodio, no se puede anular";
                }
                if (pay.isReconciled()) {
                    return "Pago conciliado, no se puede anular";
                }
                if (pay.isAllocated()) {
                    return "Pago asignado, no se puede anular";
                }
                String sqlValid = "SELECT COUNT(1) FROM C_AllocationLine cal INNER JOIN C_AllocationHdr ca ON (cal.C_AllocationHdr_ID = ca.C_AllocationHdr_ID )  WHERE ca.docstatus IN ('CO','CL') AND cal.C_Payment_ID = " + pay.get_ID();
                int cant = DB.getSQLValue(po.get_TrxName(), sqlValid);
                if (cant > 0) {
                    return "Pago asignado, no se puede anular";
                }
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

