/*
 * Decompiled with CFR 0.152.
 */
package org.pdv.model;

import java.math.BigDecimal;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_EO_Budget;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModPDVAmtBudget
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPDVAmtBudget.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_InvoiceLine", this);
        engine.addModelChange("EO_Budget", this);
        engine.addDocValidate("M_Requisition", this);
        engine.addDocValidate("C_Invoice", this);
        engine.addDocValidate("C_AllocationHdr", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 2 || type == 1) && po.get_Table_ID() == MInvoiceLine.Table_ID) {
            int id_BudLine;
            MInvoiceLine invLine = (MInvoiceLine)po;
            MInvoice inv = new MInvoice(po.getCtx(), invLine.getC_Invoice_ID(), po.get_TrxName());
            if (!inv.isSOTrx() && invLine.getC_OrderLine_ID() > 0 && (id_BudLine = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(EO_budget_ID) FROM M_RequisitionLine WHERE C_OrderLine_ID = " + invLine.getC_OrderLine_ID())) > 0) {
                invLine.set_CustomColumn("EO_Budget_ID", id_BudLine);
            }
        }
        if ((type == 2 || type == 1) && po.get_Table_ID() == X_EO_Budget.Table_ID) {
            X_EO_Budget bud = (X_EO_Budget)po;
            BigDecimal amtExe = (BigDecimal)bud.get_Value("QtyExecuted");
            BigDecimal amtAva = (BigDecimal)bud.get_Value("QtyAvailable");
            if (amtAva == null) {
                amtAva = bud.getTotalAmt();
            }
            if (amtExe == null) {
                amtExe = Env.ZERO;
            }
            if (amtAva != null && amtExe != null) {
                amtAva = amtAva.subtract(amtExe);
            }
            DB.executeUpdate("UPDATE EO_Budget SET QtyAvailable = " + amtAva + " WHERE EO_Budget_ID = " + bud.get_ID(), po.get_TrxName());
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        BigDecimal qtyExe;
        BigDecimal qtyNeto;
        X_EO_Budget bud;
        int id_Budget;
        MInvoiceLine iline;
        MInvoiceLine[] iLines;
        MAllocationLine aline;
        MAllocationLine[] aLines;
        MAllocationHdr alloHdr;
        int i;
        MRequisition req;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MRequisition.Table_ID && !(req = (MRequisition)po).isSOTrx()) {
            MRequisitionLine[] rLines = req.getLines();
            i = 0;
            while (i < rLines.length) {
                MRequisitionLine line = rLines[i];
                int id_Budget2 = line.get_ValueAsInt("EO_Budget_ID");
                if (id_Budget2 > 0) {
                    X_EO_Budget bud2 = new X_EO_Budget(po.getCtx(), id_Budget2, po.get_TrxName());
                    BigDecimal amt = Env.ZERO;
                    amt = line.getLineNetAmt();
                    BigDecimal qtyComm = (BigDecimal)bud2.get_Value("QtyCommitted");
                    if (qtyComm == null) {
                        qtyComm = Env.ZERO;
                    }
                    qtyComm = qtyComm != null ? qtyComm.add(amt) : amt;
                    bud2.set_CustomColumn("QtyCommitted", qtyComm);
                    bud2.save();
                }
                ++i;
            }
        }
        if (timing == 9 && po.get_Table_ID() == MAllocationHdr.Table_ID) {
            alloHdr = (MAllocationHdr)po;
            aLines = alloHdr.getLines(false);
            i = 0;
            while (i < aLines.length) {
                aline = aLines[i];
                if (aline.getC_Payment_ID() > 0 && aline.getC_Invoice_ID() > 0 && !aline.getC_Invoice().isSOTrx()) {
                    MInvoice inv = new MInvoice(po.getCtx(), aline.getC_Invoice_ID(), po.get_TrxName());
                    iLines = inv.getLines();
                    int a2 = 0;
                    while (a2 < iLines.length) {
                        iline = iLines[a2];
                        id_Budget = iline.get_ValueAsInt("EO_Budget_ID");
                        if (id_Budget > 0) {
                            bud = new X_EO_Budget(po.getCtx(), id_Budget, po.get_TrxName());
                            qtyNeto = Env.ZERO;
                            qtyNeto = aline.getAmount().abs().compareTo(iline.getLineNetAmt()) > 0 ? iline.getLineNetAmt() : aline.getAmount().abs();
                            qtyExe = (BigDecimal)bud.get_Value("QtyExecuted");
                            if (qtyExe == null) {
                                qtyExe = Env.ZERO;
                            }
                            qtyExe = qtyExe != null ? qtyExe.add(qtyNeto) : qtyNeto;
                            bud.set_CustomColumn("QtyExecuted", qtyExe);
                            bud.save();
                        }
                        ++a2;
                    }
                }
                ++i;
            }
        }
        if (timing == 10 && po.get_Table_ID() == MAllocationHdr.Table_ID) {
            alloHdr = (MAllocationHdr)po;
            aLines = alloHdr.getLines(false);
            i = 0;
            while (i < aLines.length) {
                aline = aLines[i];
                if (aline.getC_Payment_ID() > 0 && aline.getC_Invoice_ID() > 0 && !aline.getC_Invoice().isSOTrx()) {
                    MInvoice inv = new MInvoice(po.getCtx(), aline.getC_Invoice_ID(), po.get_TrxName());
                    iLines = inv.getLines();
                    int a3 = 0;
                    while (a3 < iLines.length) {
                        iline = iLines[a3];
                        id_Budget = iline.get_ValueAsInt("EO_Budget_ID");
                        if (id_Budget > 0) {
                            bud = new X_EO_Budget(po.getCtx(), id_Budget, po.get_TrxName());
                            qtyNeto = Env.ZERO;
                            qtyNeto = aline.getAmount().abs().compareTo(iline.getLineNetAmt()) > 0 ? iline.getLineNetAmt() : aline.getAmount().abs();
                            qtyExe = (BigDecimal)bud.get_Value("QtyExecuted");
                            if (qtyExe == null) {
                                qtyExe = Env.ZERO;
                            }
                            qtyExe = qtyExe != null ? qtyExe.subtract(qtyNeto) : qtyNeto;
                            bud.set_CustomColumn("QtyExecuted", qtyExe);
                            bud.save();
                        }
                        ++a3;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

