/*
 * Decompiled with CFR 0.152.
 */
package org.pdv.model;

import org.compiere.acct.FactLine;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModPDVAcctAPInvoice
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPDVAcctAPInvoice.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("Fact_Acct", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MInvoice inv;
        FactLine fLine;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (!(type != 5 && type != 4 || po.get_Table_ID() != FactLine.Table_ID || (fLine = (FactLine)po).getAD_Table_ID() != MInvoice.Table_ID || (inv = new MInvoice(po.getCtx(), fLine.getRecord_ID(), po.get_TrxName())).isSOTrx() || fLine.getM_Product_ID() <= 0)) {
            MInvoiceLine[] lines = inv.getLines(false);
            int i = 0;
            while (i < lines.length) {
                MInvoiceLine line = lines[i];
                if (line.getM_Product_ID() == fLine.getM_Product_ID() && fLine.getLine_ID() == line.get_ID()) {
                    String sqlChargeAcct = "SELECT MAX(ch_expense_acct)  FROM m_attributesetinstance asi  INNER JOIN m_attributeinstance ai ON  (asi.m_attributesetinstance_id = ai.m_attributesetinstance_id) LEFT JOIN M_AttributeValue av on (ai.M_AttributeValue_ID = av.M_AttributeValue_ID) LEFT JOIN C_Charge_Acct ca on (av.c_charge_id = ca.c_charge_id) where ai.m_attributesetinstance_id  = " + line.getM_AttributeSetInstance_ID();
                    int id_chargeAcct = DB.getSQLValue(po.get_TrxName(), sqlChargeAcct);
                    if (id_chargeAcct > 0) {
                        int id_acct = DB.getSQLValue(po.get_TrxName(), "SELECT account_id FROM c_validcombination where c_validcombination_id = " + id_chargeAcct);
                        DB.executeUpdateEx("UPDATE Fact_Acct SET account_id = " + id_acct + " WHERE fact_acct_id = " + fLine.get_ID(), po.get_TrxName());
                    }
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

