/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import org.compiere.model.X_RH_AttendanceAndPunctuality;
import org.compiere.model.X_RH_AttendancePunctualityLog;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class ReadRHDateTime
extends SvrProcess {
    private String P_Archive;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("FileName")) {
                    this.P_Archive = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        int err;
        int ok;
        block17: {
            BufferedReader br = null;
            ok = 0;
            err = 0;
            try {
                try {
                    String sCurrentLine;
                    br = new BufferedReader(new FileReader(this.P_Archive));
                    while ((sCurrentLine = br.readLine()) != null) {
                        int bPartner_ID;
                        this.log.fine("line: " + sCurrentLine);
                        String[] data = sCurrentLine.split(" ");
                        String rut = data[1];
                        String fecha = data[2];
                        String hora = data[3];
                        String tipo = data[4];
                        if (rut.charAt(0) == '0') {
                            rut = rut.substring(1);
                        }
                        if ((bPartner_ID = DB.getSQLValue(this.get_TrxName(), "select C_BPartner_ID from C_BPartner where value=?", rut)) > 0) {
                            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
                            Date parsedDate = dateFormat.parse(fecha);
                            Timestamp rDate = new Timestamp(parsedDate.getTime());
                            int count = DB.getSQLValue(this.get_TrxName(), "select count(1) from RH_AttendanceAndPunctuality where C_BPartner_ID=? and RegisterTime=? and RegisterDate=?", bPartner_ID, hora, rDate);
                            if (count > 0) continue;
                            X_RH_AttendanceAndPunctuality rh = new X_RH_AttendanceAndPunctuality(this.getCtx(), 0, this.get_TrxName());
                            rh.setDescription(sCurrentLine);
                            rh.setRegisterTime(hora);
                            rh.setTimeType(tipo);
                            rh.setC_BPartner_ID(bPartner_ID);
                            rh.setRegisterDate(rDate);
                            rh.save();
                            ++ok;
                            continue;
                        }
                        X_RH_AttendancePunctualityLog rh = new X_RH_AttendancePunctualityLog(this.getCtx(), 0, this.get_TrxName());
                        rh.setDescription(sCurrentLine);
                        rh.save();
                        ++err;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (br != null) {
                            br.close();
                        }
                        break block17;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return "OK : " + ok + " Errores :" + err;
    }
}

