/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.X_PM_Approval;
import org.compiere.model.X_PM_Scoring;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class ProcessPMScoring
extends SvrProcess {
    private String P_DocAction;
    private int Record_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocAction")) {
                    this.P_DocAction = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.Record_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        X_PM_Scoring Score = new X_PM_Scoring(Env.getCtx(), this.Record_ID, this.get_TrxName());
        if (this.P_DocAction.equals("CO") && !Score.isProcessed()) {
            if (this.getPending(Score.getPM_Tender_ID()) > 0) {
                return "existen proyectos sin evaluar";
            }
            X_PM_Approval App = this.getApproval();
            if (App == null) {
                App = new X_PM_Approval(Env.getCtx(), 0, this.get_TrxName());
                App.setAD_Org_ID(Score.getAD_Org_ID());
                App.setDateTrx(new Timestamp(TimeUtil.getToday().getTimeInMillis()));
                App.setPM_Scoring_ID(Score.getPM_Scoring_ID());
                App.setPM_Tender_ID(Score.getPM_Tender_ID());
                App.setDocStatus("DR");
                App.save();
            } else {
                App.setDocStatus("DR");
                App.save();
            }
            Score.setProcessed(true);
            Score.setDocStatus("CO");
            Score.save();
            return "Confirmado";
        }
        return "No es posible Cumplir la Accion ";
    }

    public X_PM_Approval getApproval() {
        CPreparedStatement pstmt = null;
        X_PM_Approval Pro = null;
        String mysql = "SELECT * from PM_Approval where PM_Scoring_ID = ?";
        try {
            pstmt = DB.prepareStatement(mysql, this.get_TrxName());
            pstmt.setInt(1, this.Record_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                Pro = new X_PM_Approval(Env.getCtx(), rs, this.get_TrxName());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return Pro;
    }

    public int getPending(int Tender_ID) {
        int count = 0;
        CPreparedStatement pstmt = null;
        String mysql = "SELECT count(1) from c_project where (score is null or score=0 ) and pm_tender_id = ?";
        try {
            pstmt = DB.prepareStatement(mysql, this.get_TrxName());
            pstmt.setInt(1, Tender_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return count;
    }
}

