/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.X_DM_Document;
import org.compiere.model.X_DM_DocumentLine;
import org.compiere.model.X_DM_MandateAgreement;
import org.compiere.model.X_PM_Approval;
import org.compiere.model.X_PM_Proposal;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class ProcessPMProposal
extends SvrProcess {
    private String P_DocAction;
    private int Record_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocAction")) {
                    this.P_DocAction = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.Record_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        X_PM_Proposal Pro = new X_PM_Proposal(Env.getCtx(), this.Record_ID, this.get_TrxName());
        if (this.P_DocAction.equals("CO") && !Pro.isProcessed()) {
            if (this.getPending(Pro.getPM_Tender_ID()) > 0) {
                return "Aun quedan proyectos sin presupuesto asignado";
            }
            this.create(Pro.getPM_Tender_ID(), Pro.getAD_Org_ID());
            Pro.setProcessed(true);
            Pro.setDocStatus("CO");
            Pro.save();
            return "Confirmado";
        }
        if (this.P_DocAction.equals("RJ") && !Pro.isProcessed() && Pro.getDocStatus().equals("DR")) {
            X_PM_Approval App = new X_PM_Approval(Env.getCtx(), Pro.getPM_Approval_ID(), this.get_TrxName());
            App.setDocStatus("NA");
            App.setProcessed(false);
            App.save();
            Pro.setProcessed(false);
            Pro.setDocStatus("WC");
            Pro.save();
            return "Propuesta Rechazada";
        }
        return "No es posible Cumplir la Accion ";
    }

    public void create(int Tender_ID, int Org_ID) {
        CPreparedStatement pstmt = null;
        String mysql = "SELECT c_project_id,committedamt,POReference,C_BPartner_ID,C_BPartnerC_ID,C_BPartnerA_ID,PM_Gore_UT,plannedamt,Year from c_project where isapproved='Y' and pm_tender_id = ?";
        try {
            pstmt = DB.prepareStatement(mysql, this.get_TrxName());
            pstmt.setInt(1, Tender_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MProjectLine[] lines;
                BigDecimal pct = rs.getBigDecimal("committedamt").multiply(Env.ONEHUNDRED);
                pct = pct.divide(rs.getBigDecimal("plannedamt"), 6, 4);
                pct = pct.divide(Env.ONEHUNDRED);
                MProject pj = new MProject(Env.getCtx(), rs.getInt(1), this.get_TrxName());
                MProjectLine[] mProjectLineArray = lines = pj.getLines();
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    MProjectLine line = mProjectLineArray[n2];
                    line.setCommittedAmt(line.getPlannedAmt().multiply(pct).setScale(0, 4));
                    line.saveEx();
                    ++n2;
                }
                X_DM_MandateAgreement cm = new X_DM_MandateAgreement(Env.getCtx(), 0, this.get_TrxName());
                cm.setAD_Org_ID(Org_ID);
                cm.setDocStatus("DR");
                cm.setC_Project_ID(rs.getInt(1));
                cm.setDateTrx(new Timestamp(TimeUtil.getToday().getTimeInMillis()));
                cm.setAmt(rs.getBigDecimal(2));
                cm.setAllocatedAmt(rs.getBigDecimal(2));
                cm.set_CustomColumn("Year", rs.getString("Year"));
                cm.set_CustomColumn("Code", rs.getString("POReference"));
                cm.set_CustomColumn("C_BPartner_ID", rs.getInt("C_BPartner_ID"));
                cm.set_CustomColumn("C_BPartnerC_ID", rs.getInt("C_BPartnerC_ID"));
                cm.set_CustomColumn("C_BPartnerA_ID", rs.getInt("C_BPartnerA_ID"));
                BigDecimal factor = DB.getSQLValueBD(this.get_TrxName(), "select factor from PM_YearFactor where Year=?", rs.getString("Year"));
                cm.set_CustomColumn("Factor", factor == null ? Env.ONE : factor);
                if (rs.getString("PM_Gore_UT").equals("Y")) {
                    cm.set_CustomColumn("DM_MandateAgreementType", "02");
                } else {
                    cm.set_CustomColumn("DM_MandateAgreementType", "01");
                }
                cm.save();
                X_DM_Document rss = new X_DM_Document(Env.getCtx(), 0, this.get_TrxName());
                rss.setAD_Org_ID(Org_ID);
                rss.setDocStatus("DR");
                rss.setC_Project_ID(rs.getInt(1));
                rss.setDM_DocumentType("AP");
                rss.setDateTrx(new Timestamp(TimeUtil.getToday().getTimeInMillis()));
                rss.setAmt(Env.ZERO);
                rss.save();
                String sql2 = "select C_ProjectLine_ID, Line, Description, M_Product_ID, PlannedPrice from C_projectline where c_project_id =? ";
                try {
                    CPreparedStatement pstmtl = DB.prepareStatement(sql2, this.get_TrxName());
                    pstmtl.setInt(1, rs.getInt(1));
                    ResultSet rsl = pstmtl.executeQuery();
                    while (rsl.next()) {
                        X_DM_DocumentLine dcl = new X_DM_DocumentLine(this.getCtx(), 0, this.get_TrxName());
                        dcl.setDM_Document_ID(rss.getDM_Document_ID());
                        dcl.setAmt(rsl.getBigDecimal(5));
                        dcl.set_CustomColumn("C_ProjectLine_ID", rsl.getInt(1));
                        dcl.setM_Product_ID(rsl.getInt(4));
                        dcl.setDateTrx(new Timestamp(TimeUtil.getToday().getTimeInMillis()));
                        dcl.setDescription(rsl.getString(3));
                        dcl.save();
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), e);
                }
                pj.set_CustomColumn("IsPriorized", true);
                pj.save();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public int getPending(int Tender_ID) {
        int count = 0;
        CPreparedStatement pstmt = null;
        String mysql = "SELECT count(1) from c_project where isapproved='Y' and score>=60 and committedamt=0 and pm_tender_id = ?";
        try {
            pstmt = DB.prepareStatement(mysql, this.get_TrxName());
            pstmt.setInt(1, Tender_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return count;
    }
}

