/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MGLCategory;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MYear;
import org.compiere.model.X_GL_JournalBatch;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GeneralClose
extends SvrProcess {
    private int p_Org_ID;
    private int p_Year_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Org_ID")) {
                    this.p_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Year_ID")) {
                    this.p_Year_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        CPreparedStatement pstmt = null;
        String mysql = "SELECT f.account_id,sum(f.amtacctdr) as amtdr,sum(f.amtacctcr) as amtcr from fact_acct f Inner Join c_period p on (p.c_period_id=f.c_period_id) where p.c_year_id=?  AND (f.AD_Org_ID=? OR f.AD_Org_ID in (Select oi.AD_ORG_ID from AD_orginfo oi where oi.PARENT_ORG_ID=?) ) group by f.account_id";
        MPeriod period = this.getPeriod();
        MAcctSchema as = MAcctSchema.getClientAcctSchema(this.getCtx(), Env.getAD_Client_ID(this.getCtx()))[0];
        X_GL_JournalBatch batch = null;
        MJournal journal = null;
        try {
            pstmt = DB.prepareStatement(mysql, this.get_TrxName());
            pstmt.setInt(1, this.p_Year_ID);
            pstmt.setInt(2, this.p_Org_ID);
            pstmt.setInt(3, this.p_Org_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (batch == null) {
                    MClient client = MClient.get(this.getCtx(), Env.getAD_Client_ID(this.getCtx()));
                    MYear year = new MYear(this.getCtx(), this.p_Year_ID, this.get_TrxName());
                    batch = new MJournalBatch(this.getCtx(), 0, this.get_TrxName());
                    ((MJournalBatch)batch).setClientOrg(this.getAD_Client_ID(), this.p_Org_ID);
                    batch.setDescription("Cierre General " + year.getYearAsInt());
                    batch.setDateDoc(period.getEndDate());
                    ((MJournalBatch)batch).setDateAcct(period.getEndDate());
                    batch.setC_DocType_ID(MDocType.getOfDocBaseType(this.getCtx(), "GLJ")[0].getC_DocType_ID());
                    batch.setGL_Category_ID(MGLCategory.getDefault(this.getCtx(), "M").getGL_Category_ID());
                    batch.setC_Period_ID(period.getC_Period_ID());
                    batch.setC_Currency_ID(client.getC_Currency_ID());
                    batch.setPostingType("E");
                    batch.save();
                    journal = new MJournal((MJournalBatch)batch);
                    journal.setDescription("Cierre General " + year.getYearAsInt());
                    journal.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
                    journal.setGL_Category_ID(MGLCategory.getDefault(this.getCtx(), "D").getGL_Category_ID());
                    journal.setC_ConversionType_ID(114);
                    journal.setPostingType("E");
                    journal.save();
                }
                MJournalLine line = new MJournalLine(journal);
                line.setAmtSourceDr(rs.getBigDecimal("amtcr"));
                line.setAmtSourceCr(rs.getBigDecimal("amtdr"));
                line.setAmtAcct(rs.getBigDecimal("amtcr"), rs.getBigDecimal("amtdr"));
                line.setC_ValidCombination_ID(this.getCombination(rs.getInt(1)));
                line.save();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        if (batch == null) {
            return " Sin Movimientos";
        }
        return batch.getDocumentNo();
    }

    public MPeriod getPeriod() {
        CPreparedStatement pstmt = null;
        String sql = "select * from c_period where c_year_id = ? and periodno=12";
        MPeriod period = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.p_Year_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                period = new MPeriod(this.getCtx(), rs, this.get_TrxName());
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return period;
    }

    public int getCombination(int account_id) {
        CPreparedStatement pstmt = null;
        String sql = "select c_validcombination_id from C_ValidCombination where account_id=?";
        int account = 0;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, account_id);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                account = rs.getInt(1);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return account;
    }
}

