/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MConversionRate;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrg;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.ofb.model.OFBForward;
import org.ofb.process.CXFConnector;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ExportDTEMInOutFOL
extends SvrProcess {
    private Properties m_ctx;
    private int p_M_InOut_ID = 0;
    public String urlPdf = "";

    @Override
    protected void prepare() {
        this.p_M_InOut_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    @Override
    protected String doIt() throws Exception {
        MInOut inOut = new MInOut(this.m_ctx, this.p_M_InOut_ID, this.get_TrxName());
        String msg = this.CreateXMLCG(inOut);
        return msg;
    }

    public String CreateXMLCG(MInOut inOut) {
        String wsRespuesta = "";
        MDocType doc = new MDocType(inOut.getCtx(), inOut.getC_DocType_ID(), inOut.get_TrxName());
        if (doc.get_Value("CreateXML") == null) {
            return "";
        }
        if (!((Boolean)doc.get_Value("CreateXML")).booleanValue()) {
            return "";
        }
        int typeDoc = Integer.parseInt((String)doc.get_Value("DocumentNo"));
        if (typeDoc == 0) {
            return "";
        }
        String mylog = new String();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation implementation = builder.getDOMImplementation();
            Document document = implementation.createDocument(null, "DTE", null);
            document.setXmlVersion("1.0");
            document.setTextContent("text/xml");
            Attr atr = document.createAttribute("xmlns");
            atr.setValue("http://www.sii.cl/SiiDte");
            Element Documento = document.createElement("Documento");
            document.getDocumentElement().appendChild(Documento);
            Documento.setAttribute("ID", "F" + inOut.getDocumentNo() + "T" + (String)doc.get_Value("DocumentNo"));
            Element Encabezado = document.createElement("Encabezado");
            Documento.appendChild(Encabezado);
            Element IdDoc = document.createElement("IdDoc");
            Encabezado.appendChild(IdDoc);
            mylog = "IdDoc";
            Element TipoDTE = document.createElement("TipoDTE");
            Text text = document.createTextNode(Integer.toString(typeDoc));
            TipoDTE.appendChild(text);
            IdDoc.appendChild(TipoDTE);
            Element Folio = document.createElement("Folio");
            Text fo = document.createTextNode(inOut.getDocumentNo());
            Folio.appendChild(fo);
            IdDoc.appendChild(Folio);
            Element FchEmis = document.createElement("FchEmis");
            Text emis = document.createTextNode(inOut.getMovementDate().toString().substring(0, 10));
            FchEmis.appendChild(emis);
            IdDoc.appendChild(FchEmis);
            Element TipoDespacho = document.createElement("TipoDespacho");
            Text TDespacho = document.createTextNode("2");
            TipoDespacho.appendChild(TDespacho);
            IdDoc.appendChild(TipoDespacho);
            String IndTrl = null;
            try {
                IndTrl = inOut.get_ValueAsString("IndTraslado");
            }
            catch (Exception e) {
                IndTrl = "1";
            }
            if (IndTrl == null || IndTrl == "" || IndTrl == " ") {
                IndTrl = "1";
            }
            if (IndTrl != null && IndTrl.length() > 0) {
                Element IndTraslado = document.createElement("IndTraslado");
                Text iTraslado = document.createTextNode(IndTrl);
                IndTraslado.appendChild(iTraslado);
                IdDoc.appendChild(IndTraslado);
            }
            Element Emisor = document.createElement("Emisor");
            Encabezado.appendChild(Emisor);
            mylog = "Emisor";
            MOrg company = MOrg.get(inOut.getCtx(), inOut.getAD_Org_ID());
            Element Rut = document.createElement("RUTEmisor");
            Text rut = document.createTextNode((String)company.get_Value("Rut"));
            Rut.appendChild(rut);
            Emisor.appendChild(Rut);
            String nameRzn = company.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = company.getName();
            }
            nameRzn = nameRzn.replace("'", "");
            nameRzn = nameRzn.replace("\"", "");
            Element RznSoc = document.createElement("RznSoc");
            Text rzn = document.createTextNode(nameRzn);
            RznSoc.appendChild(rzn);
            Emisor.appendChild(RznSoc);
            String giroEmisStr = (String)company.get_Value("Giro");
            giroEmisStr = giroEmisStr.replace("'", "");
            giroEmisStr = giroEmisStr.replace("\"", "");
            Element GiroEmis = document.createElement("GiroEmis");
            Text gi = document.createTextNode(giroEmisStr);
            GiroEmis.appendChild(gi);
            Emisor.appendChild(GiroEmis);
            Element Acteco = document.createElement("Acteco");
            Text teco = document.createTextNode((String)company.get_Value("Acteco"));
            Acteco.appendChild(teco);
            Emisor.appendChild(Acteco);
            Element DirOrigen = document.createElement("DirOrigen");
            Text dir = document.createTextNode((String)company.get_Value("Address1"));
            DirOrigen.appendChild(dir);
            Emisor.appendChild(DirOrigen);
            Element CmnaOrigen = document.createElement("CmnaOrigen");
            Text com = document.createTextNode((String)company.get_Value("Comuna"));
            CmnaOrigen.appendChild(com);
            Emisor.appendChild(CmnaOrigen);
            Element CiudadOrigen = document.createElement("CiudadOrigen");
            Text city = document.createTextNode((String)company.get_Value("City"));
            CiudadOrigen.appendChild(city);
            Emisor.appendChild(CiudadOrigen);
            mylog = "receptor";
            MBPartner BP = new MBPartner(inOut.getCtx(), inOut.getC_BPartner_ID(), inOut.get_TrxName());
            MBPartnerLocation bloc = new MBPartnerLocation(inOut.getCtx(), inOut.getC_BPartner_Location_ID(), inOut.get_TrxName());
            Element Receptor = document.createElement("Receptor");
            Encabezado.appendChild(Receptor);
            Element RUTRecep = document.createElement("RUTRecep");
            Text rutc = document.createTextNode(BP.getValue() + "-" + BP.get_ValueAsString("Digito"));
            RUTRecep.appendChild(rutc);
            Receptor.appendChild(RUTRecep);
            String RznSocRecepStr = BP.getName();
            RznSocRecepStr = RznSocRecepStr.replace("'", "");
            RznSocRecepStr = RznSocRecepStr.replace("\"", "");
            Element RznSocRecep = document.createElement("RznSocRecep");
            Text RznSocR = document.createTextNode(RznSocRecepStr);
            RznSocRecep.appendChild(RznSocR);
            Receptor.appendChild(RznSocRecep);
            Element GiroRecep = document.createElement("GiroRecep");
            Text giro = document.createTextNode((String)BP.get_Value("Giro"));
            GiroRecep.appendChild(giro);
            Receptor.appendChild(GiroRecep);
            Element ContactoRecep = document.createElement("Contacto");
            Text contacto = document.createTextNode(inOut.getAD_User_ID() > 0 ? inOut.getAD_User().getName() : " ");
            ContactoRecep.appendChild(contacto);
            Receptor.appendChild(ContactoRecep);
            String dirRecepStr = bloc.getLocation(true).getAddress1();
            dirRecepStr = dirRecepStr.replace("'", "");
            dirRecepStr = dirRecepStr.replace("\"", "");
            Element DirRecep = document.createElement("DirRecep");
            Text dirr = document.createTextNode(dirRecepStr);
            DirRecep.appendChild(dirr);
            Receptor.appendChild(DirRecep);
            String CmnaRecepStr = null;
            CmnaRecepStr = bloc.getLocation(true).getAddress2() != null ? bloc.getLocation(true).getAddress2() : (bloc.getLocation(true).getC_City_ID() > 0 ? MCity.get(inOut.getCtx(), bloc.getLocation(true).getC_City_ID()).getName() : bloc.getLocation(true).getAddress3());
            Element CmnaRecep = document.createElement("CmnaRecep");
            Text Cmna = document.createTextNode(CmnaRecepStr);
            CmnaRecep.appendChild(Cmna);
            Receptor.appendChild(CmnaRecep);
            Element CiudadRecep = document.createElement("CiudadRecep");
            Text reg = document.createTextNode(bloc.getLocation(true).getC_City_ID() > 0 ? MCity.get(inOut.getCtx(), bloc.getLocation(true).getC_City_ID()).getName() : "Santiago");
            CiudadRecep.appendChild(reg);
            Receptor.appendChild(CiudadRecep);
            mylog = "Totales";
            Element Totales = document.createElement("Totales");
            Encabezado.appendChild(Totales);
            BigDecimal amountGrandT = Env.ZERO;
            BigDecimal priceT = Env.ZERO;
            BigDecimal taxAmt = Env.ZERO;
            BigDecimal taxIVAAmt = Env.ZERO;
            BigDecimal taxIVAAmtAcu = Env.ZERO;
            BigDecimal taxExeAmtAcu = Env.ZERO;
            BigDecimal taxNetoAmtAcu = Env.ZERO;
            BigDecimal tasa = Env.ONE;
            if (inOut.getC_Order_ID() > 0) {
                MOrder order = new MOrder(inOut.getCtx(), inOut.getC_Order_ID(), inOut.get_TrxName());
                if (order.getC_Currency_ID() != 228) {
                    tasa = MConversionRate.getRate(order.getC_Currency_ID(), 228, inOut.getDateAcct(), order.getC_ConversionType_ID(), order.getAD_Client_ID(), order.getAD_Org_ID());
                }
                if (tasa == null) {
                    tasa = Env.ONE;
                }
                MInOutLine[] iLines2 = inOut.getLines();
                int a2 = 0;
                while (a2 < iLines2.length) {
                    priceT = Env.ZERO;
                    taxAmt = Env.ZERO;
                    taxIVAAmt = Env.ZERO;
                    MInOutLine iLine = iLines2[a2];
                    priceT = iLine.getC_OrderLine().getPriceEntered();
                    BigDecimal qtyO = iLine.getQtyEntered();
                    priceT = priceT.multiply(qtyO);
                    if (iLine.getC_OrderLine().getC_Tax_ID() > 0) {
                        if (iLine.getC_OrderLine().getC_Tax().getRate().compareTo(Env.ZERO) > 0) {
                            taxAmt = priceT.multiply(iLine.getC_OrderLine().getC_Tax().getRate());
                            taxAmt = taxAmt.divide(Env.ONEHUNDRED);
                        }
                        if (iLine.getC_OrderLine().getC_Tax().isTaxExempt()) {
                            taxExeAmtAcu = taxExeAmtAcu.add(priceT);
                        }
                        if (iLine.getC_OrderLine().getC_Tax().getName().toUpperCase().contains("IVA") && iLine.getC_OrderLine().getC_Tax().getRate().compareTo(new BigDecimal("19.0")) == 0) {
                            taxIVAAmt = priceT.multiply(iLine.getC_OrderLine().getC_Tax().getRate());
                            taxIVAAmt = taxIVAAmt.divide(Env.ONEHUNDRED);
                        }
                        taxNetoAmtAcu = taxNetoAmtAcu.add(priceT);
                    }
                    amountGrandT = amountGrandT.add(priceT.add(taxAmt));
                    taxIVAAmtAcu = taxIVAAmtAcu.add(taxIVAAmt);
                    ++a2;
                }
            }
            taxNetoAmtAcu = taxNetoAmtAcu.multiply(tasa);
            taxExeAmtAcu = taxExeAmtAcu.multiply(tasa);
            taxIVAAmtAcu = taxIVAAmtAcu.multiply(tasa);
            amountGrandT = amountGrandT.multiply(tasa);
            Element MntNeto = document.createElement("MntNeto");
            Text MntNetotxt = document.createTextNode(taxNetoAmtAcu.setScale(0, 4).toString());
            MntNeto.appendChild(MntNetotxt);
            Totales.appendChild(MntNeto);
            Element MntExe = document.createElement("MntExe");
            Text MntExeTxt = document.createTextNode(taxExeAmtAcu.setScale(0, 4).toString());
            MntExe.appendChild(MntExeTxt);
            Totales.appendChild(MntExe);
            Element TasaIVA = document.createElement("TasaIVA");
            Text tiva = document.createTextNode("19");
            TasaIVA.appendChild(tiva);
            Totales.appendChild(TasaIVA);
            Element MntIva = document.createElement("IVA");
            Text MntIvaTxt = document.createTextNode(taxIVAAmtAcu.setScale(0, 4).toString());
            MntIva.appendChild(MntIvaTxt);
            Totales.appendChild(MntIva);
            Element MntTotal = document.createElement("MntTotal");
            Text total = document.createTextNode(amountGrandT.setScale(0, 4).toString());
            MntTotal.appendChild(total);
            Totales.appendChild(MntTotal);
            mylog = "detalle";
            MInOutLine[] iLines = inOut.getLines();
            int indLine = 1;
            int i = 0;
            while (i < iLines.length) {
                MInOutLine iLine = iLines[i];
                if (iLine.getM_Product_ID() != 0 || iLine.getC_Charge_ID() != 0) {
                    Element Detalle = document.createElement("Detalle");
                    Documento.appendChild(Detalle);
                    Element NroLinDet = document.createElement("NroLinDet");
                    Text line = document.createTextNode(Integer.toString(indLine));
                    NroLinDet.appendChild(line);
                    Detalle.appendChild(NroLinDet);
                    Element NmbItem = document.createElement("NmbItem");
                    String pname = "";
                    pname = iLine.getProduct() != null ? iLine.getProduct().getName() : iLine.getC_Charge().getName();
                    pname = pname.replace("'", "");
                    pname = pname.replace("\"", "");
                    Text Item = document.createTextNode(pname);
                    NmbItem.appendChild(Item);
                    Detalle.appendChild(NmbItem);
                    Element QtyItem = document.createElement("QtyItem");
                    Text qt = document.createTextNode(iLine.getQtyEntered().toString());
                    QtyItem.appendChild(qt);
                    Detalle.appendChild(QtyItem);
                    Element UnmdItem = document.createElement("UnmdItem");
                    Text UItxt = document.createTextNode(iLine.getC_UOM().getUOMSymbol().trim().compareToIgnoreCase("Ea") == 0 ? "UN" : iLine.getC_UOM().getUOMSymbol());
                    UnmdItem.appendChild(UItxt);
                    Detalle.appendChild(UnmdItem);
                    BigDecimal mtoItem = Env.ZERO;
                    BigDecimal prcRefMnt = Env.ZERO;
                    if (iLine.getC_OrderLine_ID() > 0) {
                        prcRefMnt = iLine.getC_OrderLine().getPriceEntered();
                        mtoItem = prcRefMnt.multiply(iLine.getQtyEntered());
                    }
                    mtoItem = mtoItem.multiply(tasa);
                    prcRefMnt = prcRefMnt.multiply(tasa);
                    Element PrcRef = document.createElement("PrcItem");
                    Text PrcRefTxt = document.createTextNode(prcRefMnt.setScale(0, 4).toString());
                    PrcRef.appendChild(PrcRefTxt);
                    Detalle.appendChild(PrcRef);
                    Element MtoItem = document.createElement("MontoItem");
                    Text MtoTxt = document.createTextNode(mtoItem.setScale(0, 4).toString());
                    MtoItem.appendChild(MtoTxt);
                    Detalle.appendChild(MtoItem);
                    ++indLine;
                }
                ++i;
            }
            mylog = "referencia";
            String tiporeferencia = new String();
            String folioreferencia = new String();
            String fechareferencia = new String();
            int tipo_Ref = 0;
            if (inOut.getPOReference() != null && inOut.getPOReference().length() > 0) {
                mylog = "referencia:order";
                tiporeferencia = "801";
                folioreferencia = inOut.getPOReference();
                fechareferencia = inOut.getDateOrdered().toString().substring(0, 10);
                tipo_Ref = 2;
            }
            if (tipo_Ref > 0) {
                Element Referencia = document.createElement("Referencia");
                Documento.appendChild(Referencia);
                Element NroLinRef = document.createElement("NroLinRef");
                Text Nro = document.createTextNode("1");
                NroLinRef.appendChild(Nro);
                Referencia.appendChild(NroLinRef);
                Element TpoDocRef = document.createElement("TpoDocRef");
                Text tpo = document.createTextNode(tiporeferencia);
                TpoDocRef.appendChild(tpo);
                Referencia.appendChild(TpoDocRef);
                Element FolioRef = document.createElement("FolioRef");
                Text ref = document.createTextNode(folioreferencia);
                FolioRef.appendChild(ref);
                Referencia.appendChild(FolioRef);
                Element FchRef = document.createElement("FchRef");
                Text fchref = document.createTextNode(fechareferencia);
                FchRef.appendChild(fchref);
                Referencia.appendChild(FchRef);
                String CodRefTxt = null;
                try {
                    CodRefTxt = inOut.get_ValueAsString("CodRef");
                }
                catch (Exception e) {
                    CodRefTxt = null;
                }
                if (CodRefTxt != null && CodRefTxt.length() > 0) {
                    Element CodRef = document.createElement("CodRef");
                    Text codref = document.createTextNode(inOut.get_ValueAsString("CodRef") == null ? "0" : inOut.get_ValueAsString("CodRef"));
                    CodRef.appendChild(codref);
                    Referencia.appendChild(CodRef);
                }
            }
            if (inOut.getDescription() != null && inOut.getDescription() != "" && inOut.getDescription() != " ") {
                mylog = "Adicional";
                Element Adicional = document.createElement("Adicional");
                Documento.appendChild(Adicional);
                Element NodosA = document.createElement("NodosA");
                Adicional.appendChild(NodosA);
                Element A6 = document.createElement("A6");
                Text a6Text = document.createTextNode(inOut.getDescription());
                A6.appendChild(a6Text);
                NodosA.appendChild(A6);
            }
            mylog = "archivo";
            String ExportDir = (String)company.get_Value("ExportDir");
            ExportDir = ExportDir.replace("\\", "/");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(ExportDir, inOut.getDocumentNo() + ".xml"));
            StreamResult console = new StreamResult(System.out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(source, result);
            transformer.transform(source, console);
            File file = new File(ExportDir, inOut.getDocumentNo() + ".xml");
            Document docValid = builder.parse(file);
            Element raiz = docValid.getDocumentElement();
            raiz.setAttribute("version", "1.0");
            raiz.setAttribute("xmlns", "http://www.sii.cl/SiiDte");
            source = new DOMSource(docValid);
            result = new StreamResult(new File(ExportDir, inOut.getDocumentNo() + ".xml"));
            console = new StreamResult(System.out);
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(source, result);
            transformer.transform(source, console);
            byte[] fileArray = new byte[(int)file.length()];
            FileInputStream inputStream = new FileInputStream(file);
            ((InputStream)inputStream).read(fileArray);
            byte[] encoded = Base64.encodeBase64((byte[])fileArray);
            String encodedFile = "";
            try {
                encodedFile = new String(encoded);
            }
            catch (Exception MtoItem) {
                // empty catch block
            }
            String token = "";
            String rutEmpresa = "";
            String rutUsuario = "";
            String password = "";
            try {
                rutEmpresa = OFBForward.RutEmpresaFEL();
                rutUsuario = OFBForward.RutUsuarioFEL();
                password = OFBForward.ContrasenaFEL();
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
            String archivoXML = String.valueOf(ExportDir) + inOut.getDocumentNo() + ".xml";
            String tipoDocumento = Integer.toString(typeDoc);
            String folioDocumento = inOut.getDocumentNo();
            if (archivoXML != "" && rutEmpresa != "" && rutUsuario != "" && password != "") {
                token = this.llamarWSToken(rutEmpresa, rutUsuario, password);
                if (token.substring(0, 5).compareToIgnoreCase("error") == 0) {
                    return token;
                }
                wsRespuesta = this.llamarWSEnviarDTE(token, encodedFile, rutEmpresa, tipoDocumento, folioDocumento);
                this.log.config(wsRespuesta);
                if (this.urlPdf != null && this.urlPdf != "" && this.urlPdf != " ") {
                    this.urlPdf = String.valueOf(this.urlPdf) + "&Ced=2";
                    inOut.set_CustomColumn("URLXML", this.urlPdf);
                }
                inOut.set_CustomColumn("DescriptionFEL", wsRespuesta);
                inOut.save();
                if (this.urlPdf != null && this.urlPdf != "" && this.urlPdf != " ") {
                    this.PrintPDF(this.urlPdf);
                }
            }
        }
        catch (Exception e) {
            this.log.severe("CreateXML: " + mylog + "--" + e.getMessage());
            return "CreateXML: " + mylog + "--" + e.getMessage();
        }
        return "XML Shipment Generated";
    }

    private String llamarWSToken(String rutEmpresa, String rutPersona, String password) throws Exception {
        String token = "";
        String request = "<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:wst=\"/var/www//WsTest/\"> <soapenv:Header/><soapenv:Body><wst:SolicitarSesion soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><rutEmpresa xsi:type=\"xsd:string\">" + rutEmpresa + "</rutEmpresa>" + "<rutPersona xsi:type=\"xsd:string\">" + rutPersona + "</rutPersona>" + "<password xsi:type=\"xsd:string\">" + password + "</password>" + "</wst:SolicitarSesion>" + "</soapenv:Body>" + "</soapenv:Envelope>";
        Source response = null;
        try {
            CXFConnector wsc = new CXFConnector();
            wsc.setSoapAction("http://clientes.dtefacturaenlinea.cl/WsFEL/wsFEL.php/SolicitarSesion");
            wsc.setRequest(request);
            wsc.setBinding("http://schemas.xmlsoap.org/wsdl/soap/http");
            wsc.setEndpointAddress("http://clientes.dtefacturaenlinea.cl/WsFEL/wsFEL.php");
            wsc.setServiceName("DTElectronico");
            wsc.setPortName("DTElectronicoPort");
            wsc.setTargetNS("/var/www//WsTest/");
            wsc.executeConnector();
            response = wsc.getResponse();
        }
        catch (Exception e) {
            throw new Exception("No se ha podido establecer conexion con el Servicio de Facturacion");
        }
        try {
            DocumentBuilderFactory.newInstance().newDocumentBuilder();
            SAXSource output = (SAXSource)response;
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            DOMResult result = new DOMResult();
            tf.transform(output, result);
            Document doc = (Document)result.getNode();
            Node datos = this.findReturn(doc.getChildNodes().item(0));
            if (datos != null) {
                NodeList att = datos.getChildNodes();
                int x = 0;
                while (x < att.getLength()) {
                    this.log.config(att.item(x).getLocalName());
                    if (att.item(x).getLocalName().equals("return") || att.item(x).getNodeName().equals("return")) {
                        token = att.item(x).getFirstChild().getNodeValue();
                    }
                    ++x;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return token;
    }

    private String llamarWSEnviarDTE(String token, String dte, String rutEmpresa, String tipoDocumento, String folioDocumento) throws Exception {
        String msg = "";
        String EstadoDte = "";
        String GlosaEstadoDte = "";
        String request = "<soapenv:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:wst=\"/var/www//WsTest/\"><soapenv:Header/><soapenv:Body><wst:EnviarDTE soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><sesion xsi:type=\"xsd:string\">" + token + "</sesion>" + "<archivo xsi:type=\"xsd:string\">" + dte + "</archivo>" + "<rutEmpresa xsi:type=\"xsd:string\">" + rutEmpresa + "</rutEmpresa>" + "<tipoDocumento xsi:type=\"xsd:string\">" + tipoDocumento + "</tipoDocumento>" + "<folio xsi:type=\"xsd:string\">" + folioDocumento + "</folio>" + "</wst:EnviarDTE>" + "</soapenv:Body>" + "</soapenv:Envelope>";
        Source response = null;
        try {
            CXFConnector wsc = new CXFConnector();
            wsc.setSoapAction("http://clientes.dtefacturaenlinea.cl/WsFEL/wsFEL.php/EnviarDTE");
            wsc.setRequest(request);
            wsc.setBinding("http://schemas.xmlsoap.org/wsdl/soap/http");
            wsc.setEndpointAddress("http://clientes.dtefacturaenlinea.cl/WsFEL/wsFEL.php");
            wsc.setServiceName("DTElectronico");
            wsc.setPortName("DTElectronicoPort");
            wsc.setTargetNS("/var/www//WsTest/");
            wsc.executeConnector();
            response = wsc.getResponse();
        }
        catch (Exception e) {
            throw new Exception("No se ha podido establecer conexion con el Servicio de Facturacion - " + e);
        }
        try {
            DocumentBuilderFactory.newInstance().newDocumentBuilder();
            SAXSource output = (SAXSource)response;
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            DOMResult result = new DOMResult();
            tf.transform(output, result);
            Document doc = (Document)result.getNode();
            Node datos = this.findReturnEnviarDTE(doc.getChildNodes().item(0));
            if (datos != null) {
                NodeList att = datos.getChildNodes();
                int x = 0;
                while (x < att.getLength()) {
                    this.log.config(att.item(x).getLocalName());
                    if (att.item(x).getLocalName().equals("return") || att.item(x).getNodeName().equals("return")) {
                        msg = att.item(x).getFirstChild().getNodeValue();
                    }
                    ++x;
                }
            }
            EstadoDte = this.findText(msg, "<EstadoDTE>", "</EstadoDTE>");
            GlosaEstadoDte = this.findText(msg, "<GlosaEstadoDTE>", "</GlosaEstadoDTE>");
            this.urlPdf = this.findText(msg, "<PDF Url=\"", "\"/>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "Estado DTE: " + EstadoDte + " Glosa Estado: " + GlosaEstadoDte + " Url:" + this.urlPdf;
    }

    public Node findReturn(Node node) {
        Node value = null;
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node childNode = list.item(i);
            if (childNode.getNodeName().equals("ns1:SolicitarSesionResponse")) {
                value = childNode;
                break;
            }
            value = this.findReturn(childNode);
            ++i;
        }
        return value;
    }

    public Node findReturnEnviarDTE(Node node) {
        Node value = null;
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node childNode = list.item(i);
            if (childNode.getNodeName().equals("ns1:EnviarDTEResponse")) {
                value = childNode;
                break;
            }
            value = this.findReturnEnviarDTE(childNode);
            ++i;
        }
        return value;
    }

    public String findText(String cadena, String fragmentoIni, String fragmentoFin) {
        String newText = "";
        int indiceIni = 0;
        int indiceFin = 0;
        boolean flag = cadena.contains(fragmentoIni);
        if (flag) {
            indiceIni = cadena.indexOf(fragmentoIni);
            indiceFin = cadena.indexOf(fragmentoFin);
            newText = cadena.substring(indiceIni += fragmentoIni.length(), indiceFin);
        } else {
            newText = "Error - No existe Cadena Especificada";
        }
        return newText;
    }

    public String PrintPDF(String p_url) {
        block11: {
            SimpleDoc pdfDoc;
            DocPrintJob job;
            HashPrintRequestAttributeSet attributes;
            PrintService service;
            block10: {
                block9: {
                    try {
                        service = PrintServiceLookup.lookupDefaultPrintService();
                        if (service != null) {
                            DocFlavor.INPUT_STREAM psFormat = DocFlavor.INPUT_STREAM.AUTOSENSE;
                            HashPrintRequestAttributeSet attributes2 = new HashPrintRequestAttributeSet();
                            DocPrintJob job2 = service.createPrintJob();
                            SimpleDoc pdfDoc2 = new SimpleDoc(new URL(p_url).openStream(), psFormat, null);
                            job2.print(pdfDoc2, attributes2);
                            break block9;
                        }
                        return "No Print Service";
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                try {
                    service = PrintServiceLookup.lookupDefaultPrintService();
                    if (service != null) {
                        attributes = new HashPrintRequestAttributeSet();
                        job = service.createPrintJob();
                        pdfDoc = new SimpleDoc(new URL(p_url).openStream(), DocFlavor.URL.AUTOSENSE, null);
                        job.print(pdfDoc, attributes);
                        break block10;
                    }
                    return "No Print Service";
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            try {
                service = PrintServiceLookup.lookupDefaultPrintService();
                if (service != null) {
                    attributes = new HashPrintRequestAttributeSet();
                    job = service.createPrintJob();
                    pdfDoc = new SimpleDoc(new URL(p_url).openStream(), DocFlavor.BYTE_ARRAY.AUTOSENSE, null);
                    job.print(pdfDoc, attributes);
                    break block11;
                }
                return "No Print Service";
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return "Imprimiendo...";
    }
}

