/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCharge;
import org.compiere.model.MCity;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrg;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MProduct;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_M_InOut;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ExportDTEInvoiceCGProvectis
extends SvrProcess {
    private Properties m_ctx;
    private int p_C_Invoice_ID = 0;

    @Override
    protected void prepare() {
        this.p_C_Invoice_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    @Override
    protected String doIt() throws Exception {
        MInvoice inv = new MInvoice(this.m_ctx, this.p_C_Invoice_ID, this.get_TrxName());
        String msg = this.CreateXMLCG(inv);
        return msg;
    }

    public String CreateXMLCG(MInvoice invoice) {
        MDocType doc = new MDocType(invoice.getCtx(), invoice.getC_DocTypeTarget_ID(), invoice.get_TrxName());
        if (doc.get_Value("CreateXML") == null) {
            return "";
        }
        if (!((Boolean)doc.get_Value("CreateXML")).booleanValue()) {
            return "";
        }
        int typeDoc = Integer.parseInt((String)doc.get_Value("DocumentNo"));
        if (typeDoc == 0) {
            return "";
        }
        String mylog = new String();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            String CodRefTxt;
            PO refdoc;
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation implementation = builder.getDOMImplementation();
            Document document = implementation.createDocument(null, "DTE", null);
            document.setXmlVersion("1.0");
            Element Documento = document.createElement("Documento");
            document.getDocumentElement().appendChild(Documento);
            Documento.setAttribute("ID", "DTE-" + invoice.getDocumentNo());
            Element Encabezado = document.createElement("Encabezado");
            Documento.appendChild(Encabezado);
            Element IdDoc = document.createElement("IdDoc");
            Encabezado.appendChild(IdDoc);
            mylog = "IdDoc";
            Element TipoDTE = document.createElement("TipoDTE");
            Text text = document.createTextNode(Integer.toString(typeDoc));
            TipoDTE.appendChild(text);
            IdDoc.appendChild(TipoDTE);
            Element Folio = document.createElement("Folio");
            Text fo = document.createTextNode(invoice.getDocumentNo());
            Folio.appendChild(fo);
            IdDoc.appendChild(Folio);
            Element FchEmis = document.createElement("FchEmis");
            Text emis = document.createTextNode(invoice.getDateInvoiced().toString().substring(0, 10));
            FchEmis.appendChild(emis);
            IdDoc.appendChild(FchEmis);
            int cantdias = 0;
            Timestamp fchVencCal = invoice.getDateInvoiced();
            if (invoice.getC_PaymentTerm_ID() > 0) {
                MPaymentTerm tpago = new MPaymentTerm(invoice.getCtx(), invoice.getC_PaymentTerm_ID(), invoice.get_TrxName());
                cantdias = tpago.getNetDays();
            }
            if (cantdias > 0) {
                Calendar calFchVenc = Calendar.getInstance();
                calFchVenc.setTimeInMillis(invoice.getDateInvoiced().getTime());
                calFchVenc.add(5, cantdias);
                fchVencCal = new Timestamp(calFchVenc.getTimeInMillis());
            }
            Element FchVenc = document.createElement("FchVenc");
            Text venc = document.createTextNode(fchVencCal.toString().substring(0, 10));
            FchVenc.appendChild(venc);
            IdDoc.appendChild(FchVenc);
            Element Emisor = document.createElement("Emisor");
            Encabezado.appendChild(Emisor);
            mylog = "Emisor";
            MOrg company = MOrg.get(invoice.getCtx(), invoice.getAD_Org_ID());
            Element Rut = document.createElement("RUTEmisor");
            Text rut = document.createTextNode((String)company.get_Value("Rut"));
            Rut.appendChild(rut);
            Emisor.appendChild(Rut);
            String nameRzn = company.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = company.getName();
            }
            Element RznSoc = document.createElement("RznSoc");
            Text rzn = document.createTextNode(nameRzn);
            RznSoc.appendChild(rzn);
            Emisor.appendChild(RznSoc);
            Element GiroEmis = document.createElement("GiroEmis");
            Text gi = document.createTextNode((String)company.get_Value("Giro"));
            GiroEmis.appendChild(gi);
            Emisor.appendChild(GiroEmis);
            Element Acteco = document.createElement("Acteco");
            Text teco = document.createTextNode((String)company.get_Value("Acteco"));
            Acteco.appendChild(teco);
            Emisor.appendChild(Acteco);
            Element DirOrigen = document.createElement("DirOrigen");
            Text dir = document.createTextNode((String)company.get_Value("Address1"));
            DirOrigen.appendChild(dir);
            Emisor.appendChild(DirOrigen);
            Element CmnaOrigen = document.createElement("CmnaOrigen");
            Text com = document.createTextNode((String)company.get_Value("Comuna"));
            CmnaOrigen.appendChild(com);
            Emisor.appendChild(CmnaOrigen);
            Element CiudadOrigen = document.createElement("CiudadOrigen");
            Text city = document.createTextNode((String)company.get_Value("City"));
            CiudadOrigen.appendChild(city);
            Emisor.appendChild(CiudadOrigen);
            int id_salesRep = 0;
            String CdgVendedor = " ";
            MUser salesUser = null;
            if (invoice.get_ValueAsInt("SalesRepV_ID") > 0) {
                id_salesRep = invoice.get_ValueAsInt("SalesRepV_ID");
                salesUser = new MUser(invoice.getCtx(), id_salesRep, invoice.get_TrxName());
                CdgVendedor = salesUser.getName();
            } else {
                CdgVendedor = " ";
            }
            Element SalesRep = document.createElement("CdgVendedor");
            Text sales = document.createTextNode(CdgVendedor);
            SalesRep.appendChild(sales);
            IdDoc.appendChild(SalesRep);
            mylog = "receptor";
            MBPartner BP = new MBPartner(invoice.getCtx(), invoice.getC_BPartner_ID(), invoice.get_TrxName());
            MBPartnerLocation bloc = new MBPartnerLocation(invoice.getCtx(), invoice.getC_BPartner_Location_ID(), invoice.get_TrxName());
            Element Receptor = document.createElement("Receptor");
            Encabezado.appendChild(Receptor);
            Element RUTRecep = document.createElement("RUTRecep");
            Text rutc = document.createTextNode(BP.getValue() + "-" + BP.get_ValueAsString("Digito"));
            RUTRecep.appendChild(rutc);
            Receptor.appendChild(RUTRecep);
            Element RznSocRecep = document.createElement("RznSocRecep");
            Text RznSocR = document.createTextNode(BP.getName());
            RznSocRecep.appendChild(RznSocR);
            Receptor.appendChild(RznSocRecep);
            Element GiroRecep = document.createElement("GiroRecep");
            Text giro = document.createTextNode((String)BP.get_Value("Giro"));
            GiroRecep.appendChild(giro);
            Receptor.appendChild(GiroRecep);
            String StrContacto = " ";
            if (invoice.getAD_User_ID() > 0 && invoice.getAD_User().getName() != null) {
                StrContacto = invoice.getAD_User().getName();
                if (invoice.getAD_User().getPhone() != null) {
                    StrContacto = String.valueOf(StrContacto) + " - " + invoice.getAD_User().getPhone();
                }
            }
            Element ContactoRecep = document.createElement("Contacto");
            Text contacto = document.createTextNode(invoice.getAD_User_ID() > 0 ? StrContacto : " ");
            ContactoRecep.appendChild(contacto);
            Receptor.appendChild(ContactoRecep);
            Element DirRecep = document.createElement("DirRecep");
            Text dirr = document.createTextNode(bloc.getLocation(true).getAddress1());
            DirRecep.appendChild(dirr);
            Receptor.appendChild(DirRecep);
            Element CmnaRecep = document.createElement("CmnaRecep");
            Text Cmna = document.createTextNode(bloc.getLocation(true).getAddress3() == null ? " " : bloc.getLocation(true).getAddress3());
            CmnaRecep.appendChild(Cmna);
            Receptor.appendChild(CmnaRecep);
            Element CiudadRecep = document.createElement("CiudadRecep");
            Text reg = document.createTextNode(bloc.getLocation(true).getC_City_ID() > 0 ? MCity.get(invoice.getCtx(), bloc.getLocation(true).getC_City_ID()).getName() : "Santiago");
            CiudadRecep.appendChild(reg);
            Receptor.appendChild(CiudadRecep);
            mylog = "Totales";
            Element Totales = document.createElement("Totales");
            Encabezado.appendChild(Totales);
            BigDecimal amountex = DB.getSQLValueBD(this.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='Y' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID(), new Object[0]);
            BigDecimal amountNeto = DB.getSQLValueBD(this.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID(), new Object[0]);
            if (amountNeto != null && amountNeto.compareTo(Env.ZERO) > 0) {
                Element MntNeto = document.createElement("MntNeto");
                Text neto = document.createTextNode(amountNeto != null ? amountNeto.toString() : "0");
                MntNeto.appendChild(neto);
                Totales.appendChild(MntNeto);
            }
            if (amountex != null) {
                Element MntExe = document.createElement("MntExe");
                Text exe = document.createTextNode(amountex != null ? amountex.toString() : "0");
                MntExe.appendChild(exe);
                Totales.appendChild(MntExe);
            }
            if (amountNeto.signum() > 0) {
                Element TasaIVA = document.createElement("TasaIVA");
                Text tiva = document.createTextNode("19");
                TasaIVA.appendChild(tiva);
                Totales.appendChild(TasaIVA);
            }
            Element IVA = document.createElement("IVA");
            BigDecimal ivaamt = Env.ZERO;
            if (amountex.intValue() != invoice.getGrandTotal().intValue()) {
                ivaamt = invoice.getGrandTotal().subtract(invoice.getTotalLines()).setScale(0, 4);
            }
            Text iva = document.createTextNode(ivaamt.toString());
            IVA.appendChild(iva);
            Totales.appendChild(IVA);
            Element MntTotal = document.createElement("MntTotal");
            Text total = document.createTextNode(invoice.getGrandTotal().setScale(0, 4).toString());
            MntTotal.appendChild(total);
            Totales.appendChild(MntTotal);
            mylog = "detalle";
            String MySqlCG = "select M_PRODUCT_ID, C_CHARGE_ID, C_TAX_ID, DESCRIPTION, name, QTYENTERED, PRICELIST, QTYINVOICED, PRICEACTUAL, LINENETAMT, M_Product_Name_ID from RVOFB_DetailXML where c_invoice_id = ? ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(MySqlCG, invoice.get_TrxName());
                pstmt.setInt(1, invoice.get_ID());
                rs = pstmt.executeQuery();
                int lineInvoice = 0;
                while (rs.next()) {
                    MProduct produc = null;
                    MCharge charge = null;
                    ++lineInvoice;
                    if (rs.getInt("M_PRODUCT_ID") > 0) {
                        produc = new MProduct(invoice.getCtx(), rs.getInt("M_PRODUCT_ID"), invoice.get_TrxName());
                    }
                    if (rs.getInt("C_CHARGE_ID") > 0) {
                        charge = new MCharge(invoice.getCtx(), rs.getInt("C_CHARGE_ID"), invoice.get_TrxName());
                    }
                    if (rs.getInt("M_PRODUCT_ID") == 0 && rs.getInt("C_CHARGE_ID") == 0 && rs.getInt("M_Product_Name_ID") == 0) continue;
                    Element Detalle = document.createElement("Detalle");
                    Documento.appendChild(Detalle);
                    Element NroLinDet = document.createElement("NroLinDet");
                    Text line = document.createTextNode(Integer.toString(lineInvoice));
                    NroLinDet.appendChild(line);
                    Detalle.appendChild(NroLinDet);
                    if (rs.getInt("M_PRODUCT_ID") > 0) {
                        Element CodItem = document.createElement("CodItem");
                        String pcod = "";
                        pcod = rs.getInt("M_PRODUCT_ID") > 0 ? produc.getValue() : "0";
                        Text CItem = document.createTextNode(pcod);
                        CodItem.appendChild(CItem);
                        Detalle.appendChild(CodItem);
                    }
                    Element NmbItem = document.createElement("NmbItem");
                    String pname = "";
                    pname = rs.getInt("M_PRODUCT_ID") > 0 ? produc.getName() : (rs.getInt("C_CHARGE_ID") > 0 ? charge.getName() : (rs.getInt("M_Product_Name_ID") > 0 ? (rs.getString("NAME") == null ? " " : rs.getString("NAME")) : " "));
                    Text Item = document.createTextNode(pname);
                    NmbItem.appendChild(Item);
                    Detalle.appendChild(NmbItem);
                    Element QtyItem = document.createElement("QtyItem");
                    String qtD = " ";
                    qtD = Integer.toString(rs.getInt("QTYINVOICED"));
                    Text qt = document.createTextNode(qtD);
                    QtyItem.appendChild(qt);
                    Detalle.appendChild(QtyItem);
                    Element PrcItem = document.createElement("PrcItem");
                    String paD = " ";
                    paD = rs.getBigDecimal("PRICELIST").setScale(0, 4).toString();
                    Text pa = document.createTextNode(paD);
                    PrcItem.appendChild(pa);
                    Detalle.appendChild(PrcItem);
                    Element MontoItem = document.createElement("MontoItem");
                    Text tl = document.createTextNode(rs.getBigDecimal("LINENETAMT").setScale(0, 4).toString());
                    MontoItem.appendChild(tl);
                    Detalle.appendChild(MontoItem);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, MySqlCG, e);
            }
            mylog = "referencia";
            String tiporeferencia = new String();
            String folioreferencia = new String();
            String fechareferencia = new String();
            int tipo_Ref = 0;
            int nroref = 0;
            if (invoice.getPOReference() != null && invoice.getPOReference().length() > 0) {
                mylog = "referencia:order";
                tiporeferencia = "801";
                folioreferencia = invoice.getPOReference();
                fechareferencia = invoice.getDateOrdered().toString().substring(0, 10);
                tipo_Ref = 2;
            }
            if (invoice.get_Value("C_RefInOut_ID") != null && (Integer)invoice.get_Value("C_RefInOut_ID") > 0) {
                mylog = "referencia:despacho";
                refdoc = new MInOut(invoice.getCtx(), (int)((Integer)invoice.get_Value("C_RefInOut_ID")), invoice.get_TrxName());
                tiporeferencia = "52";
                folioreferencia = ((X_M_InOut)refdoc).getDocumentNo();
                fechareferencia = ((X_M_InOut)refdoc).getMovementDate().toString().substring(0, 10);
                tipo_Ref = 3;
            }
            if (invoice.get_Value("C_RefDoc_ID") != null && invoice.get_ValueAsInt("C_RefDoc_ID") > 0) {
                mylog = "referencia:invoice";
                refdoc = new MInvoice(invoice.getCtx(), (int)((Integer)invoice.get_Value("C_RefDoc_ID")), invoice.get_TrxName());
                MDocType Refdoctype = new MDocType(invoice.getCtx(), ((X_C_Invoice)refdoc).getC_DocType_ID(), invoice.get_TrxName());
                tiporeferencia = (String)Refdoctype.get_Value("DocumentNo");
                folioreferencia = ((X_C_Invoice)refdoc).getDocumentNo();
                fechareferencia = ((X_C_Invoice)refdoc).getDateInvoiced().toString().substring(0, 10);
                tipo_Ref = 1;
            }
            if (tipo_Ref > 0) {
                Element Referencia = document.createElement("Referencia");
                Documento.appendChild(Referencia);
                Element NroLinRef = document.createElement("NroLinRef");
                Text Nro = document.createTextNode(Integer.toString(++nroref));
                NroLinRef.appendChild(Nro);
                Referencia.appendChild(NroLinRef);
                Element TpoDocRef = document.createElement("TpoDocRef");
                Text tpo = document.createTextNode(tiporeferencia);
                TpoDocRef.appendChild(tpo);
                Referencia.appendChild(TpoDocRef);
                Element FolioRef = document.createElement("FolioRef");
                Text ref = document.createTextNode(folioreferencia);
                FolioRef.appendChild(ref);
                Referencia.appendChild(FolioRef);
                if (fechareferencia == null) {
                    fechareferencia = invoice.getDateInvoiced().toString().substring(0, 10);
                }
                if (fechareferencia.compareTo(" ") == 0 || fechareferencia.compareTo("") == 0) {
                    fechareferencia = invoice.getDateInvoiced().toString().substring(0, 10);
                }
                if (fechareferencia.length() < 2) {
                    fechareferencia = invoice.getDateInvoiced().toString().substring(0, 10);
                }
                Element FchRef = document.createElement("FchRef");
                Text fchref = document.createTextNode(fechareferencia);
                FchRef.appendChild(fchref);
                Referencia.appendChild(FchRef);
                CodRefTxt = null;
                try {
                    CodRefTxt = invoice.get_ValueAsString("CodRef");
                }
                catch (Exception e) {
                    CodRefTxt = null;
                }
                if (CodRefTxt != null && CodRefTxt.length() > 0) {
                    Element CodRef = document.createElement("CodRef");
                    Text codref = document.createTextNode(invoice.get_ValueAsString("CodRef") == null ? "0" : invoice.get_ValueAsString("CodRef"));
                    CodRef.appendChild(codref);
                    Referencia.appendChild(CodRef);
                }
            }
            if (invoice.get_ValueAsString("POReference2") != null && invoice.get_ValueAsString("POReference2").length() > 0) {
                ++nroref;
                mylog = "referencia:802";
                fechareferencia = invoice.getDateOrdered().toString().substring(0, 10);
                tipo_Ref = 4;
                Element Referencia2 = document.createElement("Referencia");
                Documento.appendChild(Referencia2);
                Element NroLinRef2 = document.createElement("NroLinRef");
                Text Nro2 = document.createTextNode(Integer.toString(++nroref));
                NroLinRef2.appendChild(Nro2);
                Referencia2.appendChild(NroLinRef2);
                Element TpoDocRef2 = document.createElement("TpoDocRef");
                Text tpo2 = document.createTextNode("802");
                TpoDocRef2.appendChild(tpo2);
                Referencia2.appendChild(TpoDocRef2);
                Element FolioRef2 = document.createElement("FolioRef");
                Text ref2 = document.createTextNode(invoice.get_ValueAsString("POReference2"));
                FolioRef2.appendChild(ref2);
                Referencia2.appendChild(FolioRef2);
                if (fechareferencia == null) {
                    fechareferencia = invoice.getDateInvoiced().toString().substring(0, 10);
                }
                if (fechareferencia.compareTo(" ") == 0 || fechareferencia.compareTo("") == 0) {
                    fechareferencia = invoice.getDateInvoiced().toString().substring(0, 10);
                }
                if (fechareferencia.length() < 2) {
                    fechareferencia = invoice.getDateInvoiced().toString().substring(0, 10);
                }
                Element FchRef2 = document.createElement("FchRef");
                Text fchref2 = document.createTextNode(fechareferencia);
                FchRef2.appendChild(fchref2);
                Referencia2.appendChild(FchRef2);
                CodRefTxt = null;
                try {
                    CodRefTxt = invoice.get_ValueAsString("CodRef");
                }
                catch (Exception e) {
                    CodRefTxt = null;
                }
                if (CodRefTxt != null && CodRefTxt.length() > 0) {
                    Element CodRef2 = document.createElement("CodRef");
                    Text codref2 = document.createTextNode(invoice.get_ValueAsString("CodRef") == null ? "0" : invoice.get_ValueAsString("CodRef"));
                    CodRef2.appendChild(codref2);
                    Referencia2.appendChild(CodRef2);
                }
            }
            Element Adjuntos = document.createElement("Adjuntos");
            Documento.appendChild(Adjuntos);
            Element HDescription = document.createElement("Observacion");
            Text Hdesc = document.createTextNode(invoice.getDescription() == null ? " " : invoice.getDescription());
            HDescription.appendChild(Hdesc);
            Adjuntos.appendChild(HDescription);
            Element DatoAdj4 = document.createElement("DatoAdj4");
            Text TextDatoAdj4 = document.createTextNode("Informacion adicional a incluir en el DOC");
            DatoAdj4.appendChild(TextDatoAdj4);
            Adjuntos.appendChild(DatoAdj4);
            Element DatoAdj5 = document.createElement("DatoAdj5");
            Text TextDatoAdj5 = document.createTextNode("Informacion adicional a incluir en el DOC");
            DatoAdj5.appendChild(TextDatoAdj5);
            Adjuntos.appendChild(DatoAdj5);
            Element DatoAdj6 = document.createElement("DatoAdj6");
            Text TextDatoAdj6 = document.createTextNode("Informacion adicional a incluir en el DOC");
            DatoAdj6.appendChild(TextDatoAdj6);
            Adjuntos.appendChild(DatoAdj6);
            Element copias = document.createElement("Copias");
            Text TextCopias = document.createTextNode("3");
            copias.appendChild(TextCopias);
            Adjuntos.appendChild(copias);
            mylog = "archivo";
            String ExportDir = (String)company.get_Value("ExportDir");
            ExportDir = ExportDir.replace("\\", "/");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(ExportDir, invoice.getDocumentNo() + ".xml"));
            StreamResult console = new StreamResult(System.out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(source, result);
            transformer.transform(source, console);
        }
        catch (Exception e) {
            this.log.severe("CreateXML: " + mylog + "--" + e.getMessage());
            return "CreateXML: " + mylog + "--" + e.getMessage();
        }
        return "XML CG PROVECTIS Generated";
    }
}

