/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_C_InvoiceLine;
import org.compiere.model.X_C_OrderLine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelOFBQDC
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFBQDC.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_OrderLine", this);
        engine.addModelChange("C_InvoiceLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        BigDecimal amtPL;
        String sqlV;
        int id_Prod;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == X_C_OrderLine.Table_ID) {
            MOrderLine ol = (MOrderLine)po;
            MOrder mo = new MOrder(po.getCtx(), ol.getC_Order_ID(), po.get_TrxName());
            id_Prod = 0;
            id_Prod = ol.getM_Product_ID();
            if (mo.isSOTrx() && id_Prod > 0) {
                sqlV = "SELECT MIN(mpp.priceLimit) FROM C_OrderLine col INNER JOIN C_Order co on (col.C_Order_ID = co.C_Order_ID) INNER JOIN M_PriceList mpl on (co.M_PriceList_ID = mpl.M_PriceList_ID) LEFT  JOIN M_PriceList_Version plv on (mpl.M_PriceList_ID = plv.M_PriceList_ID) LEFT JOIN M_ProductPrice mpp on (plv.M_PriceList_Version_ID = mpp.M_PriceList_Version_ID AND col.M_Product_ID = mpp.M_Product_ID) WHERE plv.IsActive = 'Y' AND plv.ValidFrom < ? AND C_OrderLine_ID = " + ol.get_ID();
                amtPL = DB.getSQLValueBD(po.get_TrxName(), sqlV, mo.getDateOrdered());
                if (amtPL.compareTo(Env.ZERO) > 0 && ol.getPriceEntered().compareTo(amtPL) < 0) {
                    return "Invalid Limit Price";
                }
            }
        }
        if ((type == 1 || type == 2) && po.get_Table_ID() == X_C_InvoiceLine.Table_ID) {
            MInvoiceLine il = (MInvoiceLine)po;
            MInvoice mi = new MInvoice(po.getCtx(), il.getC_Invoice_ID(), po.get_TrxName());
            id_Prod = 0;
            id_Prod = il.getM_Product_ID();
            if (mi.isSOTrx() && id_Prod > 0) {
                sqlV = "SELECT MIN(mpp.priceLimit) FROM C_InvoiceLine cil INNER JOIN C_invoice ci on (cil.C_Invoice_ID = ci.C_Invoice_ID) INNER JOIN M_PriceList mpl on (ci.M_PriceList_ID = mpl.M_PriceList_ID) LEFT  JOIN M_PriceList_Version plv on (mpl.M_PriceList_ID = plv.M_PriceList_ID) LEFT JOIN M_ProductPrice mpp on (plv.M_PriceList_Version_ID = mpp.M_PriceList_Version_ID AND cil.M_Product_ID = mpp.M_Product_ID) WHERE plv.IsActive = 'Y' AND plv.ValidFrom < ? AND C_InvoiceLine_ID = " + il.get_ID();
                amtPL = DB.getSQLValueBD(po.get_TrxName(), sqlV, mi.getDateInvoiced());
                if (amtPL.compareTo(Env.ZERO) > 0 && il.getPriceEntered().compareTo(amtPL) < 0) {
                    return "Invalid Limit Price";
                }
            }
        }
        return null;
    }

    public static String rtrim(String s, char c) {
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == c) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

