/*
 * Decompiled with CFR 0.152.
 */
package org.mutual.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModMutualValidInvoiceLine
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMutualValidInvoiceLine.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_InvoiceLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == MInvoiceLine.Table_ID) {
            BigDecimal qty;
            MInvoiceLine iLineBase;
            MInvoiceLine iLine = (MInvoiceLine)po;
            if (iLine.get_ValueAsInt("Ref_InvoiceLine_ID") > 0) {
                iLineBase = new MInvoiceLine(po.getCtx(), iLine.get_ValueAsInt("Ref_InvoiceLine_ID"), po.get_TrxName());
                qty = DB.getSQLValueBD(null, "SELECT SUM(QtyEntered) FROM C_InvoiceLine cil INNER JOIN C_Invoice ci ON (cil.C_Invoice_ID = ci.C_Invoice_ID) WHERE cil.Ref_InvoiceLine_ID = ? AND ci.DocStatus IN ('CO','DR','IP')", iLine.get_ValueAsInt("Ref_InvoiceLine_ID"));
                if (qty == null) {
                    qty = Env.ZERO;
                }
                if ((qty = qty.add(iLine.getQtyEntered())).compareTo(iLineBase.getQtyEntered()) > 0) {
                    return "Cantidad Usada Supera la Cantidad Original";
                }
            }
            if (iLine.get_ValueAsInt("Ref_InvoiceReqLine_ID") > 0) {
                iLineBase = new MInvoiceLine(po.getCtx(), iLine.get_ValueAsInt("Ref_InvoiceReqLine_ID"), po.get_TrxName());
                qty = DB.getSQLValueBD(null, "SELECT SUM(QtyEntered) FROM C_InvoiceLine WHERE Ref_InvoiceReqLine_ID = ?", iLine.get_ValueAsInt("Ref_InvoiceReqLine_ID"));
                if (qty == null) {
                    qty = Env.ZERO;
                }
                if ((qty = qty.add(iLine.getQtyEntered())).compareTo(iLineBase.getQtyEntered()) > 0) {
                    return "Cantidad Usada Supera la Cantidad Original";
                }
            }
            if (iLine.getQtyEntered().compareTo(Env.ZERO) == 0) {
                return "Cantidad No Puede Ser 0";
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

