/*
 * Decompiled with CFR 0.152.
 */
package org.metlife.process;

import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;

public class CXFConnector {
    private String targetNS;
    private String serviceName;
    private String portName;
    private String request;
    private String endpointAddress;
    private String binding;
    private String soapAction;
    private Source response;

    protected void executeConnector() throws Exception {
        QName serviceQName = new QName(this.targetNS, this.serviceName);
        QName portQName = new QName(this.targetNS, this.portName);
        Service service = Service.create((QName)serviceQName);
        service.addPort(portQName, this.binding, this.endpointAddress);
        Dispatch dispatch = service.createDispatch(portQName, Source.class, Service.Mode.MESSAGE);
        if (this.soapAction != null) {
            dispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.use", true);
            dispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.uri", this.soapAction);
        }
        this.response = (Source)dispatch.invoke((Object)new StreamSource(new StringReader(this.request)));
    }

    public Source getResponse() {
        return this.response;
    }

    public void setEndpointAddress(String endpointAddress) {
        this.endpointAddress = endpointAddress;
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    public void setTargetNS(String targetNS) {
        this.targetNS = targetNS;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }
}

