/*
 * Decompiled with CFR 0.152.
 */
package org.metlife.model;

import java.sql.CallableStatement;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_C_CampaignFollow;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModelOFBMetLifeSendMail
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFBMetLifeSendMail.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_CampaignFollow", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        X_C_CampaignFollow cFollow;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 4 || type == 5) && po.get_Table_ID() == X_C_CampaignFollow.Table_ID && (cFollow = (X_C_CampaignFollow)po).getAD_User_ID() > 0) {
            try {
                MUser user = new MUser(po.getCtx(), cFollow.getAD_User_ID(), po.get_TrxName());
                if (!user.getName().toUpperCase().contains("CLIENTE")) {
                    CallableStatement cst = DB.prepareCall("{call PA_LEADALLOCATION (?)}");
                    cst.setInt(1, cFollow.get_ID());
                    cst.execute();
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "No se pudo ejecutar proceso de correo", e);
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

