/*
 * Decompiled with CFR 0.152.
 */
package org.geminis.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBankAccount;
import org.compiere.model.MInvoice;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPayment;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.X_C_PaymentRequest;
import org.compiere.model.X_C_PaymentRequestLine;
import org.compiere.model.X_C_ProjectSchedule;
import org.compiere.model.X_DM_Document;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProcessPaymentRequest
extends SvrProcess {
    private int Record_ID;
    private String P_DocAction;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocAction")) {
                    this.P_DocAction = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.Record_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        MProject pj;
        X_C_PaymentRequest pr = new X_C_PaymentRequest(Env.getCtx(), this.Record_ID, this.get_TrxName());
        String requestType = pr.getRequestType();
        requestType = Character.toString(requestType.charAt(0));
        if (pr.getLines().length == 0 && !requestType.equals("R")) {
            return "No Lines";
        }
        if (pr.getDocStatus().equals("WC") && pr.getC_BankAccount_ID() <= 0) {
            return "Debe indicar una cuenta bancaria para generar el pago";
        }
        if (pr.getDocStatus().equals("CO") && this.P_DocAction.equals("VO")) {
            MPayment pay = new MPayment(Env.getCtx(), pr.getC_Payment_ID(), this.get_TrxName());
            if (pay.getDocStatus().equals("CO") || pay.getDocStatus().equals("IP")) {
                return "el pago relacionado con esta solicitud se encuentra compleado o procesado, no puede se puede anular";
            }
            pay.deleteEx(true, this.get_TrxName());
            pr.setC_Payment_ID(0);
            pr.setDocStatus("VO");
            pr.save();
            if (requestType.equals("R")) {
                MProject pj2 = new MProject(this.getCtx(), pr.get_ValueAsInt("C_Project_ID"), this.get_TrxName());
                pj2.setProjectBalanceAmt(pj2.getProjectBalanceAmt().subtract(pr.getPayAmt()));
                pj2.save();
                if (pr.get_ValueAsInt("C_ProjectSchedule_ID") > 0) {
                    DB.executeUpdate("update C_ProjectSchedule set isvalid='Y',C_PaymentRequest_ID=" + pr.getC_PaymentRequest_ID() + " where C_ProjectSchedule_ID=" + pr.get_ValueAsInt("C_ProjectSchedule_ID"), this.get_TrxName());
                }
            }
            return "Pago generado borrado y solicitud de pago anulada";
        }
        if (requestType.equals("R") && pr.getDocStatus().equals("DR") && (pj = new MProject(this.getCtx(), pr.get_ValueAsInt("C_Project_ID"), this.get_TrxName())).getCommittedAmt().compareTo(pj.getProjectBalanceAmt().add(pr.getPayAmt())) < 0) {
            return " esta solicitud de pago sobrepasara el monto asignado al proyecto :" + pj.getName();
        }
        if (pr.getDocStatus().equals("DR")) {
            int n;
            if (requestType.equals("P")) {
                String sqlcandet = "SELECT COUNT(*) FROM C_PaymentRequestLine WHERE (gl_journalline_id is null OR isactive = 'N') AND C_Paymentrequest_id = " + pr.get_ID();
                int cantDet = DB.getSQLValue(this.get_TrxName(), sqlcandet);
                if (cantDet > 0) {
                    return "Linea de Detalle no V\u00e1lida";
                }
            }
            boolean override = pr.get_ValueAsBoolean("Override");
            if (requestType.equals("I") && !override) {
                X_C_PaymentRequestLine[] lines;
                X_C_PaymentRequestLine[] x_C_PaymentRequestLineArray = lines = pr.getLines();
                int n2 = lines.length;
                n = 0;
                while (n < n2) {
                    MInvoice invo;
                    String sqlVal;
                    int cant;
                    X_C_PaymentRequestLine line = x_C_PaymentRequestLineArray[n];
                    if (line.getC_Invoice_ID() > 0 && (cant = DB.getSQLValue(null, sqlVal = "SELECT COUNT(*) FROM C_Payment cp WHERE cp.C_BPartner_ID = ? AND (SELECT COUNT(*) FROM C_AllocationLine cal WHERE cal.C_Payment_ID = cp.C_Payment_ID) < 1 AND cp.PayAmt = ? AND cp.IsReceipt = 'N' AND cp.DocStatus NOT IN ('VO')", (invo = new MInvoice(this.getCtx(), line.getC_Invoice_ID(), this.get_TrxName())).getC_BPartner_ID(), invo.getGrandTotal())) > 0) {
                        return "Existe un pago sin asignaciones para el mismo socio de negocio con el mismo monto que la factura " + invo.getDocumentNo();
                    }
                    ++n;
                }
            }
            pr.setDocStatus("WC");
            pr.setProcessed(true);
            pr.save();
            X_C_PaymentRequestLine[] x_C_PaymentRequestLineArray = pr.getLines();
            n = x_C_PaymentRequestLineArray.length;
            int line = 0;
            while (line < n) {
                X_C_PaymentRequestLine line2 = x_C_PaymentRequestLineArray[line];
                line2.setProcessed(true);
                line2.save();
                ++line;
            }
            this.commitEx();
            return "Solicitud Enviada";
        }
        if (pr.getDocStatus().equals("WC") && pr.isSignature1() && pr.isSignature2()) {
            if (requestType.equals("I") || requestType.equals("R") || requestType.equals("P") || requestType.equals("M")) {
                String com;
                MBankAccount bank;
                if (pr.getC_Payment_ID() > 0) {
                    this.log.log(Level.SEVERE, "Payment Already Generated");
                    return "Pago ya generado";
                }
                if (pr.getTenderType().equals("K") && (pr.getCheckNo() == null || pr.getCheckNo().length() == 0) && (bank = MBankAccount.get(this.getCtx(), pr.getC_BankAccount_ID())).get_ValueAsInt("CheckSequence") > 0) {
                    pr.setCheckNo(bank.get_ValueAsString("CheckSequence"));
                    bank.set_CustomColumn("CheckSequence", bank.get_ValueAsInt("CheckSequence") + 1);
                    bank.save();
                }
                MPayment pay = new MPayment(Env.getCtx(), 0, this.get_TrxName());
                pay.setIsReceipt(false);
                pay.setAD_Org_ID(pr.getAD_Org_ID());
                pay.setC_BPartner_ID(pr.getC_BPartner_ID());
                pay.setC_BankAccount_ID(pr.getC_BankAccount_ID());
                pay.setDateTrx(pr.getDateTrx());
                pay.setDateAcct(pr.getDateAcct());
                pay.setC_Currency_ID(pr.getC_Currency_ID());
                pay.setTenderType(pr.getTenderType());
                if (pr.getTenderType().equals("K")) {
                    pay.setCheckNo(pr.getCheckNo());
                }
                if (!requestType.equals("I")) {
                    pay.setC_Currency_ID(pr.getC_Currency_ID());
                }
                if (pr.getC_Charge_ID() > 0) {
                    pay.setC_Charge_ID(pr.getC_Charge_ID());
                }
                pay.setPayAmt(pr.getPayAmt());
                pay.set_CustomColumn("C_PaymentRequest_ID", pr.getC_PaymentRequest_ID());
                if (!pay.save()) {
                    this.log.log(Level.SEVERE, "Payment not save");
                    return "Payment not save ";
                }
                if (requestType.equals("M")) {
                    pay.set_CustomColumn("C_OrderPOImp_ID", pr.get_ValueAsInt("C_OrderPOImp_ID"));
                    pay.save();
                }
                this.log.config("Payment ID :" + pay.getC_Payment_ID());
                pr.setDocStatus("CO");
                pr.setC_Payment_ID(pay.getC_Payment_ID());
                pr.setProcessed(true);
                pr.save();
                this.log.config("pr saved");
                pr.setDocStatus("CO");
                if (requestType.equals("I") && pr.getLines().length > 0) {
                    X_C_PaymentRequestLine[] lines;
                    MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, pr.getDateTrx(), pr.getC_Currency_ID(), "Payment Request", this.get_TrxName());
                    alloc.setAD_Org_ID(pr.getAD_Org_ID());
                    if (!alloc.save()) {
                        this.log.log(Level.SEVERE, "Allocation not created");
                        return "Allocation not created";
                    }
                    X_C_PaymentRequestLine[] invo = lines = pr.getLines();
                    int n = lines.length;
                    int n3 = 0;
                    while (n3 < n) {
                        X_C_PaymentRequestLine line = invo[n3];
                        if (line.getC_Invoice_ID() > 0) {
                            MAllocationLine aLine = new MAllocationLine(alloc, line.getAmt().negate(), Env.ZERO, Env.ZERO, Env.ZERO);
                            aLine.setC_Invoice_ID(line.getC_Invoice_ID());
                            aLine.setC_Payment_ID(pay.getC_Payment_ID());
                            if (!aLine.save()) {
                                this.log.log(Level.SEVERE, "Allocation Line not written ");
                            }
                        }
                        ++n3;
                    }
                }
                if (requestType.equals("R")) {
                    MProject pj3 = new MProject(this.getCtx(), pr.get_ValueAsInt("C_Project_ID"), this.get_TrxName());
                    pj3.setProjectBalanceAmt(pj3.getProjectBalanceAmt().add(pr.getPayAmt()));
                    pj3.save();
                    String sql2 = "select max(dmd.c_projectline_id) from C_PaymentRequest cpr inner join C_ProjectSchedule cps on (cpr.C_ProjectSchedule_id = cps.C_ProjectSchedule_id) inner join DM_Document dmd on (dmd.DM_Document_ID = cps.DM_Document_id) where cpr.C_PaymentRequest_ID=?";
                    int cpl = DB.getSQLValue(this.get_TrxName(), sql2, pr.get_ID());
                    if (cpl < 1) {
                        return "No se puede generar el pago, la cuota debe tener un compromiso";
                    }
                    MProjectLine pjline = new MProjectLine(this.getCtx(), cpl, this.get_TrxName());
                    BigDecimal sum = (BigDecimal)pjline.get_Value("ProjectBalanceAmt");
                    sum = sum.add(pr.getPayAmt());
                    pjline.set_CustomColumn("ProjectBalanceAmt", sum);
                    pjline.save();
                    if (pr.get_ValueAsInt("C_ProjectSchedule_ID") > 0) {
                        DB.executeUpdate("update C_ProjectSchedule set isvalid='N',C_PaymentRequest_ID=" + pr.getC_PaymentRequest_ID() + " where C_ProjectSchedule_ID=" + pr.get_ValueAsInt("C_ProjectSchedule_ID"), this.get_TrxName());
                    }
                    X_C_ProjectSchedule ps = new X_C_ProjectSchedule(this.getCtx(), pr.get_ValueAsInt("C_ProjectSchedule_ID"), this.get_TrxName());
                    X_DM_Document dm = new X_DM_Document(this.getCtx(), ps.get_ValueAsInt("DM_Document_ID"), this.get_TrxName());
                    BigDecimal NAcumAnticipo = (BigDecimal)dm.get_Value("AcumAnticipo");
                    if (pr.get_ValueAsString("IsPrepayment").equals("true") || pr.get_ValueAsString("IsPrepayment").equals("Y")) {
                        NAcumAnticipo = NAcumAnticipo.add(pr.getPayAmt());
                        dm.set_CustomColumn("AcumAnticipo", NAcumAnticipo);
                    } else {
                        BigDecimal NAmtDate = (BigDecimal)dm.get_Value("AmtDate");
                        NAmtDate = NAmtDate.add(ps.getDueAmt());
                        dm.set_CustomColumn("AmtDate", NAmtDate);
                    }
                    String sqlER = "select abs(Coalesce(sum(pp.referenceamount), 0)) + abs(Coalesce(sum(pp.amt), 0)) from C_ProjectSchedule ps inner join PM_ProjectPay pp on (pp.C_ProjectSchedule_id = ps.C_ProjectSchedule_id) where ps.C_ProjectSchedule_id = ? and pay_type like 'ER'";
                    BigDecimal sumER = new BigDecimal("0.0");
                    sumER = DB.getSQLValueBD(this.get_TrxName(), sqlER, pr.get_ValueAsInt("C_ProjectSchedule_ID"));
                    BigDecimal NAcumDevR = (BigDecimal)dm.get_Value("AcumDevR");
                    NAcumDevR = NAcumDevR.add(sumER);
                    dm.set_CustomColumn("AcumDevR", NAcumDevR);
                    String sqlD1 = "select abs(Coalesce(sum(pp.referenceamount), 0)) + abs(Coalesce(sum(pp.amt), 0)) from C_ProjectSchedule ps inner join PM_ProjectPay pp on (pp.C_ProjectSchedule_id = ps.C_ProjectSchedule_id) where ps.C_ProjectSchedule_id = ? and pay_type like 'D1'";
                    BigDecimal sumD1 = new BigDecimal("0.0");
                    sumD1 = DB.getSQLValueBD(this.get_TrxName(), sqlD1, pr.get_ValueAsInt("C_ProjectSchedule_ID"));
                    BigDecimal NAcumMultas = (BigDecimal)dm.get_Value("AcumMultas");
                    NAcumMultas = NAcumMultas.add(sumD1);
                    dm.set_CustomColumn("AcumMultas", NAcumMultas);
                    String sqlR1 = "select abs(Coalesce(sum(pp.referenceamount), 0)) + abs(Coalesce(sum(pp.amt), 0)) from C_ProjectSchedule ps inner join PM_ProjectPay pp on (pp.C_ProjectSchedule_id = ps.C_ProjectSchedule_id) where ps.C_ProjectSchedule_id = ? and pay_type like 'R1'";
                    BigDecimal sumR1 = new BigDecimal("0.0");
                    sumR1 = DB.getSQLValueBD(this.get_TrxName(), sqlR1, pr.get_ValueAsInt("C_ProjectSchedule_ID"));
                    BigDecimal NAcumRetencion = (BigDecimal)dm.get_Value("AcumRetencion");
                    NAcumRetencion = NAcumRetencion.add(sumR1);
                    dm.set_CustomColumn("AcumRetencion", NAcumRetencion);
                    String sqlD2 = "select abs(Coalesce(sum(pp.referenceamount), 0)) + abs(Coalesce(sum(pp.amt), 0)) from C_ProjectSchedule ps inner join PM_ProjectPay pp on (pp.C_ProjectSchedule_id = ps.C_ProjectSchedule_id) where ps.C_ProjectSchedule_id = ? and pay_type like 'D2'";
                    BigDecimal sumD2 = new BigDecimal("0.0");
                    sumD2 = DB.getSQLValueBD(this.get_TrxName(), sqlD2, pr.get_ValueAsInt("C_ProjectSchedule_ID"));
                    BigDecimal NAcumDevA = (BigDecimal)dm.get_Value("AcumDevA");
                    NAcumDevA = NAcumDevA.add(sumD2);
                    dm.set_CustomColumn("AcumDevA", NAcumDevA);
                    dm.set_CustomColumn("AcumAnticipo", NAcumAnticipo);
                    dm.save();
                    String sqlUpdatePP = "update PM_ProjectPay set processed = 'Y' where C_ProjectSchedule_ID = " + ps.get_ID();
                    DB.executeUpdate(sqlUpdatePP, this.get_TrxName());
                    String sqlUpdatePS = "";
                    try {
                        sqlUpdatePS = "update C_ProjectSchedule set processed = 'Y' where C_ProjectSchedule_ID = " + ps.get_ID();
                        DB.executeUpdate(sqlUpdatePS, this.get_TrxName());
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sqlUpdatePS, e);
                    }
                }
                if ((com = pr.get_ValueAsString("PayComplete")).equals("Y") || com.equals(true) || com.equalsIgnoreCase("true")) {
                    pay.setDocStatus(pay.completeIt());
                    String IsCon = pr.get_ValueAsString("IsReconciled");
                    if (IsCon.equals("Y") || IsCon.equals(true) || IsCon.equalsIgnoreCase("true")) {
                        pay.setIsReconciled(true);
                    }
                    pay.save();
                }
                if (requestType.equals("P")) {
                    pay.setIsAllocated(true);
                    pay.save();
                }
                this.commitEx();
                return "Pago Generado :" + pay.getDocumentNo();
            }
            X_C_PaymentRequestLine[] lines = pr.getLines();
            int count = 0;
            X_C_PaymentRequestLine[] x_C_PaymentRequestLineArray = lines;
            int n = lines.length;
            int n4 = 0;
            while (n4 < n) {
                X_C_PaymentRequestLine line = x_C_PaymentRequestLineArray[n4];
                MJournalLine gline = new MJournalLine(this.getCtx(), line.getGL_JournalLine_ID(), this.get_TrxName());
                MPayment pay = new MPayment(Env.getCtx(), 0, this.get_TrxName());
                pay.setIsReceipt(false);
                pay.setAD_Org_ID(pr.getAD_Org_ID());
                pay.setC_BPartner_ID(gline.get_ValueAsInt("C_BPartner_ID"));
                pay.setC_BankAccount_ID(pr.getC_BankAccount_ID());
                pay.setDateTrx(pr.getDateTrx());
                pay.setDateAcct(pr.getDateAcct());
                pay.setC_Currency_ID(pr.getC_Currency_ID());
                pay.setTenderType(pr.getTenderType());
                pay.setDescription(gline.getDescription());
                if (pr.getTenderType().equals("K")) {
                    pay.setCheckNo(pr.getCheckNo());
                }
                if (!requestType.equals("I")) {
                    pay.setC_Currency_ID(pr.getC_Currency_ID());
                }
                if (pr.getC_Charge_ID() > 0) {
                    pay.setC_Charge_ID(pr.getC_Charge_ID());
                }
                pay.setPayAmt(line.getAmt());
                pay.set_CustomColumn("C_PaymentRequest_ID", pr.getC_PaymentRequest_ID());
                pay.save();
                ++count;
                line.set_ValueOfColumn("C_Payment_ID", (Object)pay.getC_Payment_ID());
                line.save();
                String com = pr.get_ValueAsString("PayComplete");
                if (com.equals("Y") || com.equals(true) || com.equalsIgnoreCase("true")) {
                    pay.setDocStatus(pay.completeIt());
                    String IsCon = pr.get_ValueAsString("IsReconciled");
                    if (IsCon.equals("Y") || IsCon.equals(true) || IsCon.equalsIgnoreCase("true")) {
                        pay.setIsReconciled(true);
                    }
                    pay.save();
                }
                ++n4;
            }
            pr.setDocStatus("CO");
            pr.setProcessed(true);
            pr.save();
            return "Pagos Generados :" + count;
        }
        if (!(!pr.getDocStatus().equals("WC") || pr.isSignature1() && pr.isSignature2())) {
            return "La solicitud necesita ser aprobada para generar el pago";
        }
        return "Ninguna Accion Realizada";
    }
}

