/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MInterestArea;
import org.compiere.model.MMailText;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MUser;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Trx;

public class PayrollViaEMail
extends SvrProcess {
    private int m_R_MailText_ID = -1;
    private MMailText m_MailText = null;
    private int m_AD_User_ID = -1;
    private MClient m_client = null;
    private MUser m_from = null;
    private ArrayList<Integer> m_list = new ArrayList();
    private int m_counter = 0;
    private int m_errors = 0;
    private int m_HR_Process_ID = -1;
    private MInterestArea m_ia = null;
    private int m_C_BP_Group_ID = -1;
    private int m_AD_Process_ID = -1;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) {
                this.log.fine("Null paramater: " + name);
            } else if (name.equals("HR_Process_ID")) {
                this.m_HR_Process_ID = para[i].getParameterAsInt();
            } else if (name.equals("R_MailText_ID")) {
                this.m_R_MailText_ID = para[i].getParameterAsInt();
            } else if (name.equals("C_BP_Group_ID")) {
                this.m_C_BP_Group_ID = para[i].getParameterAsInt();
            } else if (name.equals("AD_User_ID")) {
                this.m_AD_User_ID = para[i].getParameterAsInt();
            } else if (name.equals("AD_Process_ID")) {
                this.m_AD_Process_ID = para[i].getParameterAsInt();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("R_MailText_ID=" + this.m_R_MailText_ID);
        this.m_MailText = new MMailText(this.getCtx(), this.m_R_MailText_ID, this.get_TrxName());
        if (this.m_MailText.getR_MailText_ID() == 0) {
            throw new Exception("Not found @R_MailText_ID@=" + this.m_R_MailText_ID);
        }
        this.m_client = MClient.get(this.getCtx());
        if (this.m_client.getAD_Client_ID() == 0) {
            throw new Exception("Not found @AD_Client_ID@");
        }
        if (this.m_client.getSMTPHost() == null || this.m_client.getSMTPHost().length() == 0) {
            throw new Exception("No SMTP Host found");
        }
        long start = System.currentTimeMillis();
        this.m_from = new MUser(this.getCtx(), Env.getAD_User_ID(this.getCtx()), this.get_TrxName());
        if (this.m_from.getAD_User_ID() == 0) {
            throw new Exception("No found @AD_User_ID@=" + this.m_AD_User_ID);
        }
        if (this.m_AD_User_ID > 0) {
            MUser tmpUser = new MUser(this.getCtx(), this.m_AD_User_ID, this.get_TrxName());
            this.sendIndividualMail(this.m_from.getName(), tmpUser.getC_BPartner_ID(), null);
        } else {
            this.sendBPGroup();
        }
        this.log.fine("From " + this.m_from);
        return "@Created@=" + this.m_counter + ", @Errors@=" + this.m_errors + " - " + (System.currentTimeMillis() - start) + "ms";
    }

    private void sendBPGroup() {
        this.log.info("C_BP_Group_ID=" + this.m_C_BP_Group_ID);
        String sql = " SELECT bp.Name, bp.url, bp.c_bpartner_id FROM C_BPartner bp WHERE bp.IsActive='Y' AND bp.url IS NOT NULL";
        if (this.m_C_BP_Group_ID > 0) {
            sql = String.valueOf(sql) + " AND bp.C_BP_Group_ID=?";
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            if (this.m_C_BP_Group_ID > 0) {
                pstmt.setInt(1, this.m_C_BP_Group_ID);
            }
            ResultSet rsMail = pstmt.executeQuery();
            ArrayList<Integer> tabla = new ArrayList<Integer>();
            while (rsMail.next()) {
                tabla.add(new Integer(rsMail.getInt(3)));
            }
            int i = 0;
            while (i < tabla.size()) {
                Boolean ok = this.sendIndividualMail("", (Integer)tabla.get(i), null);
                if (ok != null) {
                    if (ok.booleanValue()) {
                        ++this.m_counter;
                    } else {
                        ++this.m_errors;
                    }
                }
                ++i;
            }
            rsMail.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sql, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            this.log.log(Level.SEVERE, sql, ex1);
        }
        pstmt = null;
    }

    private Boolean sendIndividualMail(String Name2, int C_BPartner_ID, String unsubscribe) {
        Integer ii;
        block9: {
            try {
                ii = new Integer(C_BPartner_ID);
                if (!this.m_list.contains(ii)) break block9;
                return null;
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        this.m_list.add(ii);
        MBPartner to = new MBPartner(this.getCtx(), C_BPartner_ID, null);
        String message = this.m_MailText.getMailText(true);
        if (unsubscribe != null) {
            message = String.valueOf(message) + unsubscribe;
        }
        EMail email = this.m_client.createEMail(this.m_from, to.getURL(), this.m_MailText.getMailHeader(), message);
        if (this.m_MailText.isHtml()) {
            email.setMessageHTML(this.m_MailText.getMailHeader(), message);
        } else {
            email.setSubject(this.m_MailText.getMailHeader());
            email.setMessageText(message);
        }
        email.addAttachment(this.CreatePDF(C_BPartner_ID));
        if (!email.isValid() && !email.isValid(true)) {
            this.log.warning("NOT VALID - " + email);
            to.setIsActive(false);
            to.save();
            return Boolean.FALSE;
        }
        boolean OK = "OK".equals(email.send());
        if (OK) {
            this.log.fine(to.getURL());
        } else {
            this.log.warning("FAILURE - " + to.getURL());
        }
        this.addLog(0, null, null, String.valueOf(OK ? "@OK@" : "@ERROR@") + " - " + to.getURL());
        return OK;
    }

    private File CreatePDF(int BPartner_ID) {
        File attachment = null;
        int AD_Process_ID = this.m_AD_Process_ID;
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0);
        if (!instance.save()) {
            return null;
        }
        ProcessInfo pi = new ProcessInfo("PH_SendEmail", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara ip = new MPInstancePara(instance, 10);
        pi.setRecord_ID(this.m_HR_Process_ID);
        pi.setIsBatch(true);
        MProcess worker = new MProcess(this.getCtx(), AD_Process_ID, this.get_TrxName());
        worker.processIt(pi, Trx.get(this.get_TrxName(), true));
        attachment = pi.getPDFReport();
        return attachment;
    }
}

