/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHRProcess;
import org.eevolution.model.X_HR_PayrollConcept;

public class MHRPayrollConcept
extends X_HR_PayrollConcept {
    private static final long serialVersionUID = -4335196239535511224L;

    public MHRPayrollConcept(Properties ctx, int HR_Concept_ID, String trxName) {
        super(ctx, HR_Concept_ID, trxName);
    }

    public MHRPayrollConcept(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MHRPayrollConcept(MHRConcept concept, int payroll_id, String trxName) {
        super(concept.getCtx(), 0, trxName);
        this.setHR_Payroll_ID(payroll_id);
        this.setHR_Concept_ID(concept.get_ID());
        this.setName(concept.getName());
        this.setSeqNo(concept.getSeqNo());
        this.setIsActive(true);
    }

    public static MHRPayrollConcept[] getPayrollConcepts(MHRProcess p2) {
        List<MHRPayrollConcept> list = new Query(p2.getCtx(), "HR_PayrollConcept", "HR_Payroll_ID=?", null).setOnlyActiveRecords(true).setParameters(p2.getHR_Payroll_ID()).setOrderBy("SeqNo").list();
        return list.toArray(new MHRPayrollConcept[list.size()]);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getSeqNo() == 0) {
            String sql = "SELECT COALESCE(MAX(SeqNo),0) FROM HR_PayrollConcept WHERE HR_Payroll_ID=?";
            int lastSeqNo = DB.getSQLValueEx(this.get_TrxName(), sql, this.getHR_Payroll_ID());
            if (lastSeqNo < 0) {
                lastSeqNo = 0;
            }
            this.setSeqNo(lastSeqNo + 10);
        }
        return true;
    }
}

