/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form.bom.action;

import java.math.BigDecimal;
import java.util.Calendar;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.compiere.model.MResource;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQLineQty;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.form.action.ProcessPopupAction;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.reasoner.StorageReasoner;
import org.eevolution.model.wrapper.BOMLineWrapper;
import org.eevolution.model.wrapper.BOMWrapper;

public class CreateRfQAction
extends ProcessPopupAction {
    public static final String COMMAND = "createRfQ";
    public static final int PROCESS_ID = 1000100;
    protected JTree tree;
    protected StorageReasoner reasoner;

    public CreateRfQAction(JTree tree, JFrame window) {
        super(COMMAND, window);
        this.setActionCommand(COMMAND);
        this.tree = tree;
        this.reasoner = new StorageReasoner();
    }

    @Override
    protected String getCommand() {
        return COMMAND;
    }

    @Override
    protected int getProcessID() {
        return 1000100;
    }

    @Override
    protected String validateAction() {
        return null;
    }

    @Override
    protected void doProcess() {
        if (this.tree != null) {
            this.createRfQ((DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent());
        }
    }

    private void createRfQ(DefaultMutableTreeNode node) {
        BOMWrapper bom = (BOMWrapper)node.getUserObject();
        MPPOrder mo = new MPPOrder(Env.getCtx(), bom.getPP_Order_ID(), null);
        MResource r = MResource.get(Env.getCtx(), mo.getS_Resource_ID());
        Calendar cal = Calendar.getInstance();
        MRfQ rfq = new MRfQ(Env.getCtx(), 0, null);
        rfq.setName(String.valueOf(Msg.translate(Env.getCtx(), "C_RFQ_ID")) + ": " + mo.getDocumentNo() + "_" + r.getName() + " (" + bom.getName() + ")");
        rfq.setC_Currency_ID(Env.getContextAsInt(Env.getCtx(), "$C_Currency_ID"));
        rfq.setQuoteType("S");
        rfq.setDateWorkStart(mo.getDateStartSchedule());
        rfq.setDateWorkComplete(mo.getDateFinishSchedule());
        rfq.setC_RfQ_Topic_ID(((BigDecimal)this.getParameterValue("C_RFQ_Topic_ID")).intValue());
        rfq.setSalesRep_ID(((BigDecimal)this.getParameterValue("SalesRep_ID")).intValue());
        this.savePO(rfq);
        if (this.successful()) {
            this.createRfQLines(rfq.get_ID(), node);
        }
    }

    private void createRfQLines(int rfqId, DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode node = null;
        int i = 0;
        while (i < parent.getChildCount()) {
            node = (DefaultMutableTreeNode)parent.getChildAt(i);
            if (node.isLeaf()) {
                this.createRfQLine(rfqId, node);
            } else {
                this.createRfQLines(rfqId, node);
            }
            if (!this.successful()) break;
            ++i;
        }
    }

    private void createRfQLine(int rfqId, DefaultMutableTreeNode node) {
        BOMLineWrapper sourceLine = (BOMLineWrapper)node.getUserObject();
        BigDecimal qtyReq = this.reasoner.getSumQtyRequired(sourceLine);
        if (qtyReq.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        MRfQ rfq = new MRfQ(Env.getCtx(), rfqId, null);
        MRfQLine targetLine = new MRfQLine(Env.getCtx(), 0, null);
        targetLine.setC_RfQ_ID(rfqId);
        targetLine.setLine(this.lineCount(rfqId) + 1);
        targetLine.setM_AttributeSetInstance_ID(sourceLine.getM_AttributeSetInstance_ID());
        targetLine.setM_Product_ID(sourceLine.getM_Product_ID());
        targetLine.setDateWorkStart(rfq.getDateWorkStart());
        targetLine.setDateWorkComplete(rfq.getDateWorkComplete());
        this.savePO(targetLine);
        if (!this.successful()) {
            return;
        }
        MRfQLineQty lineQty = new MRfQLineQty(Env.getCtx(), 0, null);
        lineQty.setQty(qtyReq);
        lineQty.setC_UOM_ID(sourceLine.getC_UOM_ID());
        lineQty.setC_RfQLine_ID(targetLine.get_ID());
        lineQty.setIsRfQQty(true);
        lineQty.setIsPurchaseQty(true);
        this.savePO(lineQty);
    }

    private int lineCount(int rfqId) {
        MRfQ rfq = new MRfQ(Env.getCtx(), rfqId, null);
        return rfq.getLines().length;
    }
}

