/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.compiere.apps.form.FormFrame;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MProduct;
import org.compiere.model.PO;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.form.CAbstractForm;
import org.eevolution.form.action.PopupAction;
import org.eevolution.form.action.ZoomMenuAction;
import org.eevolution.form.bom.BOMTreeFactory;
import org.eevolution.form.bom.BOMTreeModel;
import org.eevolution.form.bom.action.ChangeASIAction;
import org.eevolution.form.bom.action.CreateRfQAction;
import org.eevolution.form.bom.action.DeleteBOMAction;
import org.eevolution.form.bom.action.MergeBOMAction;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.reasoner.StorageReasoner;
import org.eevolution.model.wrapper.BOMLineWrapper;
import org.eevolution.model.wrapper.BOMWrapper;
import org.eevolution.tools.swing.SwingTool;
import org.eevolution.tools.worker.SingleWorker;

public abstract class CAbstractBOMTree
extends CAbstractForm
implements PropertyChangeListener {
    private SingleWorker worker;
    private BOMTreeModel model;
    private CPanel northPanel;
    private VLookup lookup;
    private JSplitPane contentPane;
    private CPanel southPanel;
    private JEditorPane nodeDescription;
    protected JPopupMenu popupRoot;
    protected JPopupMenu popupBOM;
    protected JPopupMenu popupBOMLine;
    protected StorageReasoner reasoner;

    private void handleTreeEvent(MouseEvent e) {
        String text = this.model.getBOMMessenger().getToolTipText(e);
        if (text != null) {
            this.nodeDescription.setText(text);
        }
        if (e.getButton() == 3) {
            this.model.getTree().setSelectionPath(this.model.getTree().getPathForLocation(e.getX(), e.getY()));
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.model.getTree().getSelectionPath().getLastPathComponent();
            if (node.getUserObject() instanceof BOMLineWrapper) {
                this.popupBOMLine.show(e.getComponent(), e.getX(), e.getY());
            } else if (node.getUserObject() instanceof BOMWrapper) {
                this.popupBOM.show(e.getComponent(), e.getX(), e.getY());
            } else if (node.getUserObject() instanceof MProduct) {
                this.popupRoot.show(e.getComponent(), e.getX(), e.getY());
            } else if (node.getUserObject() instanceof MPPOrder) {
                this.popupRoot.show(e.getComponent(), e.getX(), e.getY());
            }
        }
        SwingTool.setCursorsFromChild(e.getComponent(), false);
    }

    protected abstract String type();

    protected String idColumn() {
        return String.valueOf(this.type()) + "_ID";
    }

    @Override
    public void init(int WindowNo, FormFrame frame) {
        super.init(WindowNo, frame);
        this.reasoner = new StorageReasoner();
        try {
            this.preInit();
            this.jbInit();
            this.getWindow().getContentPane().add((Component)this, "Center");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void preInit() {
        this.northPanel = new CPanel();
        this.southPanel = new CPanel();
        this.contentPane = new JSplitPane(1);
        this.nodeDescription = new JEditorPane("text/html", "");
        this.nodeDescription.setOpaque(false);
        this.nodeDescription.setEditable(false);
        String columnName = null;
        int columnId = -1;
        if ("productBOM".equals(this.type())) {
            columnName = "M_Product_ID";
            columnId = MColumn.getColumn_ID("M_Product", columnName);
        } else if ("orderBOM".equals(this.type())) {
            columnName = "PP_Order_ID";
            columnId = MColumn.getColumn_ID("PP_Order", columnName);
        }
        MLookup lm = MLookupFactory.get(Env.getCtx(), this.getWindowNo(), 0, columnId, 30);
        this.lookup = new VLookup(columnName, false, false, true, lm){

            @Override
            public void setValue(Object obj) {
                super.setValue(obj);
                CAbstractBOMTree.this.dispatchPropertyChange();
            }
        };
    }

    private void jbInit() {
        CLabel label = null;
        if ("productBOM".equals(this.type())) {
            label = new CLabel(Msg.translate(Env.getCtx(), "M_Product_ID"));
        } else if ("orderBOM".equals(this.type())) {
            label = new CLabel(Msg.translate(Env.getCtx(), "PP_Order_ID"));
        }
        label.setLabelFor(this.lookup);
        this.northPanel.setLayout(new FlowLayout(0));
        this.northPanel.add((Component)label, null);
        this.northPanel.add((Component)this.lookup, null);
        this.southPanel.setLayout(new BorderLayout());
        JScrollPane sp = new JScrollPane(this.nodeDescription);
        sp.setBorder(null);
        this.contentPane.add((Component)sp, "right");
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(1000, 600));
        this.add((Component)this.northPanel, "North");
        this.add((Component)this.contentPane, "Center");
        this.add((Component)this.southPanel, "South");
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.worker != null) {
            this.worker.stop();
        }
        this.worker = null;
        if (this.lookup != null) {
            this.lookup.dispose();
        }
        this.lookup = null;
        this.northPanel = null;
        this.contentPane = null;
        this.southPanel = null;
        this.nodeDescription = null;
        this.popupRoot = null;
        this.popupBOM = null;
        this.popupBOMLine = null;
        this.reasoner = null;
    }

    private void handleActionEvent() {
        Integer value = (Integer)this.lookup.getValue();
        if (value == null || value == 0) {
            return;
        }
        this.nodeDescription.setText("");
        int poID = value;
        PO po = null;
        if ("productBOM".equals(this.type())) {
            po = new MProduct(Env.getCtx(), poID, "M_Product");
        } else if ("orderBOM".equals(this.type())) {
            po = new MPPOrder(Env.getCtx(), poID, null);
        }
        this.model = BOMTreeFactory.get(this.type(), po, this.reasoner);
        this.configureTree();
        this.contentPane.add((Component)new JScrollPane(this.model.getTree()), "left");
        this.contentPane.setDividerLocation(0.25);
    }

    protected void configureTree() {
        this.model.getTree().addPropertyChangeListener(this);
        TreeHandler th2 = new TreeHandler();
        this.model.getTree().addMouseMotionListener(th2);
        this.model.getTree().addMouseListener(th2);
        this.model.getTree().addKeyListener(th2);
        this.model.getTree().addTreeSelectionListener(th2);
        this.popupRoot = new JPopupMenu();
        this.popupBOM = new JPopupMenu();
        this.popupBOMLine = new JPopupMenu();
        try {
            this.configurePopup(this.popupRoot, this.model.getTree(), MProduct.class);
            this.configurePopup(this.popupBOM, this.model.getTree(), BOMWrapper.class);
            this.configurePopup(this.popupBOMLine, this.model.getTree(), BOMLineWrapper.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void configurePopup(JPopupMenu popup, JTree tree, Class clazz) throws Exception {
        PopupAction action = null;
        if (MPPOrder.class.equals((Object)clazz) || MProduct.class.equals((Object)clazz)) {
            action = new ZoomMenuAction(tree);
            popup.add(action);
        } else if (BOMWrapper.class.equals((Object)clazz)) {
            if ("productBOM".equals(this.type())) {
                action = new ZoomMenuAction(tree);
                popup.add(action);
                action = new MergeBOMAction(tree);
                action.addPropertyChangeListener(this);
                popup.add(action);
                action = new DeleteBOMAction(tree);
                action.addPropertyChangeListener(this);
                popup.add(action);
            }
            if ("orderBOM".equals(this.type())) {
                action = new CreateRfQAction(tree, (JFrame)this.getWindow());
                action.addPropertyChangeListener(this);
                popup.add(action);
            }
        } else if (BOMLineWrapper.class.equals((Object)clazz)) {
            if ("productBOM".equals(this.type())) {
                action = new DeleteBOMAction(tree);
                action.addPropertyChangeListener(this);
                popup.add(action);
            }
            action = new ChangeASIAction(tree, (JFrame)this.getWindow());
            action.addPropertyChangeListener(this);
            popup.add(action);
        }
    }

    protected void dispatchPropertyChange() {
        PropertyChangeEvent evt = new PropertyChangeEvent(this.lookup, "changeASI", null, null);
        this.propertyChange(evt);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("mergeBOM".equals(e.getPropertyName()) || "changeASI".equals(e.getPropertyName()) || "deleteBOM".equals(e.getPropertyName())) {
            SwingTool.setCursorsFromParent(this.getWindow(), true);
            SingleWorker worker = new SingleWorker(){

                @Override
                protected Object doIt() {
                    CAbstractBOMTree.this.handleActionEvent();
                    SwingTool.setCursorsFromParent(CAbstractBOMTree.this.getWindow(), false);
                    return null;
                }
            };
            this.runWorker(worker);
        }
    }

    protected void runWorker(SingleWorker worker) {
        this.worker = worker;
        this.worker.start();
    }

    class TreeHandler
    extends MouseInputAdapter
    implements TreeSelectionListener,
    KeyListener {
        TreeHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (CAbstractBOMTree.this.model.getTree().getPathForLocation(e.getX(), e.getY()) == null) {
                return;
            }
            SwingTool.setCursorsFromChild(e.getComponent(), true);
            final MouseEvent evt = e;
            CAbstractBOMTree.this.worker = new SingleWorker(){

                @Override
                protected Object doIt() {
                    CAbstractBOMTree.this.handleTreeEvent(evt);
                    return null;
                }
            };
            CAbstractBOMTree.this.worker.start();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 38 || e.getKeyCode() == 40) {
                TreePath path = CAbstractBOMTree.this.model.getTree().getSelectionModel().getSelectionPath();
                String text = CAbstractBOMTree.this.model.getBOMMessenger().getToolTipText(path);
                if (text != null) {
                    CAbstractBOMTree.this.nodeDescription.setText(text);
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
        }
    }
}

