/*
 * Decompiled with CFR 0.152.
 */
package org.dpp.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MWarehouse;
import org.compiere.model.X_T_Replenish;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ReplenishInterface;

public class GenerateReplenishDPP
extends SvrProcess {
    private int p_M_Warehouse_ID = 0;
    private int p_C_BPartner_ID = 0;
    private String p_ReplenishmentCreate = null;
    private int p_C_DocType_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        int M_Requisition_ID = this.getRecord_ID();
        MRequisition req = new MRequisition(this.getCtx(), M_Requisition_ID, this.get_TrxName());
        this.p_M_Warehouse_ID = req.getM_Warehouse_ID();
        this.p_C_DocType_ID = req.getC_DocType_ID();
        this.log.info("M_Warehouse_ID=" + this.p_M_Warehouse_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + " - ReplenishmentCreate=" + this.p_ReplenishmentCreate + ", C_DocType_ID=" + this.p_C_DocType_ID);
        MWarehouse wh = new MWarehouse(this.getCtx(), req.getM_Warehouse_ID(), this.get_TrxName());
        if (wh.get_ID() == 0) {
            throw new AdempiereSystemError("@FillMandatory@ @M_Warehouse_ID@");
        }
        this.prepareTable();
        this.fillTable(wh);
        String sqlDet = "SELECT M_Product_ID,C_BPartner_ID, qtytoorder  FROM T_Replenish WHERE M_WarehouseSource_ID IS NULL AND AD_PInstance_ID = " + this.getAD_PInstance_ID();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sqlDet, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MRequisitionLine line = new MRequisitionLine(req);
                line.setM_Product_ID(rs.getInt("M_Product_ID"));
                line.setC_BPartner_ID(rs.getInt("C_BPartner_ID"));
                line.setQty(rs.getBigDecimal("qtytoorder"));
                line.setPrice();
                line.save();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return "Detalle Generado";
    }

    private void prepareTable() {
        String sql = "UPDATE M_Replenish SET Level_Max = Level_Min WHERE Level_Max < Level_Min";
        int no = DB.executeUpdate(sql, this.get_TrxName());
        if (no != 0) {
            this.log.fine("Corrected Max_Level=" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE M_Product_PO SET Order_Min = 1 WHERE Order_Min IS NULL OR Order_Min < 1", this.get_TrxName())) != 0) {
            this.log.fine("Corrected Order Min=" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE M_Product_PO SET Order_Pack = 1 WHERE Order_Pack IS NULL OR Order_Pack < 1", this.get_TrxName())) != 0) {
            this.log.fine("Corrected Order Pack=" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE M_Product_PO p SET IsCurrentVendor='Y' WHERE IsCurrentVendor<>'Y' AND EXISTS (SELECT pp.M_Product_ID FROM M_Product_PO pp WHERE p.M_Product_ID=pp.M_Product_ID GROUP BY pp.M_Product_ID HAVING COUNT(*) = 1)", this.get_TrxName())) != 0) {
            this.log.fine("Corrected CurrentVendor(Y)=" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE M_Product_PO p SET IsCurrentVendor='N' WHERE IsCurrentVendor = 'Y' AND EXISTS (SELECT pp.M_Product_ID FROM M_Product_PO pp WHERE p.M_Product_ID=pp.M_Product_ID AND pp.IsCurrentVendor='Y' GROUP BY pp.M_Product_ID HAVING COUNT(*) > 1)", this.get_TrxName())) != 0) {
            this.log.fine("Corrected CurrentVendor(N)=" + no);
        }
        if ((no = DB.executeUpdate(sql = "DELETE T_Replenish WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) != 0) {
            this.log.fine("Delete Existing Temp=" + no);
        }
    }

    private void fillTable(MWarehouse wh) throws Exception {
        String className;
        String sql = "INSERT INTO T_Replenish (AD_PInstance_ID, M_Warehouse_ID, M_Product_ID, AD_Client_ID, AD_Org_ID, ReplenishType, Level_Min, Level_Max, C_BPartner_ID, Order_Min, Order_Pack, QtyToOrder, ReplenishmentCreate) SELECT " + this.getAD_PInstance_ID() + ", r.M_Warehouse_ID, r.M_Product_ID, r.AD_Client_ID, r.AD_Org_ID," + " r.ReplenishType, r.Level_Min, r.Level_Max," + " po.C_BPartner_ID, po.Order_Min, po.Order_Pack, 0, ";
        sql = this.p_ReplenishmentCreate == null ? String.valueOf(sql) + "null" : String.valueOf(sql) + "'" + this.p_ReplenishmentCreate + "'";
        sql = String.valueOf(sql) + " FROM M_Replenish r INNER JOIN M_Product_PO po ON (r.M_Product_ID=po.M_Product_ID) WHERE po.IsCurrentVendor='Y' AND r.ReplenishType<>'0' AND po.IsActive='Y' AND r.IsActive='Y' AND r.M_Warehouse_ID=" + this.p_M_Warehouse_ID;
        if (this.p_C_BPartner_ID != 0) {
            sql = String.valueOf(sql) + " AND po.C_BPartner_ID=" + this.p_C_BPartner_ID;
        }
        int no = DB.executeUpdate(sql, this.get_TrxName());
        this.log.finest(sql);
        this.log.fine("Insert (1) #" + no);
        if (this.p_C_BPartner_ID == 0) {
            sql = "INSERT INTO T_Replenish (AD_PInstance_ID, M_Warehouse_ID, M_Product_ID, AD_Client_ID, AD_Org_ID, ReplenishType, Level_Min, Level_Max, C_BPartner_ID, Order_Min, Order_Pack, QtyToOrder, ReplenishmentCreate) SELECT " + this.getAD_PInstance_ID() + ", r.M_Warehouse_ID, r.M_Product_ID, r.AD_Client_ID, r.AD_Org_ID," + " r.ReplenishType, r.Level_Min, r.Level_Max," + " 0, 1, 1, 0, ";
            sql = this.p_ReplenishmentCreate == null ? String.valueOf(sql) + "null" : String.valueOf(sql) + "'" + this.p_ReplenishmentCreate + "'";
            sql = String.valueOf(sql) + " FROM M_Replenish r WHERE r.ReplenishType<>'0' AND r.IsActive='Y' AND r.M_Warehouse_ID=" + this.p_M_Warehouse_ID + " AND NOT EXISTS (SELECT * FROM T_Replenish t " + "WHERE r.M_Product_ID=t.M_Product_ID" + " AND AD_PInstance_ID=" + this.getAD_PInstance_ID() + ")";
            no = DB.executeUpdate(sql, this.get_TrxName());
            this.log.fine("Insert (BP) #" + no);
        }
        sql = "UPDATE T_Replenish t SET QtyOnHand = (SELECT COALESCE(SUM(QtyOnHand),0) FROM M_Storage s, M_Locator l WHERE t.M_Product_ID=s.M_Product_ID AND l.M_Locator_ID=s.M_Locator_ID AND l.M_Warehouse_ID=t.M_Warehouse_ID),QtyReserved = (SELECT COALESCE(SUM(QtyReserved),0) FROM M_StorageReservation sr WHERE t.M_Product_ID=sr.M_Product_ID AND sr.M_Warehouse_ID=t.M_Warehouse_ID),QtyOrdered = (SELECT COALESCE(SUM(QtyOrdered),0) FROM M_StorageReservation sr WHERE t.M_Product_ID=sr.M_Product_ID AND sr.M_Warehouse_ID=t.M_Warehouse_ID)";
        if (this.p_C_DocType_ID != 0) {
            sql = String.valueOf(sql) + ", C_DocType_ID=" + this.p_C_DocType_ID;
        }
        if ((no = DB.executeUpdate(sql = String.valueOf(sql) + " WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) != 0) {
            this.log.fine("Update #" + no);
        }
        if ((no = DB.executeUpdate(sql = "DELETE T_Replenish r WHERE (EXISTS (SELECT * FROM M_Product p WHERE p.M_Product_ID=r.M_Product_ID AND p.IsActive='N') OR EXISTS (SELECT * FROM M_Replenish rr  WHERE rr.M_Product_ID=r.M_Product_ID AND rr.IsActive='N' AND rr.M_Warehouse_ID=" + this.p_M_Warehouse_ID + " ))" + " AND AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) != 0) {
            this.log.fine("Delete Inactive=" + no);
        }
        sql = "UPDATE T_Replenish SET QtyOnHand = 0 WHERE QtyOnHand IS NULL";
        no = DB.executeUpdate(sql, this.get_TrxName());
        sql = "UPDATE T_Replenish SET QtyReserved = 0 WHERE QtyReserved IS NULL";
        no = DB.executeUpdate(sql, this.get_TrxName());
        sql = "UPDATE T_Replenish SET QtyOrdered = 0 WHERE QtyOrdered IS NULL";
        no = DB.executeUpdate(sql, this.get_TrxName());
        sql = "UPDATE T_Replenish SET QtyToOrder = CASE WHEN QtyOnHand - QtyReserved + QtyOrdered <= Level_Min  THEN Level_Max - QtyOnHand + QtyReserved - QtyOrdered  ELSE 0 END WHERE ReplenishType='1' AND AD_PInstance_ID=" + this.getAD_PInstance_ID();
        no = DB.executeUpdate(sql, this.get_TrxName());
        if (no != 0) {
            this.log.fine("Update Type-1=" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE T_Replenish SET QtyToOrder = Level_Max - QtyOnHand + QtyReserved - QtyOrdered WHERE ReplenishType='2' AND AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) != 0) {
            this.log.fine("Update Type-2=" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE T_Replenish SET QtyToOrder = Order_Min WHERE QtyToOrder < Order_Min AND QtyToOrder > 0 AND AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) != 0) {
            this.log.fine("Set MinOrderQty=" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE T_Replenish SET QtyToOrder = QtyToOrder - MOD(QtyToOrder, Order_Pack) + Order_Pack WHERE MOD(QtyToOrder, Order_Pack) <> 0 AND QtyToOrder > 0 AND AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) != 0) {
            this.log.fine("Set OrderPackQty=" + no);
        }
        if (wh.getM_WarehouseSource_ID() != 0 && (no = DB.executeUpdate(sql = "UPDATE T_Replenish SET M_WarehouseSource_ID=" + wh.getM_WarehouseSource_ID() + " WHERE AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) != 0) {
            this.log.fine("Set Source Warehouse=" + no);
        }
        if ((no = DB.executeUpdate(sql = "UPDATE T_Replenish SET M_WarehouseSource_ID = NULL WHERE M_Warehouse_ID=M_WarehouseSource_ID AND AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) != 0) {
            this.log.fine("Set same Source Warehouse=" + no);
        }
        if ((className = wh.getReplenishmentClass()) != null && className.length() > 0) {
            ReplenishInterface custom = null;
            try {
                Class<?> clazz = Class.forName(className);
                custom = (ReplenishInterface)clazz.newInstance();
            }
            catch (Exception e) {
                throw new AdempiereUserError("No custom Replenishment class " + className + " - " + e.toString());
            }
            X_T_Replenish[] replenishs = this.getReplenish("ReplenishType='9'");
            int i = 0;
            while (i < replenishs.length) {
                X_T_Replenish replenish = replenishs[i];
                if (replenish.getReplenishType().equals("9")) {
                    BigDecimal qto = null;
                    try {
                        qto = custom.getQtyToOrder(wh, replenish);
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, custom.toString(), e);
                    }
                    if (qto == null) {
                        qto = Env.ZERO;
                    }
                    replenish.setQtyToOrder(qto);
                    replenish.save();
                }
                ++i;
            }
        }
        if ((no = DB.executeUpdate(sql = "DELETE T_Replenish WHERE QtyToOrder < 1 AND AD_PInstance_ID=" + this.getAD_PInstance_ID(), this.get_TrxName())) != 0) {
            this.log.fine("Delete No QtyToOrder=" + no);
        }
    }

    private X_T_Replenish[] getReplenish(String where) {
        String sql = "SELECT * FROM T_Replenish WHERE AD_PInstance_ID=? AND C_BPartner_ID > 0 ";
        if (where != null && where.length() > 0) {
            sql = String.valueOf(sql) + " AND " + where;
        }
        sql = String.valueOf(sql) + " ORDER BY M_Warehouse_ID, M_WarehouseSource_ID, C_BPartner_ID";
        ArrayList<X_T_Replenish> list = new ArrayList<X_T_Replenish>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_PInstance_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new X_T_Replenish(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        X_T_Replenish[] retValue = new X_T_Replenish[list.size()];
        list.toArray(retValue);
        return retValue;
    }
}

