/*
 * Decompiled with CFR 0.152.
 */
package org.dpp.model;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInvoice;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModDPPValidUTMToDate
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModDPPValidUTMToDate.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_Invoice", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        int idutm;
        MInvoice inv;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 2 && po.get_Table_ID() == MInvoice.Table_ID && po.is_ValueChanged("DocStatus") && ((inv = (MInvoice)po).getDocStatus().compareTo("CO") == 0 || inv.getDocStatus().compareTo("IP") == 0) && (idutm = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(C_Currency_ID) FROM C_Currency WHERE Description like 'UTM' ")) > 0) {
            BigDecimal amt3UTMclp = Env.ZERO;
            amt3UTMclp = MConversionRate.convert(po.getCtx(), new BigDecimal("3.0"), idutm, inv.getC_Currency_ID(), inv.getDateAcct(), 0, inv.getAD_Client_ID(), inv.getAD_Org_ID());
            if (amt3UTMclp == null) {
                throw new AdempiereException("Debe definir la UTM para el d\u00eda correspondiente a la completitud de la factura.");
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

