/*
 * Decompiled with CFR 0.152.
 */
package org.dpp.model;

import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProductPrice;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModDPPUpdatePriceList
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModDPPUpdatePriceList.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MOrder.Table_ID && !(order = (MOrder)po).isSOTrx()) {
            int M_PriceList_Version_ID = 0;
            String sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC";
            M_PriceList_Version_ID = DB.getSQLValueEx(null, sql, order.getM_PriceList_ID(), order.getDateOrdered());
            if (M_PriceList_Version_ID > 0) {
                MOrderLine[] lines = order.getLines();
                int i = 0;
                while (i < lines.length) {
                    MOrderLine line = lines[i];
                    if (line.getM_Product_ID() > 0) {
                        MProductPrice pp = MProductPrice.get(po.getCtx(), M_PriceList_Version_ID, line.getM_Product_ID(), po.get_TrxName());
                        pp.setPriceList(line.getPriceEntered());
                        pp.setPriceStd(line.getPriceEntered());
                        pp.save();
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

