/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import com.sun.mail.smtp.SMTPMessage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.compiere.Adempiere;
import org.compiere.model.MClient;
import org.compiere.util.ByteArrayDataSource;
import org.compiere.util.CLogger;
import org.compiere.util.EMailAuthenticator;
import org.compiere.util.Ini;

public final class EMail
implements Serializable {
    private static final long serialVersionUID = -2526338392563042117L;
    public static final String HTML_MAIL_MARKER = "ContentType=text/html;";
    private InternetAddress m_from;
    private ArrayList<InternetAddress> m_to;
    private ArrayList<InternetAddress> m_cc;
    private ArrayList<InternetAddress> m_bcc;
    private InternetAddress m_replyTo;
    private String m_subject;
    private String m_messageText;
    private String m_messageHTML;
    private String m_smtpHost;
    private ArrayList<Object> m_attachments;
    private EMailAuthenticator m_auth = null;
    private SMTPMessage m_msg = null;
    private Properties m_ctx;
    private boolean m_valid = false;
    private String m_sentMsg = null;
    public static final String SENT_OK = "OK";
    protected static CLogger log = CLogger.getCLogger(EMail.class);

    public EMail(MClient client, String from, String to, String subject, String message) {
        this(client.getCtx(), client.getSMTPHost(), from, to, subject, message);
    }

    public EMail(MClient client, String from, String to, String subject, String message, boolean html) {
        this(client.getCtx(), client.getSMTPHost(), from, to, subject, message, html);
    }

    public EMail(Properties ctx, String smtpHost, String from, String to, String subject, String message) {
        this(ctx, smtpHost, from, to, subject, message, false);
    }

    public EMail(Properties ctx, String smtpHost, String from, String to, String subject, String message, boolean html) {
        this.setSmtpHost(smtpHost);
        this.setFrom(from);
        this.addTo(to);
        this.m_ctx = ctx;
        if (subject == null || subject.length() == 0) {
            this.setSubject(".");
        } else {
            this.setSubject(subject);
        }
        if (message != null && message.length() > 0) {
            if (html) {
                this.setMessageHTML(subject, message);
            } else {
                this.setMessageText(message);
            }
        }
        this.m_valid = this.isValid(true);
    }

    /*
     * Exception decompiling
     */
    public String send() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 6[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getSentMsg() {
        return this.m_sentMsg;
    }

    public boolean isSentOK() {
        return this.m_sentMsg != null && SENT_OK.equals(this.m_sentMsg);
    }

    private void dumpMessage() {
        if (this.m_msg == null) {
            return;
        }
        try {
            Enumeration e = this.m_msg.getAllHeaderLines();
            while (e.hasMoreElements()) {
                log.fine("- " + e.nextElement());
            }
        }
        catch (MessagingException ex) {
            log.log(Level.WARNING, this.m_msg.toString(), ex);
        }
    }

    protected MimeMessage getMimeMessage() {
        return this.m_msg;
    }

    public String getMessageID() {
        try {
            if (this.m_msg != null) {
                return this.m_msg.getMessageID();
            }
        }
        catch (MessagingException ex) {
            log.log(Level.SEVERE, "", ex);
        }
        return null;
    }

    public EMailAuthenticator createAuthenticator(String username, String password) {
        if (username == null || password == null) {
            log.warning("Ignored - " + username + "/" + password);
            this.m_auth = null;
        } else {
            this.m_auth = new EMailAuthenticator(username, password);
        }
        return this.m_auth;
    }

    public InternetAddress getFrom() {
        return this.m_from;
    }

    public void setFrom(String newFrom) {
        if (newFrom == null) {
            this.m_valid = false;
            return;
        }
        try {
            this.m_from = new InternetAddress(newFrom, true);
        }
        catch (Exception e) {
            log.log(Level.WARNING, String.valueOf(newFrom) + ": " + e.toString());
            this.m_valid = false;
        }
    }

    public boolean addTo(String newTo) {
        if (newTo == null || newTo.length() == 0) {
            this.m_valid = false;
            return false;
        }
        InternetAddress ia = null;
        try {
            ia = new InternetAddress(newTo, true);
        }
        catch (Exception e) {
            log.log(Level.WARNING, String.valueOf(newTo) + ": " + e.toString());
            this.m_valid = false;
            return false;
        }
        if (this.m_to == null) {
            this.m_to = new ArrayList();
        }
        this.m_to.add(ia);
        return true;
    }

    public InternetAddress getTo() {
        if (this.m_to == null || this.m_to.size() == 0) {
            return null;
        }
        InternetAddress ia = this.m_to.get(0);
        return ia;
    }

    public InternetAddress[] getTos() {
        if (this.m_to == null || this.m_to.size() == 0) {
            return null;
        }
        InternetAddress[] ias = new InternetAddress[this.m_to.size()];
        this.m_to.toArray(ias);
        return ias;
    }

    public boolean addCc(String newCc) {
        if (newCc == null || newCc.length() == 0) {
            return false;
        }
        InternetAddress ia = null;
        try {
            ia = new InternetAddress(newCc, true);
        }
        catch (Exception e) {
            log.log(Level.WARNING, String.valueOf(newCc) + ": " + e.toString());
            return false;
        }
        if (this.m_cc == null) {
            this.m_cc = new ArrayList();
        }
        this.m_cc.add(ia);
        return true;
    }

    public InternetAddress[] getCcs() {
        if (this.m_cc == null || this.m_cc.size() == 0) {
            return null;
        }
        InternetAddress[] ias = new InternetAddress[this.m_cc.size()];
        this.m_cc.toArray(ias);
        return ias;
    }

    public boolean addBcc(String newBcc) {
        if (newBcc == null || newBcc.length() == 0) {
            return false;
        }
        InternetAddress ia = null;
        try {
            ia = new InternetAddress(newBcc, true);
        }
        catch (Exception e) {
            log.log(Level.WARNING, String.valueOf(newBcc) + ": " + e.getMessage());
            return false;
        }
        if (this.m_bcc == null) {
            this.m_bcc = new ArrayList();
        }
        this.m_bcc.add(ia);
        return true;
    }

    public InternetAddress[] getBccs() {
        if (this.m_bcc == null || this.m_bcc.size() == 0) {
            return null;
        }
        InternetAddress[] ias = new InternetAddress[this.m_bcc.size()];
        this.m_bcc.toArray(ias);
        return ias;
    }

    public boolean setReplyTo(String newTo) {
        if (newTo == null || newTo.length() == 0) {
            return false;
        }
        InternetAddress ia = null;
        try {
            ia = new InternetAddress(newTo, true);
        }
        catch (Exception e) {
            log.log(Level.WARNING, String.valueOf(newTo) + ": " + e.toString());
            return false;
        }
        this.m_replyTo = ia;
        return true;
    }

    public InternetAddress getReplyTo() {
        return this.m_replyTo;
    }

    public void setSubject(String newSubject) {
        if (newSubject == null || newSubject.length() == 0) {
            this.m_valid = false;
        } else {
            this.m_subject = newSubject;
        }
    }

    public String getSubject() {
        return this.m_subject;
    }

    public void setMessageText(String newMessage) {
        if (newMessage == null || newMessage.length() == 0) {
            this.m_valid = false;
        } else {
            this.m_messageText = newMessage;
            if (!this.m_messageText.endsWith("\n")) {
                this.m_messageText = String.valueOf(this.m_messageText) + "\n";
            }
        }
    }

    public String getMessageCRLF() {
        if (this.m_messageText == null) {
            return "";
        }
        char[] chars = this.m_messageText.toCharArray();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '\n') {
                int previous = i - 1;
                if (previous >= 0 && chars[previous] == '\r') {
                    sb.append(c);
                } else {
                    sb.append("\r\n");
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public void setMessageHTML(String html) {
        if (html == null || html.length() == 0) {
            this.m_valid = false;
        } else {
            this.m_messageHTML = html;
            if (!this.m_messageHTML.endsWith("\n")) {
                this.m_messageHTML = String.valueOf(this.m_messageHTML) + "\n";
            }
        }
    }

    public void setMessageHTML(String subject, String message) {
        this.m_subject = subject;
        StringBuffer sb = new StringBuffer("<HTML>\n").append("<HEAD>\n").append("<TITLE>\n").append(String.valueOf(subject) + "\n").append("</TITLE>\n").append("</HEAD>\n");
        sb.append("<BODY>\n").append("<H2>" + subject + "</H2>" + "\n").append(message).append("\n").append("</BODY>\n");
        sb.append("</HTML>\n");
        this.m_messageHTML = sb.toString();
    }

    public String getMessageHTML() {
        return this.m_messageHTML;
    }

    public void addAttachment(File file) {
        if (file == null) {
            return;
        }
        if (this.m_attachments == null) {
            this.m_attachments = new ArrayList();
        }
        this.m_attachments.add(file);
    }

    public void addAttachments(Collection<File> files) {
        if (files == null || files.size() == 0) {
            return;
        }
        for (File f : files) {
            this.addAttachment(f);
        }
    }

    public void addAttachment(URI url) {
        if (url == null) {
            return;
        }
        if (this.m_attachments == null) {
            this.m_attachments = new ArrayList();
        }
        this.m_attachments.add(url);
    }

    public void addAttachment(byte[] data, String type, String name) {
        ByteArrayDataSource byteArray = new ByteArrayDataSource(data, type).setName(name);
        this.addAttachment(byteArray);
    }

    public void addAttachment(DataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        if (this.m_attachments == null) {
            this.m_attachments = new ArrayList();
        }
        this.m_attachments.add(dataSource);
    }

    /*
     * Unable to fully structure code
     */
    private void setContent() throws MessagingException, IOException {
        block9: {
            block8: {
                charSetName = Ini.getCharset().name();
                if (charSetName == null || charSetName.length() == 0) {
                    charSetName = "iso-8859-1";
                }
                this.m_msg.setSubject(this.getSubject(), charSetName);
                if (this.m_attachments != null && this.m_attachments.size() != 0) break block8;
                if (this.m_messageHTML == null || this.m_messageHTML.length() == 0) {
                    this.m_msg.setText(this.getMessageCRLF(), charSetName);
                } else {
                    this.m_msg.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.m_messageHTML, charSetName, "text/html")));
                }
                EMail.log.fine("(simple) " + this.getSubject());
                break block9;
            }
            mbp_1 = new MimeBodyPart();
            mbp_1.setText("");
            if (this.m_messageHTML == null || this.m_messageHTML.length() == 0) {
                mbp_1.setText(this.getMessageCRLF(), charSetName);
            } else {
                mbp_1.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.m_messageHTML, charSetName, "text/html")));
            }
            mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)mbp_1);
            EMail.log.fine("(multi) " + this.getSubject() + " - " + mbp_1);
            i = 0;
            while (i < this.m_attachments.size()) {
                block12: {
                    block13: {
                        block10: {
                            block11: {
                                attachment = this.m_attachments.get(i);
                                ds = null;
                                if (!(attachment instanceof File)) break block10;
                                file = (File)attachment;
                                if (!file.exists()) break block11;
                                ds = new FileDataSource(file);
                                ** GOTO lbl44
                            }
                            EMail.log.log(Level.WARNING, "File does not exist: " + file);
                            break block12;
                        }
                        if (!(attachment instanceof URI)) break block13;
                        url = (URI)attachment;
                        ds = new URLDataSource(url.toURL());
                        ** GOTO lbl44
                    }
                    if (!(attachment instanceof DataSource)) {
                        EMail.log.log(Level.WARNING, "Attachement type unknown: " + attachment);
                    } else {
                        ds = (DataSource)attachment;
lbl44:
                        // 3 sources

                        mbp_2 = new MimeBodyPart();
                        mbp_2.setDataHandler(new DataHandler(ds));
                        mbp_2.setFileName(ds.getName());
                        EMail.log.fine("Added Attachment " + ds.getName() + " - " + mbp_2);
                        mp.addBodyPart((BodyPart)mbp_2);
                    }
                }
                ++i;
            }
            this.m_msg.setContent((Multipart)mp);
        }
    }

    public void setSmtpHost(String newSmtpHost) {
        if (newSmtpHost == null || newSmtpHost.length() == 0) {
            this.m_valid = false;
        } else {
            this.m_smtpHost = newSmtpHost;
        }
    }

    public String getSmtpHost() {
        return this.m_smtpHost;
    }

    public boolean isValid() {
        return this.m_valid;
    }

    public boolean isValid(boolean recheck) {
        if (!recheck) {
            return this.m_valid;
        }
        if (this.m_from == null || this.m_from.getAddress().length() == 0 || this.m_from.getAddress().indexOf(32) != -1) {
            log.warning("From is invalid=" + this.m_from);
            return false;
        }
        InternetAddress[] ias = this.getTos();
        if (ias == null) {
            log.warning("No To");
            return false;
        }
        int i = 0;
        while (i < ias.length) {
            if (ias[i] == null || ias[i].getAddress().length() == 0 || ias[i].getAddress().indexOf(32) != -1) {
                log.warning("To(" + i + ") is invalid=" + ias[i]);
                return false;
            }
            ++i;
        }
        if (this.m_smtpHost == null || this.m_smtpHost.length() == 0) {
            log.warning("SMTP Host is invalid" + this.m_smtpHost);
            return false;
        }
        if (this.m_subject == null || this.m_subject.length() == 0) {
            log.warning("Subject is invalid=" + this.m_subject);
            return false;
        }
        return true;
    }

    public Object[] getAttachments() {
        if (this.m_attachments == null) {
            return new Object[0];
        }
        return this.m_attachments.toArray();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("EMail[");
        sb.append("From:").append(this.m_from).append(",To:").append(this.getTo()).append(",Subject=").append(this.getSubject()).append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        if (args.length != 5) {
            System.out.println("Parameters: smtpHost from to subject message");
            System.out.println("Example: java org.compiere.util.EMail mail.acme.com joe@acme.com sue@acme.com HiThere CheersJoe");
            System.exit(1);
        }
        EMail email = new EMail(System.getProperties(), args[0], args[1], args[2], args[3], args[4]);
        email.send();
    }
}

