/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import org.compiere.swing.CEditor;

public class CCheckBox
extends JCheckBox
implements CEditor {
    private static final long serialVersionUID = 6115543971487470944L;
    private boolean m_mandatory = false;
    private boolean m_readWrite = true;
    private Object m_value = null;

    public CCheckBox() {
        this.init();
    }

    public CCheckBox(Icon icon) {
        super(icon);
        this.init();
    }

    public CCheckBox(Icon icon, boolean selected) {
        super(icon, selected);
        this.init();
    }

    public CCheckBox(String text) {
        super(text);
        this.init();
    }

    public CCheckBox(Action a2) {
        super(a2);
        this.init();
    }

    public CCheckBox(String text, boolean selected) {
        super(text, selected);
        this.init();
    }

    public CCheckBox(String text, Icon icon) {
        super(text, icon, false);
        this.init();
    }

    public CCheckBox(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.init();
    }

    private void init() {
        this.setOpaque(false);
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.setBackground(false);
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setReadWrite(boolean rw) {
        if (super.isEnabled() != rw) {
            super.setEnabled(rw);
        }
        this.setBackground(false);
        this.m_readWrite = rw;
    }

    @Override
    public boolean isReadWrite() {
        return this.m_readWrite;
    }

    @Override
    public void setBackground(boolean error) {
    }

    @Override
    public void setBackground(Color bg) {
        if (bg.equals(this.getBackground())) {
            return;
        }
        super.setBackground(bg);
    }

    @Override
    public void setValue(Object value) {
        this.m_value = value;
        boolean sel = false;
        if (value == null) {
            sel = false;
        } else if (value.toString().equals("Y")) {
            sel = true;
        } else if (value.toString().equals("N")) {
            sel = false;
        } else if (value instanceof Boolean) {
            sel = (Boolean)value;
        } else {
            try {
                sel = Boolean.getBoolean(value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setSelected(sel);
    }

    @Override
    public Object getValue() {
        if (this.m_value instanceof String) {
            return super.isSelected() ? "Y" : "N";
        }
        return new Boolean(this.isSelected());
    }

    @Override
    public String getDisplay() {
        if (this.m_value instanceof String) {
            return super.isSelected() ? "Y" : "N";
        }
        return Boolean.toString(super.isSelected());
    }

    @Override
    public void setText(String mnemonicLabel) {
        super.setText(this.createMnemonic(mnemonicLabel));
    }

    private String createMnemonic(String text) {
        char ch;
        if (text == null) {
            return text;
        }
        int pos = text.indexOf(38);
        if (pos != -1 && (ch = text.charAt(pos + 1)) != ' ') {
            this.setMnemonic(ch);
            return text.substring(0, pos) + text.substring(pos + 1);
        }
        return text;
    }

    @Override
    public void setMnemonic(int mnemonic) {
        super.setMnemonic(mnemonic);
        InputMap map = SwingUtilities.getUIInputMap(this, 2);
        if (map == null) {
            map = new ComponentInputMapUIResource(this);
            SwingUtilities.replaceUIInputMap(this, 2, map);
        }
        map.clear();
        String className = this.getClass().getName();
        int mask = 8;
        if (this instanceof JCheckBox || className.indexOf("VButton") != -1) {
            mask = 3;
        }
        map.put(KeyStroke.getKeyStroke(mnemonic, mask, false), "pressed");
        map.put(KeyStroke.getKeyStroke(mnemonic, mask, true), "released");
        map.put(KeyStroke.getKeyStroke(mnemonic, 0, true), "released");
        this.setInputMap(2, map);
    }
}

