/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MTaxDeclaration;
import org.compiere.model.MTaxDeclarationAcct;
import org.compiere.model.MTaxDeclarationLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class TaxDeclarationCreate
extends SvrProcess {
    private int p_C_TaxDeclaration_ID = 0;
    private boolean p_DeleteOld = true;
    private MTaxDeclaration m_td = null;
    private int m_noLines = 0;
    private int m_noAccts = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("DeleteOld")) {
                this.p_DeleteOld = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_C_TaxDeclaration_ID = this.getRecord_ID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        String sql;
        this.log.info("C_TaxDeclaration_ID=" + this.p_C_TaxDeclaration_ID);
        this.m_td = new MTaxDeclaration(this.getCtx(), this.p_C_TaxDeclaration_ID, this.get_TrxName());
        if (this.m_td.get_ID() == 0) {
            throw new AdempiereSystemError("@NotFound@ @C_TaxDeclaration_ID@ = " + this.p_C_TaxDeclaration_ID);
        }
        if (this.p_DeleteOld) {
            sql = "DELETE C_TaxDeclarationLine WHERE C_TaxDeclaration_ID=?";
            int no = DB.executeUpdate(sql, this.p_C_TaxDeclaration_ID, false, this.get_TrxName());
            if (no != 0) {
                this.log.config("Delete Line #" + no);
            }
            if ((no = DB.executeUpdate(sql = "DELETE C_TaxDeclarationAcct WHERE C_TaxDeclaration_ID=?", this.p_C_TaxDeclaration_ID, false, this.get_TrxName())) != 0) {
                this.log.config("Delete Acct #" + no);
            }
        }
        sql = "SELECT * FROM C_Invoice i WHERE TRUNC(i.DateInvoiced) >= ? AND TRUNC(i.DateInvoiced) <= ?  AND Processed='Y' AND NOT EXISTS (SELECT * FROM C_TaxDeclarationLine tdl WHERE i.C_Invoice_ID=tdl.C_Invoice_ID)";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int noInvoices = 0;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setTimestamp(1, this.m_td.getDateFrom());
            pstmt.setTimestamp(2, this.m_td.getDateTo());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                this.create(new MInvoice(this.getCtx(), rs, null));
                ++noInvoices;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return "@C_Invoice_ID@ #" + noInvoices + " (" + this.m_noLines + ", " + this.m_noAccts + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(MInvoice invoice) {
        MInvoiceTax[] taxes = invoice.getTaxes(false);
        for (int i2 = 0; i2 < taxes.length; ++i2) {
            MInvoiceTax tLine = taxes[i2];
            MTaxDeclarationLine tdl = new MTaxDeclarationLine(this.m_td, invoice, tLine);
            tdl.setLine((this.m_noLines + 1) * 10);
            if (!tdl.save()) continue;
            ++this.m_noLines;
        }
        String sql = "SELECT * FROM Fact_Acct WHERE AD_Table_ID=? AND Record_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, MInvoice.Table_ID);
            pstmt.setInt(2, invoice.getC_Invoice_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MFactAcct fact = new MFactAcct(this.getCtx(), rs, null);
                MTaxDeclarationAcct tda = new MTaxDeclarationAcct(this.m_td, fact);
                tda.setLine((this.m_noAccts + 1) * 10);
                if (!tda.save()) continue;
                ++this.m_noAccts;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }
}

