/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.model.MPeriod;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ResetAcct
extends SvrProcess {
    private int Table_ID = 0;
    private int p_Period_From = 0;
    private int p_Period_To = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("AD_Table_ID")) {
                this.Table_ID = para[i].getParameterAsInt();
            } else if (name.equals("C_Period_ID")) {
                this.p_Period_From = para[i].getParameterAsInt();
                this.p_Period_To = para[i].getParameter_ToAsInt();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_Period_From == 0 || this.p_Period_To == 0) {
            throw new IllegalArgumentException("Periods Mandatory");
        }
        MPeriod from = MPeriod.get(this.getCtx(), this.p_Period_From);
        MPeriod to = MPeriod.get(this.getCtx(), this.p_Period_To);
        if (from.getC_Year_ID() != to.getC_Year_ID()) {
            throw new IllegalArgumentException("Periods Same year");
        }
        String sql = "select * from C_Period where periodno >= " + from.getPeriodNo() + " and  periodno <= " + to.getPeriodNo() + " and C_Year_ID=" + from.getC_Year_ID();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int noOpen = DB.getSQLValue(this.get_TrxName(), "select count(1) from C_PeriodControl where periodstatus!='O' and c_period_id =" + rs.getInt("c_period_id"));
                if (noOpen > 0) {
                    this.addLog(0, rs.getTimestamp("startdate"), null, String.valueOf(rs.getString("name")) + " Periodo Cerrado");
                    continue;
                }
                int[] docs = Doc.getDocumentsTableID();
                String[] tables = Doc.getDocumentsTableName();
                int i = 0;
                while (i < tables.length) {
                    int AD_Table_ID = docs[i];
                    String TableName = tables[i];
                    if (!(this.Table_ID > 0 && this.Table_ID != AD_Table_ID || TableName.equals("C_DocType") || TableName.equals("PP_Order") || TableName.equals("PP_Cost_Collector") || TableName.equals("DD_Order") || TableName.equals("HR_Process") || TableName.equals("C_BankFactoring"))) {
                        String SqlUpdate = "Update " + TableName + " set posted='N', Processing='N' Where 1=1";
                        String TableField = "DateAcct";
                        if (TableName.equals("C_BankStatement")) {
                            TableField = "StatementDate";
                        }
                        if (TableName.equals("M_Inventory") || TableName.equals("M_Movement") || TableName.equals("M_Production") || TableName.equals("C_ProjectIssue")) {
                            TableField = "MovementDate";
                        }
                        if (TableName.equals("M_Requisition")) {
                            TableField = "DateDoc";
                        }
                        SqlUpdate = String.valueOf(SqlUpdate) + " And " + TableField + " Between ? and ? and ad_client_ID = ?";
                        int cantV = -1;
                        try {
                            String sqlValid = "SELECT count(IsCustomAcct) FROM " + TableName;
                            cantV = DB.getSQLValue(null, sqlValid);
                        }
                        catch (Exception e1) {
                            this.log.log(Level.SEVERE, String.valueOf(sql) + " -- No existe campo IsCustomAcct en la tabla", e1);
                        }
                        if (cantV >= 0) {
                            SqlUpdate = String.valueOf(SqlUpdate) + " And IsCustomAcct = 'N' ";
                        }
                        CPreparedStatement cs = DB.prepareStatement(SqlUpdate, this.get_TrxName());
                        cs.setTimestamp(1, rs.getTimestamp("startdate"));
                        cs.setTimestamp(2, rs.getTimestamp("enddate"));
                        cs.setInt(3, this.getAD_Client_ID());
                        cs.executeUpdate();
                        String sqlDelete = "Delete from Fact_Acct where AD_Table_ID=" + AD_Table_ID + " and C_Period_ID= " + rs.getInt("C_Period_ID") + " and AD_Client_ID= " + this.getAD_Client_ID();
                        if (cantV >= 0) {
                            sqlDelete = String.valueOf(sqlDelete) + " AND (select IsCustomAcct FROM " + TableName + " where Fact_Acct.Record_ID = " + TableName + "_ID) = 'N'";
                        }
                        DB.executeUpdate(sqlDelete, this.get_TrxName());
                        this.commit();
                        cs = null;
                        this.addLog(0, rs.getTimestamp("startdate"), null, String.valueOf(rs.getString("name")) + " Periodo Reseteado");
                    }
                    ++i;
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        return "Contabilidad Borrada";
    }
}

