/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import org.compiere.model.MAttachment;
import org.compiere.model.MRequest;
import org.compiere.model.MUser;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogMgt;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMailAuthenticator;

public class RequestEMailProcessor
extends SvrProcess {
    private String p_IMAPHost = null;
    private String p_IMAPUser = null;
    private String p_IMAPPwd = null;
    private String p_RequestFolder = null;
    private String p_InboxFolder = null;
    private String p_ErrorFolder = null;
    private int C_BPartner_ID = 0;
    private int AD_User_ID = 0;
    private int AD_Role_ID = 0;
    private int SalesRep_ID = 0;
    private int R_RequestType_ID = 0;
    private String p_DefaultPriority = null;
    private String p_DefaultConfidentiality = null;
    private int noProcessed = 0;
    private int noRequest = 0;
    private int noError = 0;
    private Session m_session = null;
    private Store m_store = null;
    private static final int ERROR = 0;
    private static final int REQUEST = 1;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("p_IMAPHost")) {
                this.p_IMAPHost = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("p_IMAPUser")) {
                this.p_IMAPUser = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("p_IMAPPwd")) {
                this.p_IMAPPwd = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("p_RequestFolder")) {
                this.p_RequestFolder = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("p_InboxFolder")) {
                this.p_InboxFolder = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("p_ErrorFolder")) {
                this.p_ErrorFolder = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.C_BPartner_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_User_ID")) {
                this.AD_User_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_Role_ID")) {
                this.AD_Role_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("SalesRep_ID")) {
                this.SalesRep_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("R_RequestType_ID")) {
                this.R_RequestType_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("p_DefaultPriority")) {
                this.p_DefaultPriority = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("p_DefaultConfidentiality")) {
                this.p_DefaultConfidentiality = (String)para[i2].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("doIt - IMAPHost=" + this.p_IMAPHost + " IMAPUser=" + this.p_IMAPUser + " RequestFolder=" + this.p_RequestFolder + " InboxFolder=" + this.p_InboxFolder + " ErrorFolder=" + this.p_ErrorFolder);
        try {
            this.getSession();
            this.getStore();
            this.processInBox();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "processInBox", e);
        }
        try {
            if (this.m_store.isConnected()) {
                this.m_store.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "processInBox - Total=" + this.noProcessed + " - Requests=" + this.noRequest + " - Errors=" + this.noError;
    }

    private Session getSession() throws Exception {
        if (this.m_session != null) {
            return this.m_session;
        }
        Properties props = System.getProperties();
        props.put("mail.store.protocol", "smtp");
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.host", this.p_IMAPHost);
        props.put("mail.smtp.auth", "true");
        EMailAuthenticator auth = new EMailAuthenticator(this.p_IMAPUser, this.p_IMAPPwd);
        this.m_session = Session.getDefaultInstance((Properties)props, (Authenticator)auth);
        this.m_session.setDebug(CLogMgt.isLevelFinest());
        this.log.fine("getSession - " + this.m_session);
        return this.m_session;
    }

    private Store getStore() throws Exception {
        if (this.m_store != null) {
            return this.m_store;
        }
        if (this.getSession() == null) {
            throw new IllegalStateException("No Session");
        }
        this.m_store = this.m_session.getStore("imap");
        this.m_store.connect();
        this.log.fine("getStore - " + this.m_store);
        return this.m_store;
    }

    private void processInBox() throws Exception {
        Folder folder = this.m_store.getDefaultFolder();
        if (folder == null) {
            throw new IllegalStateException("No default folder");
        }
        Folder inbox = folder.getFolder(this.p_InboxFolder);
        if (!inbox.exists()) {
            throw new IllegalStateException("No Inbox");
        }
        inbox.open(2);
        this.log.fine("processInBox - " + inbox.getName() + "; Messages Total=" + inbox.getMessageCount() + "; New=" + inbox.getNewMessageCount());
        Folder requestFolder = folder.getFolder(this.p_RequestFolder);
        if (!requestFolder.exists() && !requestFolder.create(1)) {
            throw new IllegalStateException("Cannot create Request Folder");
        }
        requestFolder.open(2);
        Folder errorFolder = folder.getFolder(this.p_ErrorFolder);
        if (!errorFolder.exists() && !errorFolder.create(1)) {
            throw new IllegalStateException("Cannot create Error Folder");
        }
        errorFolder.open(2);
        Message[] messages = inbox.getMessages();
        for (int i2 = 0; i2 < messages.length; ++i2) {
            String[] hdrs;
            Message msg = messages[i2];
            int result = this.processMessage(msg);
            if (result == 1) {
                hdrs = msg.getHeader("Message-ID");
                try {
                    if (this.createRequest(msg)) {
                        msg.setFlag(Flags.Flag.SEEN, true);
                        msg.setFlag(Flags.Flag.ANSWERED, true);
                        requestFolder.appendMessages(new Message[]{msg});
                        this.log.info("message " + hdrs[0] + " moved to " + this.p_RequestFolder + " folder");
                        this.log.info("message info: Sent -> " + msg.getSentDate() + " From -> " + msg.getFrom()[0].toString());
                        msg.setFlag(Flags.Flag.DELETED, true);
                        Message[] deleted = inbox.expunge();
                        ++this.noRequest;
                    }
                }
                catch (Exception e) {
                    this.log.info("message " + hdrs[0] + " threw error");
                    e.printStackTrace();
                }
            } else {
                errorFolder.appendMessages(new Message[]{msg});
                hdrs = msg.getHeader("Message-ID");
                this.log.warning("message " + hdrs[0] + " moved to " + this.p_ErrorFolder + " folder");
                this.log.warning("message info: Sent -> " + msg.getSentDate() + " From -> " + msg.getFrom()[0].toString());
                ++this.noError;
            }
            ++this.noProcessed;
        }
        this.log.info("processInBox - Total=" + this.noProcessed + " - Requests=" + this.noRequest + " - Errors=" + this.noError);
        errorFolder.close(false);
        requestFolder.close(false);
        inbox.close(true);
    }

    private boolean createRequest(Message msg) throws MessagingException, SQLException {
        MUser us;
        String fromAddress;
        Address[] from = msg.getFrom();
        if (from[0].toString().indexOf(60) != -1 && from[0].toString().indexOf(62) != -1) {
            fromAddress = from[0].toString().substring(from[0].toString().indexOf(60) + 1, from[0].toString().indexOf(62));
            this.log.info("fromAddress stripped: " + fromAddress);
        } else {
            fromAddress = from[0].toString();
        }
        String[] hdrs = msg.getHeader("Message-ID");
        int retValuedup = 0;
        String sqldup = "select r_request_id from r_request where ad_client_id = ? and documentno = ? and startdate = ?";
        CPreparedStatement pstmtdup = null;
        pstmtdup = DB.prepareStatement(sqldup, null);
        pstmtdup.setInt(1, this.getAD_Client_ID());
        pstmtdup.setString(2, hdrs[0].substring(0, 30));
        pstmtdup.setTimestamp(3, new Timestamp(msg.getSentDate().getTime()));
        ResultSet rsdup = pstmtdup.executeQuery();
        if (rsdup.next()) {
            retValuedup = rsdup.getInt(1);
        }
        rsdup.close();
        pstmtdup.close();
        pstmtdup = null;
        if (retValuedup > 0) {
            this.log.info("request already existed for msg -> " + hdrs[0]);
            return true;
        }
        int request_upd = 0;
        String sqlupd = "SELECT r_request_id   FROM r_request  WHERE ad_client_id = ?    AND summary LIKE 'FROM: ' || ? || '%'    AND (   documentno =               SUBSTR                  (?,                   INSTR                       (?,                        '<'                       )                  )         OR (    ? LIKE 'Re: %'             AND summary =                       'FROM: '                    || ?                    || CHR (10)                    || SUBSTR (?, 5)            )        ) ";
        CPreparedStatement pstmtupd = null;
        pstmtupd = DB.prepareStatement(sqlupd, null);
        pstmtupd.setInt(1, this.getAD_Client_ID());
        pstmtupd.setString(2, fromAddress);
        pstmtupd.setString(3, msg.getSubject());
        pstmtupd.setString(4, msg.getSubject());
        pstmtupd.setString(5, msg.getSubject());
        pstmtupd.setString(6, fromAddress);
        pstmtupd.setString(7, msg.getSubject());
        ResultSet rsupd = pstmtupd.executeQuery();
        if (rsupd.next()) {
            request_upd = rsupd.getInt(1);
        }
        rsupd.close();
        pstmtupd.close();
        pstmtupd = null;
        if (request_upd > 0) {
            this.log.info("msg -> " + hdrs[0] + " is an answer for req " + request_upd);
            return this.updateRequest(request_upd, msg);
        }
        MRequest req = new MRequest(this.getCtx(), 0, this.get_TrxName());
        req.setSummary("FROM: " + fromAddress + "\n" + msg.getSubject());
        req.setResult("FROM: " + from[0].toString() + "\n" + this.getMessage((Part)msg));
        if (hdrs != null) {
            req.setDocumentNo(hdrs[0].substring(0, 30));
        }
        if (this.R_RequestType_ID > 0) {
            req.setR_RequestType_ID(this.R_RequestType_ID);
        } else {
            req.setR_RequestType_ID();
        }
        if (this.SalesRep_ID > 0) {
            req.setSalesRep_ID(this.SalesRep_ID);
        }
        if (this.AD_Role_ID > 0) {
            req.setAD_Role_ID(this.AD_Role_ID);
        }
        if (from != null) {
            int retValueu = -1;
            String sqlu = "SELECT ad_user_id   FROM ad_user  WHERE UPPER (email) = UPPER (?)    AND ad_client_id = ?";
            CPreparedStatement pstmtu = null;
            pstmtu = DB.prepareStatement(sqlu, null);
            pstmtu.setString(1, fromAddress);
            pstmtu.setInt(2, this.getAD_Client_ID());
            ResultSet rsu = pstmtu.executeQuery();
            if (rsu.next()) {
                retValueu = rsu.getInt(1);
            }
            rsu.close();
            pstmtu.close();
            pstmtu = null;
            if (retValueu > 0) {
                req.setAD_User_ID(retValueu);
            } else if (this.AD_User_ID > 0) {
                req.setAD_User_ID(this.AD_User_ID);
            }
        }
        if (req.getAD_User_ID() > 0 && (us = new MUser(this.getCtx(), req.getAD_User_ID(), this.get_TrxName())).getC_BPartner_ID() > 0) {
            req.setC_BPartner_ID(us.getC_BPartner_ID());
        }
        if (req.getC_BPartner_ID() <= 0 && this.C_BPartner_ID > 0) {
            req.setC_BPartner_ID(this.C_BPartner_ID);
        }
        req.setStartDate(new Timestamp(msg.getSentDate().getTime()));
        if (this.p_DefaultConfidentiality != null) {
            req.setConfidentialType(this.p_DefaultConfidentiality);
            req.setConfidentialTypeEntry(this.p_DefaultConfidentiality);
        }
        if (this.p_DefaultPriority != null) {
            req.setPriority(this.p_DefaultPriority);
            req.setPriorityUser(this.p_DefaultPriority);
        }
        if (req.save(this.get_TrxName())) {
            this.log.info("created request " + req.getR_Request_ID() + " from msg -> " + hdrs[0]);
            if (msg.isMimeType("multipart/*")) {
                try {
                    Multipart mp = (Multipart)msg.getContent();
                    int n = mp.getCount();
                    for (int i2 = 0; i2 < n; ++i2) {
                        BodyPart part = mp.getBodyPart(i2);
                        String disposition = part.getDisposition();
                        if (disposition == null || !disposition.equals("attachment") && !disposition.equals("inline")) continue;
                        MAttachment attach = req.createAttachment();
                        InputStream in = part.getInputStream();
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        int BUF_SIZE = 256;
                        byte[] buffer = new byte[256];
                        int bytesRead = -1;
                        while ((bytesRead = in.read(buffer)) > -1) {
                            out.write(buffer, 0, bytesRead);
                        }
                        in.close();
                        byte[] bytes = out.toByteArray();
                        attach.addEntry(part.getFileName(), bytes);
                        attach.saveEx(this.get_TrxName());
                    }
                }
                catch (IOException e) {
                    this.log.log(Level.FINE, "Error extracting attachments", e);
                }
            }
            return true;
        }
        return false;
    }

    private boolean updateRequest(int request_upd, Message msg) throws MessagingException, SQLException {
        MRequest requp = new MRequest(this.getCtx(), request_upd, this.get_TrxName());
        Address[] from = msg.getFrom();
        requp.setResult("FROM: " + from[0].toString() + "\n" + this.getMessage((Part)msg));
        return requp.save();
    }

    private int processMessage(Message msg) throws Exception {
        this.dumpEnvelope(msg);
        this.dumpBody((Part)msg);
        this.printOut(":::::::::::::::");
        this.printOut(this.getSubject(msg));
        this.printOut(":::::::::::::::");
        this.printOut(this.getMessage((Part)msg));
        this.printOut(":::::::::::::::");
        String delivery = this.getDeliveryReport((Part)msg);
        this.printOut(delivery);
        this.printOut(":::::::::::::::");
        Address[] from = msg.getFrom();
        if (from != null) {
            if (from[0].toString().equalsIgnoreCase("postmaster@CONSULTDESK")) {
                return 0;
            }
        } else {
            return 0;
        }
        return 1;
    }

    private String getSubject(Message msg) {
        try {
            String str = msg.getSubject();
            if (str != null) {
                return str.trim();
            }
        }
        catch (MessagingException e) {
            this.log.log(Level.SEVERE, "getSubject", e);
        }
        return "";
    }

    private String getMessage(Part msg) {
        StringBuffer sb = new StringBuffer();
        try {
            if (msg.isMimeType("text/plain")) {
                sb.append(msg.getContent());
            } else if (msg.isMimeType("text/*")) {
                sb.append(msg.getContent());
            } else if (msg.isMimeType("message/rfc822")) {
                sb.append(msg.getContent());
            } else if (msg.isMimeType("multipart/alternative")) {
                String plainText = null;
                String otherStuff = null;
                Multipart mp = (Multipart)msg.getContent();
                int count = mp.getCount();
                for (int i2 = 0; i2 < count; ++i2) {
                    BodyPart part = mp.getBodyPart(i2);
                    Object content = part.getContent();
                    if (content == null || content.toString().trim().length() == 0) continue;
                    if (part.isMimeType("text/plain")) {
                        plainText = content.toString();
                        continue;
                    }
                    otherStuff = content.toString();
                }
                if (plainText != null) {
                    sb.append(plainText);
                } else if (otherStuff != null) {
                    sb.append(otherStuff);
                }
            } else if (msg.isMimeType("multipart/*")) {
                Multipart mp = (Multipart)msg.getContent();
                int count = mp.getCount();
                for (int i3 = 0; i3 < count; ++i3) {
                    String str = this.getMessage((Part)mp.getBodyPart(i3));
                    if (str.length() <= 0) continue;
                    if (sb.length() > 0) {
                        sb.append("\n-----\n");
                    }
                    sb.append(str);
                }
            } else {
                Object o = msg.getContent();
                if (o instanceof String) {
                    sb.append(o);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getMessage", e);
        }
        return sb.toString().trim();
    }

    private String getDeliveryReport(Part msg) {
        try {
            if (msg.isMimeType("multipart/report")) {
                String deliveryMessage = null;
                String otherStuff = null;
                Multipart mp = (Multipart)msg.getContent();
                int count = mp.getCount();
                for (int i2 = 0; i2 < count; ++i2) {
                    BodyPart part = mp.getBodyPart(i2);
                    Object content = part.getContent();
                    if (content == null) continue;
                    if (part.isMimeType("message/*")) {
                        deliveryMessage = this.getDeliveredReportDetail((Part)part);
                        continue;
                    }
                    otherStuff = content.toString().trim();
                }
                if (deliveryMessage != null) {
                    return deliveryMessage;
                }
                return otherStuff;
            }
            if (msg.isMimeType("message/*")) {
                return this.getDeliveredReportDetail(msg);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getDeliveryReport", e);
        }
        return null;
    }

    private String getDeliveredReportDetail(Part part) throws Exception {
        String finalRecipient;
        int atIndex;
        Object content = part.getContent();
        if (content == null) {
            return null;
        }
        String deliveryMessage = null;
        if (content instanceof InputStream) {
            int c;
            StringBuffer sb = new StringBuffer();
            InputStream is = (InputStream)content;
            while ((c = is.read()) != -1) {
                sb.append((char)c);
            }
            deliveryMessage = sb.toString().trim();
        } else {
            deliveryMessage = content.toString().trim();
        }
        if (deliveryMessage == null) {
            return null;
        }
        int index = deliveryMessage.indexOf("Final-Recipient:");
        if (index != -1 && (atIndex = (finalRecipient = deliveryMessage.substring(index)).indexOf("@")) != -1) {
            index = finalRecipient.lastIndexOf(32, atIndex);
            if (index != -1) {
                finalRecipient = finalRecipient.substring(index + 1);
            }
            if ((atIndex = finalRecipient.indexOf("@")) != -1) {
                index = finalRecipient.indexOf(32, atIndex);
            }
            if (index != -1) {
                finalRecipient = finalRecipient.substring(0, index);
            }
            if ((index = finalRecipient.indexOf(10)) != -1) {
                finalRecipient = finalRecipient.substring(0, index);
            }
            return finalRecipient.trim();
        }
        return deliveryMessage;
    }

    private void dumpEnvelope(Message m) throws Exception {
        int i2;
        StringBuffer sb1;
        int j;
        this.printOut("-----------------------------------------------------------------");
        Address[] a2 = m.getFrom();
        if (a2 != null) {
            for (j = 0; j < a2.length; ++j) {
                this.printOut("FROM: " + a2[j].toString());
            }
        }
        if ((a2 = m.getRecipients(Message.RecipientType.TO)) != null) {
            for (j = 0; j < a2.length; ++j) {
                this.printOut("TO: " + a2[j].toString());
            }
        }
        this.printOut("SUBJECT: " + m.getSubject());
        Date d = m.getSentDate();
        this.printOut("SendDate: " + (d != null ? d.toString() : "UNKNOWN"));
        Flags flags = m.getFlags();
        StringBuffer sb = new StringBuffer();
        Flags.Flag[] sf = flags.getSystemFlags();
        boolean first = true;
        for (int i3 = 0; i3 < sf.length; ++i3) {
            String s;
            Flags.Flag f = sf[i3];
            if (f == Flags.Flag.ANSWERED) {
                s = "\\Answered";
            } else if (f == Flags.Flag.DELETED) {
                s = "\\Deleted";
            } else if (f == Flags.Flag.DRAFT) {
                s = "\\Draft";
            } else if (f == Flags.Flag.FLAGGED) {
                s = "\\Flagged";
            } else if (f == Flags.Flag.RECENT) {
                s = "\\Recent";
            } else {
                if (f != Flags.Flag.SEEN) continue;
                s = "\\Seen";
            }
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(s);
        }
        String[] uf = flags.getUserFlags();
        for (int i4 = 0; i4 < uf.length; ++i4) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(uf[i4]);
        }
        this.printOut("FLAGS: " + sb.toString());
        String[] hdrs = m.getHeader("X-Mailer");
        if (hdrs != null) {
            sb1 = new StringBuffer("X-Mailer: ");
            for (i2 = 0; i2 < hdrs.length; ++i2) {
                sb1.append(hdrs[i2]).append("  ");
            }
            this.printOut(sb1.toString());
        } else {
            this.printOut("X-Mailer NOT available");
        }
        hdrs = m.getHeader("Message-ID");
        if (hdrs != null) {
            sb1 = new StringBuffer("Message-ID: ");
            for (i2 = 0; i2 < hdrs.length; ++i2) {
                sb1.append(hdrs[i2]).append("  ");
            }
            this.printOut(sb1.toString());
        } else {
            this.printOut("Message-ID NOT available");
        }
        this.printOut("ALL HEADERs:");
        Enumeration en = m.getAllHeaders();
        while (en.hasMoreElements()) {
            Header hdr = (Header)en.nextElement();
            this.printOut("  " + hdr.getName() + " = " + hdr.getValue());
        }
        this.printOut("-----------------------------------------------------------------");
    }

    private void dumpBody(Part p2) throws Exception {
        this.printOut("=================================================================");
        this.printOut("CONTENT-TYPE: " + p2.getContentType());
        if (p2.isMimeType("text/plain")) {
            this.printOut("Plain text ---------------------------");
            this.printOut((String)p2.getContent());
        } else if (p2.getContentType().toUpperCase().startsWith("TEXT")) {
            this.printOut("Other text ---------------------------");
            this.printOut((String)p2.getContent());
        } else if (p2.isMimeType("multipart/*")) {
            this.printOut("Multipart ---------------------------");
            Multipart mp = (Multipart)p2.getContent();
            int count = mp.getCount();
            for (int i2 = 0; i2 < count; ++i2) {
                this.dumpBody((Part)mp.getBodyPart(i2));
            }
        } else if (p2.isMimeType("message/rfc822")) {
            this.printOut("Nested ---------------------------");
            this.dumpBody((Part)p2.getContent());
        } else {
            Object o = p2.getContent();
            if (o instanceof String) {
                this.printOut("This is a string ---------------------------");
                this.printOut((String)o);
            } else if (o instanceof InputStream) {
                this.printOut("This is just an input stream ---------------------------");
            } else {
                this.printOut("This is an unknown type ---------------------------");
                this.printOut(o.toString());
            }
        }
        this.printOut("=================================================================");
    }

    private void printOut(String s) {
        this.log.finer(s);
    }
}

