/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MInterestArea;
import org.compiere.model.MMailText;
import org.compiere.model.MStore;
import org.compiere.model.MUser;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Msg;

public class ProcessPRequestMail
extends SvrProcess {
    private int m_R_MailText_ID = -1;
    private MMailText m_MailText = null;
    private int m_AD_User_ID = -1;
    private MClient m_client = null;
    private MUser m_from = null;
    private ArrayList<Integer> m_list = new ArrayList();
    private int m_counter = 0;
    private int m_errors = 0;
    private int m_R_InterestArea_ID = -1;
    private MInterestArea m_ia = null;
    private int m_C_BP_Group_ID = -1;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("R_InterestArea_ID")) {
                    this.m_R_InterestArea_ID = para[i].getParameterAsInt();
                } else if (name.equals("R_MailText_ID")) {
                    this.m_R_MailText_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_BP_Group_ID")) {
                    this.m_C_BP_Group_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_User_ID")) {
                    this.m_AD_User_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("R_MailText_ID=" + this.m_R_MailText_ID);
        this.m_MailText = new MMailText(this.getCtx(), this.m_R_MailText_ID, this.get_TrxName());
        if (this.m_MailText.getR_MailText_ID() == 0) {
            throw new Exception("Not found @R_MailText_ID@=" + this.m_R_MailText_ID);
        }
        this.m_client = MClient.get(this.getCtx());
        if (this.m_client.getAD_Client_ID() == 0) {
            throw new Exception("Not found @AD_Client_ID@");
        }
        if (this.m_client.getSMTPHost() == null || this.m_client.getSMTPHost().length() == 0) {
            throw new Exception("No SMTP Host found");
        }
        if (this.m_AD_User_ID > 0) {
            this.m_from = new MUser(this.getCtx(), this.m_AD_User_ID, this.get_TrxName());
            if (this.m_from.getAD_User_ID() == 0) {
                throw new Exception("No found @AD_User_ID@=" + this.m_AD_User_ID);
            }
        }
        this.log.fine("From " + this.m_from);
        long start = System.currentTimeMillis();
        if (this.m_R_InterestArea_ID > 0) {
            this.sendInterestArea();
        }
        if (this.m_C_BP_Group_ID > 0) {
            this.sendBPGroup();
        }
        return "@Created@=" + this.m_counter + ", @Errors@=" + this.m_errors + " - " + (System.currentTimeMillis() - start) + "ms";
    }

    private void sendInterestArea() {
        this.log.info("R_InterestArea_ID=" + this.m_R_InterestArea_ID);
        this.m_ia = MInterestArea.get(this.getCtx(), this.m_R_InterestArea_ID);
        String unsubscribe = null;
        if (this.m_ia.isSelfService()) {
            unsubscribe = "\n\n---------.----------.----------.----------.----------.----------\n" + Msg.getElement(this.getCtx(), "R_InterestArea_ID") + ": " + this.m_ia.getName() + "\n" + Msg.getMsg(this.getCtx(), "UnsubscribeInfo") + "\n";
            MStore[] wstores = MStore.getOfClient(this.m_client);
            int index = 0;
            int i = 0;
            while (i < wstores.length) {
                if (wstores[i].isDefault()) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (wstores.length > 0) {
                unsubscribe = String.valueOf(unsubscribe) + wstores[index].getWebContext(true);
            }
        }
        String sql = "SELECT u.Name, u.EMail, u.AD_User_ID FROM R_ContactInterest ci INNER JOIN AD_User u ON (ci.AD_User_ID=u.AD_User_ID) WHERE ci.IsActive='Y' AND u.IsActive='Y' AND ci.OptOutDate IS NULL AND u.EMail IS NOT NULL AND ci.R_InterestArea_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.m_R_InterestArea_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Boolean ok = this.sendIndividualMail(rs.getString(1), rs.getString(2), null, rs.getString(3), rs.getString(4), rs.getString(5), rs.getInt(6), rs.getString(7));
                if (ok == null) continue;
                if (ok.booleanValue()) {
                    ++this.m_counter;
                    continue;
                }
                ++this.m_errors;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sql, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        pstmt = null;
        this.m_ia = null;
    }

    private void sendBPGroup() {
        this.log.info("C_PaymentRequest_ID=" + this.m_C_BP_Group_ID);
        String sql = "select bp.name,p.email,p.description,bp.value || '-' || bp.digito as rut,i.documentno, p.amt,p.formapago  from C_PaymentRequestLine p  inner join c_invoice i on (p.c_invoice_id=i.c_invoice_id)  inner join c_bpartner bp on (i.c_bpartner_id=bp.c_bpartner_id)  where p.email is not null and p.C_PaymentRequest_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.m_C_BP_Group_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Boolean ok = this.sendIndividualMail(rs.getString(1), rs.getString(2), null, rs.getString(3), rs.getString(4), rs.getString(5), rs.getInt(6), rs.getString(7));
                if (ok == null) continue;
                if (ok.booleanValue()) {
                    ++this.m_counter;
                    continue;
                }
                ++this.m_errors;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sql, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        pstmt = null;
    }

    private Boolean sendIndividualMail(String Name, String Correo, String unsubscribe, String Detalle, String Rut, String Factura, int Monto, String Forma) {
        String Vdesde = "pagoproveedores@aguasantofagasta.cl";
        String Asunto = "Comunica Pago Aguas Antofagasta S.A.";
        String message = Detalle;
        String Vrut = Rut;
        String Vfactura = Factura;
        int Vmonto = Monto;
        String Vname = Name;
        String Vforma = Forma;
        if (unsubscribe != null) {
            message = String.valueOf(message) + unsubscribe;
        }
        EMail email = this.m_client.createEMail(this.m_from, Correo, Asunto, message);
        if (this.m_MailText.isHtml()) {
            email.setMessageHTML(Asunto, message);
        } else {
            Date fecha = new Date();
            DateFormat df = DateFormat.getDateInstance();
            DateFormat df1 = DateFormat.getDateInstance(1);
            String s = df.format(fecha);
            String s1 = df1.format(fecha);
            email.setFrom(Vdesde);
            email.setSubject(Asunto);
            StringBuilder sb = new StringBuilder();
            sb.append("\n Estimado Provedor, Comunico a usted que con fecha: " + s1 + "\n, se ha Generado: " + Vforma + ", por el Pago del Siguiente Documento. " + "\n Rut: " + Vrut + "\n Nombre o Raz\u00f3n Social: " + Vname + "\n " + "\n " + "\n Nro Documento: " + Vfactura + "\n Monto: " + Vmonto + "\n " + "\n " + "\n En caso de consultas, agradeceremos enviar correo electr\u00f3nico a pagoproveedores@aguasantofagasta.cl" + "\n " + "\n " + "\n Saluda atentamente a Usted." + "\n Aguas de Antofagasta S.A.");
            email.setMessageText(sb.toString());
        }
        if (!email.isValid() && !email.isValid(true)) {
            this.log.warning("NOT VALID - " + email);
            return Boolean.FALSE;
        }
        boolean OK = "OK".equals(email.send());
        if (OK) {
            this.log.fine(Correo);
        } else {
            this.log.warning("FAILURE - " + Correo);
        }
        this.addLog(0, null, null, String.valueOf(OK ? "@OK@" : "@ERROR@") + " - " + Correo);
        return new Boolean(OK);
    }
}

