/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.Query;
import org.compiere.model.X_M_Product;
import org.compiere.model.X_M_Production;
import org.compiere.model.X_M_ProductionPlan;
import org.compiere.model.X_M_RelatedProduct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class ProcessGenerateProduction
extends SvrProcess {
    private int p_Record_ID = 0;
    private int m_product_idP = 0;
    private int loteP = 0;
    private int m_locator_id;
    private String m_sql = null;
    private Timestamp p_DateDoc_To = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Product_ID")) {
                    this.m_product_idP = ((Number)para[i].getParameter()).intValue();
                } else if (name.equals("Lote")) {
                    this.loteP = para[i].getParameterAsInt();
                } else if (name.equals("MovementDate")) {
                    this.p_DateDoc_To = (Timestamp)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_Record_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        X_M_Product product = new X_M_Product(this.getCtx(), this.m_product_idP, this.get_TrxName());
        this.m_sql = "select name from m_product where m_product_id = ?";
        this.m_locator_id = DB.getSQLValue(null, this.m_sql, this.m_product_idP);
        X_M_Production production = new X_M_Production(this.getCtx(), this.p_Record_ID, this.get_TrxName());
        production.setName(String.valueOf(Integer.toString(this.loteP).trim()) + " " + product.getName().trim());
        production.setMovementDate(this.p_DateDoc_To);
        production.saveEx();
        this.m_sql = "select m_locator_id from m_product where m_product_id = ?";
        this.m_locator_id = DB.getSQLValue(null, this.m_sql, this.m_product_idP);
        X_M_ProductionPlan pp = new X_M_ProductionPlan(this.getCtx(), 0, this.get_TrxName());
        pp.setM_Production_ID(production.getM_Production_ID());
        pp.setM_Product_ID(this.m_product_idP);
        pp.setProductionQty(new BigDecimal(1));
        pp.setM_Locator_ID(this.m_locator_id);
        pp.setLine(10);
        pp.saveEx();
        String whereClause = "M_Product_ID=? ";
        List rProducts = new Query(this.getCtx(), "M_RelatedProduct", whereClause, this.get_TrxName()).setParameters(this.m_product_idP).setOrderBy("RelatedProduct_ID").list();
        for (X_M_RelatedProduct rp : rProducts) {
            product = new X_M_Product(this.getCtx(), rp.getRelatedProduct_ID(), this.get_TrxName());
            X_M_Production productionI = new X_M_Production(this.getCtx(), 0, this.get_TrxName());
            productionI.setName(String.valueOf(Integer.toString(this.loteP).trim()) + " " + product.getName().trim());
            productionI.setMovementDate(production.getMovementDate());
            productionI.saveEx();
            this.m_sql = "select m_locator_id from m_product where m_product_id = ?";
            this.m_locator_id = DB.getSQLValue(null, this.m_sql, rp.getRelatedProduct_ID());
            X_M_ProductionPlan ppi = new X_M_ProductionPlan(this.getCtx(), 0, this.get_TrxName());
            ppi.setM_Production_ID(productionI.getM_Production_ID());
            ppi.setM_Product_ID(rp.getRelatedProduct_ID());
            ppi.setProductionQty(new BigDecimal(1));
            ppi.setM_Locator_ID(this.m_locator_id);
            ppi.setLine(10);
            ppi.saveEx();
        }
        return "@OK@";
    }
}

