/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaGL;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MDocType;
import org.compiere.model.MGLCategory;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MOrg;
import org.compiere.model.MPeriod;
import org.compiere.model.PO;
import org.compiere.model.X_GL_JournalBatch;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProcessDevengado
extends SvrProcess {
    private String p_Type;
    private BigDecimal p_Rate;
    private int p_Currency_ID;
    private int p_Org_ID;
    private int p_Period_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DevType")) {
                    this.p_Type = (String)para[i].getParameter();
                } else if (name.equals("C_Currency_ID")) {
                    this.p_Currency_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Period_ID")) {
                    this.p_Period_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        String sql = "";
        int count = 0;
        sql = this.p_Type.equals("I") ? "select c.C_RECEIVABLE_ACCT as Account_ID,i.c_invoice_id,invoiceopen(i.c_invoice_id,null),currencyConvert(invoiceopen(i.c_invoice_id,null),i.C_Currency_ID,228,i.DateAcct,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID) as posted,doc.docbasetype from c_invoice i  inner join C_BP_CUSTOMER_ACCT c on (i.c_bpartner_id=c.c_bpartner_id)  inner join C_DocType doc on (i.c_doctype_id=doc.c_doctype_id)  where invoiceopen(c_invoice_id,null)>0 and i.issotrx='Y' and i.docstatus in ('CO','CL') and doc.docbasetype in ('ARI','ARC') and i.c_currency_id =   ?   and (i.ad_org_id = ? OR i.AD_Org_ID in (Select oi.AD_ORG_ID from AD_orginfo oi where oi.PARENT_ORG_ID=?) )  UNION  select c.V_LIABILITY_ACCT as Account_ID,c_invoice_id ,invoiceopen(i.c_invoice_id,null),currencyConvert(invoiceopen(i.c_invoice_id,null),i.C_Currency_ID,228,i.DateAcct,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID) as posted,doc.docbasetype  from c_invoice i  inner join C_BP_VENDOR_ACCT c on (i.c_bpartner_id=c.c_bpartner_id)  inner join C_DocType doc on (i.c_doctype_id=doc.c_doctype_id)  where invoiceopen(c_invoice_id,null)>0 and i.issotrx='N' and i.docstatus in ('CO','CL') and doc.docbasetype in ('API','APC') and i.c_currency_id =   ?   and (i.ad_org_id = ? OR i.AD_Org_ID in (Select oi.AD_ORG_ID from AD_orginfo oi where oi.PARENT_ORG_ID=?) )" : "select c.C_Prepayment_Acct,i.c_payment_id, paymentAvailable(i.c_payment_id), currencyConvert(paymentAvailable(i.c_payment_id),i.C_Currency_ID,228,i.DateAcct,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID) as posted, i.isreceipt from c_payment i  inner join C_BP_CUSTOMER_ACCT c on (i.c_bpartner_id=c.c_bpartner_id) where paymentAvailable(i.c_payment_id)>0 and i.isreceipt='Y' and i.docstatus in ('CO','CL') and c_currency_id =   ?   and (i.ad_org_id = ? OR i.AD_Org_ID in (Select oi.AD_ORG_ID from AD_orginfo oi where oi.PARENT_ORG_ID=?) ) union  select V_Prepayment_Acct,c_payment_id, paymentAvailable(c_payment_id), currencyConvert(paymentAvailable(c_payment_id),i.C_Currency_ID,228,i.DateAcct,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID) as posted, i.isreceipt from c_payment i inner join C_BP_VENDOR_ACCT c on (i.c_bpartner_id=c.c_bpartner_id) where paymentAvailable(i.c_payment_id)>0 and i.isreceipt='N' and i.docstatus in ('CO','CL') and c_currency_id =   ?   and (i.ad_org_id = ? OR i.AD_Org_ID in (Select oi.AD_ORG_ID from AD_orginfo oi where oi.PARENT_ORG_ID=?) )";
        MOrg org = MOrg.get(this.getCtx(), this.p_Org_ID);
        if (org.get_ValueAsBoolean("IsCostCenter")) {
            return "Debe seleccionar una Organizacion Padre";
        }
        if (this.p_Currency_ID == 228) {
            return "Debe seleccionar una Moneda Distinta a CLP";
        }
        MPeriod current = MPeriod.get(this.getCtx(), this.p_Period_ID);
        this.p_Rate = MConversionRate.getRate(this.p_Currency_ID, 228, current.getEndDate(), 0, this.getAD_Client_ID(), this.p_Org_ID);
        if (this.p_Rate == null) {
            return "no se encontro una tasa de cambio para lo moneda indicada en el ultimo dia del periodo";
        }
        String msg = this.searchSame(this.p_Org_ID, current.getC_Period_ID(), this.p_Currency_ID);
        if (msg.length() > 0) {
            return msg;
        }
        MPeriod after = this.getPeriodAnt(current);
        this.reverseBeforeBatch(this.p_Org_ID, after.getC_Period_ID());
        MAcctSchema acct = MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName())[0];
        MAcctSchemaGL acctgl = acct.getAcctSchemaGL();
        if (acctgl.get_ValueAsInt("CMDev_Acct") <= 0) {
            return "No se encuentra definida la cuenta para Diferencia de Cambio";
        }
        PO batch = null;
        MJournal journal = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.p_Currency_ID);
            pstmt.setInt(2, this.p_Org_ID);
            pstmt.setInt(3, this.p_Org_ID);
            pstmt.setInt(4, this.p_Currency_ID);
            pstmt.setInt(5, this.p_Org_ID);
            pstmt.setInt(6, this.p_Org_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (batch == null) {
                    MClient client = MClient.get(this.getCtx(), Env.getAD_Client_ID(this.getCtx()));
                    MAcctSchema as = MAcctSchema.getClientAcctSchema(this.getCtx(), Env.getAD_Client_ID(this.getCtx()))[0];
                    batch = new MJournalBatch(this.getCtx(), 0, this.get_TrxName());
                    ((MJournalBatch)batch).setClientOrg(this.getAD_Client_ID(), this.p_Org_ID);
                    ((X_GL_JournalBatch)batch).setDescription("Devengado de " + (this.p_Type.equals("I") ? "Facturas" : "Pagos"));
                    ((X_GL_JournalBatch)batch).setDateDoc(current.getEndDate());
                    ((MJournalBatch)batch).setDateAcct(current.getEndDate());
                    ((X_GL_JournalBatch)batch).setC_DocType_ID(MDocType.getOfDocBaseType(this.getCtx(), "GLJ")[0].getC_DocType_ID());
                    ((X_GL_JournalBatch)batch).setGL_Category_ID(MGLCategory.getDefault(this.getCtx(), "M").getGL_Category_ID());
                    ((X_GL_JournalBatch)batch).setC_Period_ID(current.getC_Period_ID());
                    ((X_GL_JournalBatch)batch).setC_Currency_ID(client.getC_Currency_ID());
                    batch.set_ValueOfColumn("C_CurrencyFrom_ID", (Object)this.p_Currency_ID);
                    batch.save();
                    journal = new MJournal((MJournalBatch)batch);
                    journal.setDescription("Devengado de " + (this.p_Type.equals("I") ? "Facturas" : "Pagos"));
                    journal.setC_AcctSchema_ID(as.getC_AcctSchema_ID());
                    journal.setGL_Category_ID(MGLCategory.getDefault(this.getCtx(), "D").getGL_Category_ID());
                    journal.setC_ConversionType_ID(114);
                    journal.save();
                }
                BigDecimal cambioActual = rs.getBigDecimal(3).multiply(this.p_Rate);
                BigDecimal posted = rs.getBigDecimal(4);
                String base = rs.getString(5);
                BigDecimal credit = Env.ZERO;
                BigDecimal debit = Env.ZERO;
                if (cambioActual.compareTo(posted) > 0) {
                    if (this.p_Type.equals("I") && (base.equals("ARI") || base.equals("APC"))) {
                        debit = cambioActual.subtract(posted);
                    } else if (this.p_Type.equals("I") && (base.equals("API") || base.equals("ARC"))) {
                        credit = cambioActual.subtract(posted);
                    } else if (!this.p_Type.equals("I") && base.equals("Y")) {
                        credit = cambioActual.subtract(posted);
                    } else if (!this.p_Type.equals("I") && base.equals("N")) {
                        debit = cambioActual.subtract(posted);
                    }
                } else {
                    if (cambioActual.compareTo(posted) == 0) continue;
                    if (this.p_Type.equals("I") && (base.equals("ARI") || base.equals("APC"))) {
                        credit = posted.subtract(cambioActual);
                    } else if (this.p_Type.equals("I") && (base.equals("API") || base.equals("ARC"))) {
                        debit = posted.subtract(cambioActual);
                    } else if (!this.p_Type.equals("I") && base.equals("Y")) {
                        debit = cambioActual.subtract(posted);
                    } else if (!this.p_Type.equals("I") && base.equals("N")) {
                        credit = cambioActual.subtract(posted);
                    }
                }
                MJournalLine line1 = new MJournalLine(journal);
                line1.setAmtSourceDr(debit);
                line1.setAmtSourceCr(credit);
                line1.setAmtAcct(debit, credit);
                line1.setC_ValidCombination_ID(rs.getInt(1));
                if (this.p_Type.equals("I")) {
                    line1.set_CustomColumn("C_Invoice_ID", rs.getInt(2));
                } else {
                    line1.set_CustomColumn("C_Payment_ID", rs.getInt(2));
                }
                line1.save();
                MJournalLine line2 = new MJournalLine(journal);
                line2.setAmtSourceDr(credit);
                line2.setAmtSourceCr(debit);
                line2.setAmtAcct(credit, debit);
                line2.setC_ValidCombination_ID(acctgl.get_ValueAsInt("CMDev_Acct"));
                if (this.p_Type.equals("I")) {
                    line2.set_CustomColumn("C_Invoice_ID", rs.getInt(2));
                } else {
                    line2.set_CustomColumn("C_Payment_ID", rs.getInt(2));
                }
                line2.save();
                ++count;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        batch.save();
        if (count > 0) {
            return String.valueOf(count) + " Documentos Encontrados   Journal : " + ((X_GL_JournalBatch)batch).getDocumentNo();
        }
        return "Ningun documento encontrado";
    }

    public MPeriod getPeriodAnt(MPeriod actual) {
        MPeriod retValue = null;
        CPreparedStatement pstmt = null;
        String mysql = "SELECT * from C_Period where C_Year_ID=? and PeriodNo=?";
        try {
            pstmt = DB.prepareStatement(mysql, this.get_TrxName());
            if (actual.getPeriodNo() == 1) {
                pstmt.setInt(1, actual.getC_Year_ID() - 1);
                pstmt.setInt(2, 12);
            } else {
                pstmt.setInt(1, actual.getC_Year_ID());
                pstmt.setInt(2, actual.getPeriodNo() - 1);
            }
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MPeriod(this.getCtx(), rs, this.get_TrxName());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return retValue;
    }

    public void reverseBeforeBatch(int Org_ID, int Period_ID) {
        CPreparedStatement pstmt = null;
        String mysql = "SELECT * from GL_JournalBatch where C_Period_ID=? and AD_Org_ID=? and upper(description) like '%DEVENGADO DE " + (this.p_Type.equals("I") ? "FACTURAS" : "PAGOS") + "%'";
        try {
            pstmt = DB.prepareStatement(mysql, this.get_TrxName());
            pstmt.setInt(1, Period_ID);
            pstmt.setInt(2, Org_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                MJournalBatch batch = new MJournalBatch(this.getCtx(), rs, this.get_TrxName());
                if (this.searchReverso(Org_ID, batch.getDocumentNo()) > 0) {
                    return;
                }
                MJournal[] journals = batch.getJournals(true);
                MJournalBatch reverse = new MJournalBatch(batch);
                reverse.setC_Period_ID(0);
                reverse.setDateDoc(new Timestamp(System.currentTimeMillis()));
                reverse.setDateAcct(reverse.getDateDoc());
                String description = reverse.getDescription();
                description = description == null ? "** Reverso" + batch.getDocumentNo() + " **" : String.valueOf(description) + " ** Reverso" + batch.getDocumentNo() + " **";
                reverse.setDescription(description);
                reverse.save();
                int i = 0;
                while (i < journals.length) {
                    MJournal journal = journals[i];
                    if (journal.isActive()) {
                        journal.reverseAccrualIt(reverse.getGL_JournalBatch_ID());
                        journal.save();
                    }
                    ++i;
                }
                batch.completeIt();
                batch.setProcessed(true);
                batch.save();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public int searchReverso(int Org_ID, String documentNo) {
        CPreparedStatement pstmt = null;
        int count = 0;
        String mysql = "SELECT * from GL_JournalBatch where DocStatus IN ('DR','CO') and  AD_Org_ID=? and upper(description) like '%REVERSO% " + documentNo + "%'";
        try {
            pstmt = DB.prepareStatement(mysql, this.get_TrxName());
            pstmt.setInt(1, Org_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                ++count;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return count;
    }

    public String searchSame(int Org_ID, int Period_ID, int Currency_ID) {
        CPreparedStatement pstmt = null;
        String msg = "";
        String mysql = "SELECT * from GL_JournalBatch where DocStatus IN ('DR','CO') and C_Period_ID=? and AD_Org_ID=? and C_CurrencyFrom_ID=? and upper(description) like '%DEVENGADO DE " + (this.p_Type.equals("I") ? "FACTURAS" : "PAGOS") + "%'";
        try {
            pstmt = DB.prepareStatement(mysql, this.get_TrxName());
            pstmt.setInt(1, Period_ID);
            pstmt.setInt(2, Org_ID);
            pstmt.setInt(3, Currency_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                msg = "Ya existe un documento devengado para este periodo : " + rs.getString("DocumentNo");
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return msg;
    }
}

